/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class LevelDesigner {
    public static final int Ammunition = 16;
    int currentLevel = 10;
    int currentTheme;
    int creatureIndex = -1;
    static int startLevel = 0;
    static int totalnofLevel = 50;
    Level level;
    CreatureSpec[] creatureSpecs;
    Group groupManager;
    Player player;
    private long creaturePoints;
    private long extraPoints;
    private long powerupPoints;
    boolean extraLifeAt10 = true;
    boolean extraLifeAt20 = true;
    boolean extraLifeAt30 = true;
    boolean extraLifeAt40 = true;
    Vector randomCreatureSpecs;
    LevelInterface levelInterface;

    public LevelDesigner(LevelInterface levelInterface) {
        startLevel = 10;
        this.currentTheme = 0;
        this.level = null;
        this.creatureSpecs = null;
        this.creaturePoints = 0L;
        this.extraPoints = 0L;
        this.powerupPoints = 0L;
        this.groupManager = new Group();
        this.levelInterface = levelInterface;
    }

    private boolean isAvailable(int check) {
        for (int x = 0; x < this.randomCreatureSpecs.size(); ++x) {
            Integer integer = (Integer)this.randomCreatureSpecs.elementAt(x);
            if (check != integer) continue;
            return false;
        }
        return true;
    }

    private void AddValueRandomCreatureSpecs(int creatureSpecsLength) {
        int value = MainCanvas.generator.nextInt(creatureSpecsLength);
        if (this.randomCreatureSpecs.isEmpty()) {
            this.randomCreatureSpecs.addElement(new Integer(0));
        } else {
            while (!this.isAvailable(value)) {
                value = MainCanvas.generator.nextInt(creatureSpecsLength);
            }
            this.randomCreatureSpecs.addElement(new Integer(value));
        }
    }

    public void nextLevel() {
        this.creatureIndex = -1;
        if (this.currentLevel == 19) {
            this.currentLevel = 50;
        }
        if (this.currentLevel == 32) {
            this.currentLevel = 19;
        }
        if (this.currentLevel == 10) {
            this.currentLevel = 32;
        }
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void UpdatePoints(long creaturePoints, long extraPoints, long powerupPoints) {
        this.creaturePoints += creaturePoints;
        this.extraPoints += extraPoints;
        this.powerupPoints += powerupPoints;
    }

    public boolean isNewThemeRequired() {
        if (this.currentLevel / 5 != this.currentTheme) {
            this.currentTheme = this.currentLevel / 5;
            return true;
        }
        return false;
    }

    public int getCurrentTheme() {
        return this.currentTheme;
    }

    private void FillCreatureSpecs(Vector creatures) {
        int index = 0;
        for (int i = 0; i < creatures.size(); i += 2) {
            Integer K = (Integer)creatures.elementAt(i + 1);
            for (int k = 0; k < K; ++k) {
                Integer type = (Integer)creatures.elementAt(i);
                this.creatureSpecs[index] = new CreatureSpec(type);
                ++index;
            }
        }
    }

    public void CreateLevel(Player player) {
        int i;
        this.Release();
        this.player = player;
        Vector<Integer> powerupsVec = new Vector<Integer>();
        Vector<Integer> creatures = new Vector<Integer>();
        int nofCreatures = 0;
        if (this.randomCreatureSpecs != null) {
            this.randomCreatureSpecs.removeAllElements();
            this.randomCreatureSpecs = null;
        }
        this.randomCreatureSpecs = new Vector();
        switch (this.currentLevel) {
            case 0: {
                player.setAmmo(16);
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(13));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(4));
                nofCreatures = 11;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(1));
                this.groupManager.ConfigureCreature(10, this.creatureSpecs, 0, 5, true);
                this.groupManager.ConfigureCreature(10, this.creatureSpecs, 5, 7, true);
                this.groupManager.ConfigureCreature(10, this.creatureSpecs, 7, nofCreatures, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 1: {
                player.setAmmo(16);
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(13));
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(4));
                nofCreatures = 12;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(10, this.creatureSpecs, 0, 5, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 5, 8, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 8, nofCreatures, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 2: {
                player.setAmmo(16);
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(13));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(4));
                nofCreatures = 18;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 0, 10, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 10, 14, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 14, 18, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 3: {
                player.setAmmo(16);
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(13));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(4));
                nofCreatures = 20;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(6));
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 0, 12, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 12, 16, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 16, nofCreatures, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 4: {
                player.setAmmo(16);
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(13));
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(5));
                nofCreatures = 24;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(8));
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 0, 14, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 14, 19, true);
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 19, nofCreatures, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 5: {
                player.setAmmo(16);
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(13));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(6));
                nofCreatures = 28;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(9));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(1));
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 0, 16, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 16, 22, true);
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 22, nofCreatures, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 6: {
                player.setAmmo(16);
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(20));
                creatures.addElement(new Integer(13));
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(8));
                nofCreatures = 35;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(11));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 0, 20, true);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 20, 27, true);
                this.groupManager.ConfigureCreature(14, this.creatureSpecs, 27, nofCreatures, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 7: {
                player.setAmmo(16);
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(13));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(8));
                nofCreatures = 39;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(11));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(1));
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 0, 25, true);
                this.groupManager.ConfigureCreature(14, this.creatureSpecs, 25, 31, true);
                this.groupManager.ConfigureCreature(14, this.creatureSpecs, 31, nofCreatures, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 8: {
                player.setAmmo(16);
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(13));
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(10));
                nofCreatures = 47;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(1));
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 0, 30, true);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 30, 37, true);
                this.groupManager.ConfigureCreature(14, this.creatureSpecs, 37, nofCreatures, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 9: {
                nofCreatures = 1;
                player.setAmmo(16);
                if (this.extraLifeAt20) {
                    player.setLife(player.getLife() + 1);
                    this.extraLifeAt20 = false;
                }
                creatures.addElement(new Integer(5));
                creatures.addElement(new Integer(1));
                this.creatureSpecs = new CreatureSpec[1];
                for (i = 0; i < 1; ++i) {
                    this.creatureSpecs[i] = new CreatureSpec(19);
                }
                this.groupManager.ConfigureCreature(21, this.creatureSpecs, 0, this.creatureSpecs.length, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 4, "Underground");
                break;
            }
            case 10: {
                player.setAmmo(16);
                if (this.extraLifeAt10) {
                    player.setLife(player.getLife() + 1);
                    this.extraLifeAt10 = false;
                }
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(14));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(8));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(5));
                nofCreatures = 27;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 0, 14, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 14, 22, false);
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 22, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 11: {
                player.setAmmo(16);
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(8));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(10));
                nofCreatures = 20;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(11, this.creatureSpecs, 0, 2, true);
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 2, 10, false);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 10, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 12: {
                player.setAmmo(16);
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(12));
                nofCreatures = 24;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 0, 2, true);
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 2, 10, true);
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 10, nofCreatures, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 13: {
                player.setAmmo(16);
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(8));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(14));
                nofCreatures = 26;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 0, 4, true);
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 4, 12, false);
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 12, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 14: {
                player.setAmmo(16);
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(8));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(18));
                nofCreatures = 36;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 0, 10, true);
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 10, 18, false);
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 18, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 15: {
                player.setAmmo(16);
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(18));
                nofCreatures = 32;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 0, 4, true);
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 4, 14, false);
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 14, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 16: {
                player.setAmmo(16);
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(18));
                nofCreatures = 30;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(8));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 0, 2, true);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 2, 12, false);
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 12, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 17: {
                player.setAmmo(16);
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(22));
                nofCreatures = 34;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 0, 2, true);
                this.groupManager.ConfigureCreature(14, this.creatureSpecs, 2, 12, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 12, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 18: {
                player.setAmmo(16);
                creatures.addElement(new Integer(3));
                creatures.addElement(new Integer(20));
                creatures.addElement(new Integer(4));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(2));
                nofCreatures = 47;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(25));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(2));
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 0, 20, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 20, 45, false);
                this.groupManager.ConfigureCreature(18, this.creatureSpecs, 45, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 19: {
                nofCreatures = 1;
                player.setAmmo(16);
                if (this.extraLifeAt20) {
                    player.setLife(player.getLife() + 1);
                    this.extraLifeAt20 = false;
                }
                creatures.addElement(new Integer(16));
                creatures.addElement(new Integer(1));
                this.creatureSpecs = new CreatureSpec[1];
                for (i = 0; i < 1; ++i) {
                    this.creatureSpecs[i] = new CreatureSpec(17);
                }
                this.groupManager.ConfigureCreature(6, this.creatureSpecs, 0, this.creatureSpecs.length, true);
                this.level = new Level(1, creatures, this.currentLevel, 3, "Jungle");
                break;
            }
            case 20: {
                player.setAmmo(16);
                creatures.addElement(new Integer(0));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(18));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(22));
                nofCreatures = 70;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(20));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 0, 30, true);
                this.groupManager.ConfigureCreature(18, this.creatureSpecs, 30, 48, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 48, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 21: {
                player.setAmmo(16);
                creatures.addElement(new Integer(0));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(18));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(25));
                nofCreatures = 73;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(20));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 0, 30, true);
                this.groupManager.ConfigureCreature(18, this.creatureSpecs, 30, 48, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 48, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 22: {
                player.setAmmo(16);
                creatures.addElement(new Integer(0));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(20));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(25));
                nofCreatures = 75;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(20));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 0, 30, true);
                this.groupManager.ConfigureCreature(17, this.creatureSpecs, 30, 50, false);
                this.groupManager.ConfigureCreature(17, this.creatureSpecs, 50, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 23: {
                player.setAmmo(16);
                creatures.addElement(new Integer(0));
                creatures.addElement(new Integer(35));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(20));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(25));
                nofCreatures = 80;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(21));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(4, this.creatureSpecs, 0, 35, true);
                this.groupManager.ConfigureCreature(17, this.creatureSpecs, 35, 55, false);
                this.groupManager.ConfigureCreature(17, this.creatureSpecs, 55, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 24: {
                player.setAmmo(16);
                creatures.addElement(new Integer(0));
                creatures.addElement(new Integer(36));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(20));
                nofCreatures = 81;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(21));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(16, this.creatureSpecs, 0, 36, true);
                this.groupManager.ConfigureCreature(17, this.creatureSpecs, 36, 61, false);
                this.groupManager.ConfigureCreature(17, this.creatureSpecs, 61, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 25: {
                player.setAmmo(16);
                creatures.addElement(new Integer(0));
                creatures.addElement(new Integer(35));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(24));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(27));
                nofCreatures = 86;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(23));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(8));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(17, this.creatureSpecs, 0, 35, true);
                this.groupManager.ConfigureCreature(17, this.creatureSpecs, 35, 59, false);
                this.groupManager.ConfigureCreature(17, this.creatureSpecs, 59, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 26: {
                player.setAmmo(16);
                creatures.addElement(new Integer(0));
                creatures.addElement(new Integer(40));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(22));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(27));
                nofCreatures = 89;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(23));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(8));
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 0, 40, true);
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 40, 62, false);
                this.groupManager.ConfigureCreature(11, this.creatureSpecs, 62, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 27: {
                player.setAmmo(16);
                creatures.addElement(new Integer(0));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(32));
                nofCreatures = 64;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(21));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(8));
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 0, 2, true);
                this.groupManager.ConfigureCreature(11, this.creatureSpecs, 2, 32, false);
                this.groupManager.ConfigureCreature(12, this.creatureSpecs, 32, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 28: {
                player.setAmmo(16);
                creatures.addElement(new Integer(0));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(32));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(32));
                nofCreatures = 66;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(22));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(8));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(8));
                this.groupManager.ConfigureCreature(5, this.creatureSpecs, 0, 2, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 2, 34, false);
                this.groupManager.ConfigureCreature(18, this.creatureSpecs, 34, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 29: {
                nofCreatures = 2;
                player.setAmmo(16);
                if (this.extraLifeAt30) {
                    player.setLife(player.getLife() + 1);
                    this.extraLifeAt30 = false;
                }
                creatures.addElement(new Integer(12));
                creatures.addElement(new Integer(1));
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                for (i = 0; i < nofCreatures; ++i) {
                    this.creatureSpecs[i] = new CreatureSpec(18);
                }
                this.groupManager.ConfigureCreature(20, this.creatureSpecs, 0, this.creatureSpecs.length, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 0, "Underwater");
                break;
            }
            case 30: {
                player.setAmmo(16);
                creatures.addElement(new Integer(11));
                creatures.addElement(new Integer(20));
                creatures.addElement(new Integer(1));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(14));
                nofCreatures = 59;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(24));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 0, 20, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 20, 45, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 45, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 31: {
                player.setAmmo(16);
                creatures.addElement(new Integer(11));
                creatures.addElement(new Integer(20));
                creatures.addElement(new Integer(1));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(18));
                nofCreatures = 63;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(24));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 0, 20, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 20, 45, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 45, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 32: {
                player.setAmmo(16);
                creatures.addElement(new Integer(11));
                creatures.addElement(new Integer(20));
                creatures.addElement(new Integer(1));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(18));
                nofCreatures = 63;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(24));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 0, 20, true);
                this.groupManager.ConfigureCreature(9, this.creatureSpecs, 20, 45, false);
                this.groupManager.ConfigureCreature(9, this.creatureSpecs, 45, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 33: {
                player.setAmmo(16);
                creatures.addElement(new Integer(11));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(1));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(20));
                nofCreatures = 75;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(28));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 0, 25, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 25, 45, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 45, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 34: {
                player.setAmmo(16);
                creatures.addElement(new Integer(11));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(1));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(18));
                nofCreatures = 68;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(26));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 0, 25, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 25, 50, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 50, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 35: {
                player.setAmmo(16);
                creatures.addElement(new Integer(11));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(1));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(25));
                nofCreatures = 75;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(30));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 0, 25, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 25, 50, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 50, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 36: {
                player.setAmmo(16);
                creatures.addElement(new Integer(11));
                creatures.addElement(new Integer(15));
                creatures.addElement(new Integer(1));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(30));
                nofCreatures = 70;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(27));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 0, 15, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 15, 40, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 40, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 37: {
                player.setAmmo(16);
                creatures.addElement(new Integer(11));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(1));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(28));
                nofCreatures = 60;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(20));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 0, 2, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 2, 32, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 32, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 38: {
                player.setAmmo(16);
                creatures.addElement(new Integer(11));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(1));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(10));
                creatures.addElement(new Integer(36));
                nofCreatures = 68;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 0, 2, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 2, 32, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 32, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 39: {
                nofCreatures = 2;
                player.setAmmo(16);
                if (this.extraLifeAt40) {
                    player.setLife(player.getLife() + 1);
                    this.extraLifeAt40 = false;
                }
                creatures.addElement(new Integer(9));
                creatures.addElement(new Integer(1));
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.creatureSpecs[0] = new CreatureSpec(9);
                this.creatureSpecs[1] = new CreatureSpec(8);
                this.groupManager.ConfigureCreature(6, this.creatureSpecs, 0, this.creatureSpecs.length, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Swamp");
                break;
            }
            case 40: {
                player.setAmmo(16);
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(25));
                nofCreatures = 80;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(25));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(8));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(1, this.creatureSpecs, 0, 30, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 30, 55, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 55, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 1, "Desert");
                break;
            }
            case 41: {
                player.setAmmo(16);
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(30));
                nofCreatures = 85;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(25));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(8));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(1, this.creatureSpecs, 0, 30, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 30, 55, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 55, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 1, "Desert");
                break;
            }
            case 42: {
                player.setAmmo(16);
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(20));
                nofCreatures = 80;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(24));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(8));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(1, this.creatureSpecs, 0, 30, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 30, 60, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 60, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 1, "Desert");
                break;
            }
            case 43: {
                player.setAmmo(16);
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(35));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(28));
                nofCreatures = 88;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(23));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(1, this.creatureSpecs, 0, 25, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 25, 60, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 60, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 1, "Desert");
                break;
            }
            case 44: {
                player.setAmmo(16);
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(32));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(32));
                nofCreatures = 89;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(26));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(1, this.creatureSpecs, 0, 32, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 32, 57, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 57, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 1, "Desert");
                break;
            }
            case 45: {
                player.setAmmo(16);
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(25));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(35));
                nofCreatures = 90;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(25));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(1, this.creatureSpecs, 0, 30, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 30, 55, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 55, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 1, "Desert");
                break;
            }
            case 46: {
                player.setAmmo(16);
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(28));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(30));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(30));
                nofCreatures = 88;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(24));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(5));
                this.groupManager.ConfigureCreature(1, this.creatureSpecs, 0, 28, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 28, 58, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 58, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 1, "Desert");
                break;
            }
            case 47: {
                player.setAmmo(16);
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(8));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(26));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(65));
                nofCreatures = 99;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(20));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(1, this.creatureSpecs, 0, 8, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 8, 34, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 34, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 1, "Desert");
                break;
            }
            case 48: {
                player.setAmmo(16);
                creatures.addElement(new Integer(7));
                creatures.addElement(new Integer(18));
                creatures.addElement(new Integer(6));
                creatures.addElement(new Integer(22));
                creatures.addElement(new Integer(2));
                creatures.addElement(new Integer(65));
                nofCreatures = 105;
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.FillCreatureSpecs(creatures);
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(24));
                powerupsVec.addElement(new Integer(13));
                powerupsVec.addElement(new Integer(2));
                powerupsVec.addElement(new Integer(12));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(6));
                powerupsVec.addElement(new Integer(3));
                powerupsVec.addElement(new Integer(16));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(14));
                powerupsVec.addElement(new Integer(10));
                powerupsVec.addElement(new Integer(4));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(5));
                powerupsVec.addElement(new Integer(4));
                this.groupManager.ConfigureCreature(1, this.creatureSpecs, 0, 18, true);
                this.groupManager.ConfigureCreature(19, this.creatureSpecs, 18, 40, false);
                this.groupManager.ConfigureCreature(2, this.creatureSpecs, 40, nofCreatures, false);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 1, "Desert");
                break;
            }
            case 49: {
                nofCreatures = 2;
                player.setAmmo(16);
                if (this.extraLifeAt40) {
                    player.setLife(player.getLife() + 1);
                    this.extraLifeAt40 = false;
                }
                creatures.addElement(new Integer(9));
                creatures.addElement(new Integer(1));
                this.creatureSpecs = new CreatureSpec[nofCreatures];
                this.creatureSpecs[0] = new CreatureSpec(9);
                this.creatureSpecs[1] = new CreatureSpec(8);
                this.groupManager.ConfigureCreature(6, this.creatureSpecs, 0, this.creatureSpecs.length, true);
                this.level = new Level(nofCreatures, creatures, this.currentLevel, 2, "Desert");
                break;
            }
        }
        for (i = 0; i < nofCreatures; ++i) {
            this.AddValueRandomCreatureSpecs(nofCreatures);
        }
        this.groupManager.AddPowerupsToCreatures(powerupsVec, nofCreatures, this.creatureSpecs);
        powerupsVec.removeAllElements();
        powerupsVec = null;
        creatures.removeAllElements();
        creatures = null;
    }

    public Level GetLevel() {
        return this.level;
    }

    public CreatureSpec GetNextCreatureSpec() {
        ++this.creatureIndex;
        Integer creatureRealIndex = (Integer)this.randomCreatureSpecs.elementAt(this.creatureIndex);
        return this.creatureSpecs[creatureRealIndex];
    }

    public CreatureSpec GetPrevCreatureSpec() {
        if (this.creatureIndex > 0) {
            --this.creatureIndex;
        }
        return this.creatureSpecs[this.creatureIndex];
    }

    public long getCreaturePoints() {
        return this.creaturePoints;
    }

    public void setCreaturePoints(long creaturePoints) {
        this.creaturePoints = creaturePoints;
    }

    public long getExtraPoints() {
        return this.extraPoints;
    }

    public void setExtraPoints(long extraPoints) {
        this.extraPoints = extraPoints;
    }

    public long getPowerupPoints() {
        return this.powerupPoints;
    }

    public void setPowerupPoints(long powerupPoints) {
        this.powerupPoints = powerupPoints;
    }

    public void Release() {
        this.creatureIndex = -1;
        if (this.level != null) {
            for (int i = 0; i < this.level.getNofCreatures(); ++i) {
                this.creatureSpecs[i] = null;
            }
            this.creatureSpecs = null;
            if (this.level != null) {
                this.level.Release();
                this.level = null;
            }
        }
        if (this.currentLevel == 0) {
            this.creaturePoints = 0L;
            this.extraPoints = 0L;
            this.powerupPoints = 0L;
        }
    }
}

