/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import net.rim.device.api.ui.TouchEvent;

public class LevelManager
implements PowerupInterface,
CreatureInterface {
    private LevelDesigner levelDesigner;
    private Hashtable creatures;
    private Hashtable powerups;
    private Hashtable effects;
    private Hashtable stringeffects;
    private SpriteLoader spriteLoader;
    private Timer mainTimer;
    private TimerTask levelFailTimer;
    private TimerTask playerDeathTimer;
    private TimerTask creatureMoveEnableTimer;
    private Image levelBackground;
    public LevelInterface levelInterface;
    private Player player;
    public Hud hud;
    public Creature bossCreature1;
    public Creature bossCreature2;
    private CreatureSpec creatureSpec;
    public int spawnedCreatureCounter;
    public int spawnedCreatureIndex;
    public int spawnedPowerUpCounter;
    public int spawnedEffectCounter;
    public int spawnedStringEffectCounter;
    public boolean levelFinished;
    public boolean drawFailure;
    private boolean spawningisEnable;
    private boolean maxCreaturesReached;
    private long time;
    private long spawnTime;
    public static final int Theme_Underwater = 0;
    public static final int Theme_Desert = 1;
    public static final int Theme_Swamp = 2;
    public static final int Theme_Jungle = 3;
    public static final int Theme_Underground = 4;
    private int xbuf;
    private int ybuf;

    public LevelManager(Timer timer, SpriteLoader spriteloader, LevelDesigner levelDesigner, LevelInterface levelinterface, Player player) {
        this.levelDesigner = levelDesigner;
        this.levelInterface = levelinterface;
        this.levelBackground = levelDesigner.GetLevel().getBackgroundImage();
        this.player = player;
        this.mainTimer = timer;
        this.spriteLoader = spriteloader;
        this.creatures = new Hashtable();
        this.powerups = new Hashtable();
        this.effects = new Hashtable();
        this.stringeffects = new Hashtable();
        this.hud = new Hud(this.spriteLoader, player);
        this.spawnedCreatureCounter = 0;
        this.spawnedCreatureIndex = 0;
        this.spawnedPowerUpCounter = 0;
        this.spawnedEffectCounter = 0;
        this.spawnedStringEffectCounter = 0;
        int[] creatureTypes = levelDesigner.GetLevel().getCreatureTypes();
        this.creatureSpec = levelDesigner.GetNextCreatureSpec();
        this.levelFinished = false;
        this.spawningisEnable = true;
        this.maxCreaturesReached = false;
        this.drawFailure = false;
        this.time = 0L;
        this.levelFailTimer = null;
        this.playerDeathTimer = null;
        this.bossCreature1 = null;
        this.bossCreature2 = null;
        try {
            this.spriteLoader.getBite();
            this.spriteLoader.getHealth();
            this.spriteLoader.getHealth50();
            this.spriteLoader.getStar250();
            this.spriteLoader.getStar500();
            this.spriteLoader.getExplosion();
            this.spriteLoader.getExplosionGreen();
            this.spriteLoader.getThunder();
            this.spriteLoader.getLightining();
            this.spriteLoader.getSleeping();
            this.spriteLoader.getFireball();
            this.spriteLoader.getFireballHud();
            spriteloader.getBladePowerup();
            this.spriteLoader.getBladesHud();
            this.spriteLoader.getAtomic();
            spriteloader.getM1bullet_hud();
            spriteloader.getYarasa();
            this.spriteLoader.getBulletmark();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < creatureTypes.length; ++i) {
            try {
                switch (creatureTypes[i]) {
                    case 0: {
                        this.spriteLoader.getCreatureEYE();
                        break;
                    }
                    case 9: {
                        spriteloader.getCreatureBossOrcoMinion();
                        break;
                    }
                    case 11: {
                        this.spriteLoader.getCreatureEyeBlue();
                        break;
                    }
                    case 10: {
                        this.spriteLoader.getCreatureRedBlue();
                        break;
                    }
                    case 7: {
                        this.spriteLoader.getCreatureWorm();
                        break;
                    }
                    case 13: {
                        this.spriteLoader.getCreatureBacteria();
                        break;
                    }
                    case 14: {
                        this.spriteLoader.getCreatureBacteriaSmall();
                        break;
                    }
                    case 15: {
                        this.spriteLoader.getCreatureJellyFish();
                        break;
                    }
                    case 16: {
                        this.spriteLoader.getCreatureClock();
                        break;
                    }
                    case 12: {
                        this.spriteLoader.getCreatureNeedle();
                        break;
                    }
                    case 1: {
                        this.spriteLoader.getCreatureRed();
                        break;
                    }
                    case 2: {
                        this.spriteLoader.getCreatureThorn();
                        break;
                    }
                    case 4: {
                        this.spriteLoader.getCreatureDividend();
                        break;
                    }
                    case 3: {
                        this.spriteLoader.getCreatureSmallEYE();
                        break;
                    }
                    case 5: {
                        this.spriteLoader.getCreatureBat();
                        break;
                    }
                    case 6: {
                        this.spriteLoader.getCreatureSkull();
                    }
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.spawnTime = System.currentTimeMillis();
    }

    public void Release() {
        if (this.levelFailTimer != null) {
            this.levelFailTimer.cancel();
            this.levelFailTimer = null;
        }
        if (this.creatureMoveEnableTimer != null) {
            this.creatureMoveEnableTimer.cancel();
            this.creatureMoveEnableTimer = null;
        }
        if (this.playerDeathTimer != null) {
            this.playerDeathTimer.cancel();
            this.playerDeathTimer = null;
        }
        this.ClearCreatures();
        this.ClearPowerUps();
        this.ClearStringEffects();
        this.ClearEffects();
        try {
            Sprite s1 = this.spriteLoader.getBite();
            s1 = null;
            Sprite s2 = this.spriteLoader.getHealthPotion();
            s2 = null;
            Sprite s3 = this.spriteLoader.getHealth_50();
            s3 = null;
            Sprite s4 = this.spriteLoader.getStar_250();
            s4 = null;
            Sprite s5 = this.spriteLoader.getStar_500();
            s5 = null;
            Sprite s6 = this.spriteLoader.getCreatureExplosion();
            s6 = null;
            Sprite s7 = this.spriteLoader.getExplosion_Green();
            s7 = null;
            Sprite s8 = this.spriteLoader.getThunderPowerup();
            s8 = null;
            Sprite s9 = this.spriteLoader.getLightning();
            s9 = null;
            Sprite s10 = this.spriteLoader.getSleepingPowerup();
            s10 = null;
            Sprite s11 = this.spriteLoader.getFireballPowerup();
            s11 = null;
            Image s12 = this.spriteLoader.getFireballHud();
            s12 = null;
            Sprite s13 = this.spriteLoader.getBladePowerup();
            s13 = null;
            Sprite s14 = this.spriteLoader.getBladesHud();
            s14 = null;
            Image s16 = this.spriteLoader.getAtomic();
            s16 = null;
            Image s17 = this.spriteLoader.getM1bullet_hud();
            s17 = null;
            Image s18 = this.spriteLoader.getYarasa();
            s18 = null;
            Image s19 = this.spriteLoader.getBulletmark();
            s19 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hud != null) {
            this.hud.Release();
            this.hud = null;
        }
        if (this.levelInterface != null) {
            this.levelInterface = null;
        }
    }

    public int totalCreatures() {
        return this.creatures.size();
    }

    public Effect addEffect(int type) {
        Effect effect = new Effect(this.spriteLoader, type);
        this.effects.put(new Integer(this.spawnedEffectCounter), effect);
        ++this.spawnedEffectCounter;
        return effect;
    }

    public void spawnCreature(CreatureSpec creatureSpec, boolean isitExtra) {
        Creature creature = null;
        PowerUp powerup = null;
        if (this.levelFinished) {
            return;
        }
        switch (creatureSpec.type) {
            case 0: {
                creature = new EyeCreature(0, this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 11: {
                creature = new EyeCreature(11, this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 1: {
                creature = new RedCreature(1, this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 10: {
                creature = new RedCreature(10, this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 2: {
                creature = new ThornCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 4: {
                creature = new DividendCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 3: {
                creature = new EyeSmallCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 5: {
                creature = new BatCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 6: {
                creature = new SkullCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 7: {
                creature = new WormCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 12: {
                creature = new NeedleCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 13: {
                creature = new BacteriaCreature(13, this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 14: {
                creature = new BacteriaCreature(14, this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 8: {
                this.bossCreature1 = creature = new BossOrcoCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 17: {
                this.bossCreature1 = creature = new ClockBossCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 18: {
                creature = new BossMurenCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                if (this.bossCreature1 == null) {
                    this.bossCreature1 = creature;
                    break;
                }
                this.bossCreature2 = creature;
                break;
            }
            case 9: {
                creature = new BossOrcoMinionCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 19: {
                this.bossCreature1 = creature = new BossFlower(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 15: {
                creature = new JellyFishCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
            case 16: {
                creature = new ClockCreature(this.spawnedCreatureIndex, creatureSpec.patternType, this.spriteLoader, this);
                break;
            }
        }
        powerup = creatureSpec.powerUpType != -1 ? new PowerUp(creatureSpec.powerUpType, this.spriteLoader, this) : null;
        creature.setPowerup(powerup);
        creature.setPos(creatureSpec.x, creatureSpec.y);
        creature.dirX = creatureSpec.dirx;
        creature.dirY = creatureSpec.diry;
        this.creatures.put(new Integer(this.spawnedCreatureIndex), creature);
        ++this.spawnedCreatureIndex;
        if (!isitExtra) {
            ++this.spawnedCreatureCounter;
        }
    }

    private void FinishLevel() {
        this.levelFinished = true;
        this.levelInterface.LevelFinished();
    }

    public void EndLevel() {
        this.FinishLevel();
    }

    private void ClearCreatures() {
        if (this.creatures != null) {
            Enumeration e = this.creatures.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                Creature creature = (Creature)this.creatures.get(key);
                this.creatures.remove(key);
                creature.Release();
                creature = null;
            }
        }
        this.creatures = null;
    }

    private void ClearPowerUps() {
        if (this.powerups != null) {
            Enumeration e = this.powerups.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                PowerUp powerup = (PowerUp)this.powerups.get(key);
                this.powerups.remove(key);
                powerup = null;
            }
        }
        this.powerups = null;
    }

    private void ClearEffects() {
        if (this.effects != null) {
            Enumeration e = this.effects.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                Effect effect = (Effect)this.effects.get(key);
                this.effects.remove(key);
                effect = null;
            }
        }
        this.effects = null;
    }

    private void ClearStringEffects() {
        if (this.stringeffects != null) {
            Enumeration e = this.stringeffects.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                StringEffect effect = (StringEffect)this.stringeffects.get(key);
                this.stringeffects.remove(key);
                effect = null;
            }
        }
        this.stringeffects = null;
    }

    public void HudPaint(Graphics g) {
        if (!this.levelFinished) {
            this.hud.Paint(g);
            if (this.levelDesigner.GetLevel().isitBossLevel()) {
                float ratio = 1.0f;
                if (this.bossCreature1 != null) {
                    if (this.bossCreature1.type == 17) {
                        ratio = (float)this.bossCreature1.Health / 80.0f;
                        if (this.bossCreature1.Health < 1) {
                            MainMidlet.soundManager.StopMusic();
                        }
                    }
                    if (this.bossCreature1.type == 19) {
                        ratio = (float)this.bossCreature1.Health / 25.0f;
                        if (this.bossCreature1.Health < 1) {
                            MainMidlet.soundManager.StopMusic();
                        }
                    }
                    if (this.bossCreature1.type == 8) {
                        ratio = (float)this.bossCreature1.Health / 72.0f;
                        if (this.bossCreature1.Health < 1) {
                            MainMidlet.soundManager.StopMusic();
                        }
                    }
                    if (this.bossCreature2 != null && this.bossCreature2.type == 18) {
                        ratio = (float)(this.bossCreature1.Health + this.bossCreature2.Health) / 50.0f;
                        if (this.bossCreature1.Health < 1 && this.bossCreature2.Health < 1) {
                            MainMidlet.soundManager.StopMusic();
                        }
                    }
                }
                this.hud.DrawBossHealtBar(g, ratio);
            }
        }
        if (this.drawFailure) {
            g.drawString("YOU FAILED!", 240, 180, 1);
        }
    }

    public void LevelPaint(Graphics g) {
        g.drawImage(this.levelBackground, 0, 0, 0);
    }

    public void Update(long time) {
        this.time = time;
        if (time - this.spawnTime > (long)this.creatureSpec.spawnTime) {
            this.maxCreaturesReached = this.creatures.size() >= 8;
            if (this.spawnedCreatureCounter < this.levelDesigner.GetLevel().getNofCreatures() && this.spawningisEnable && !this.maxCreaturesReached && !this.levelFinished) {
                this.spawnCreature(this.creatureSpec, false);
                if (this.spawnedCreatureCounter < this.levelDesigner.GetLevel().getNofCreatures()) {
                    this.creatureSpec = this.levelDesigner.GetNextCreatureSpec();
                }
            }
            this.spawnTime = time;
        }
        if (this.player.getAmmo() == 0 && !this.hud.HavePowerUpBox() && this.powerups.size() == 0 && this.levelFailTimer == null) {
            this.drawFailure = true;
            this.levelFailTimer = new LevelFailTimer(this);
            this.mainTimer.schedule(this.levelFailTimer, 2000L);
            this.levelInterface.SetTouchingAvailable(false);
        }
        if (this.levelDesigner.GetLevel().getRemainingCreatures() <= 0 && this.powerups.size() == 0 && this.effects.size() == 0 && !this.levelFinished) {
            this.FinishLevel();
        }
    }

    public void RenderCreatures(Graphics g) {
        if (!this.levelFinished) {
            Enumeration e = this.creatures.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                Creature creature = (Creature)this.creatures.get(key);
                creature.paint(g);
            }
        }
    }

    public void UpdateCreatures() {
        if (!this.levelFinished) {
            Enumeration e = this.creatures.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                Creature creature = (Creature)this.creatures.get(key);
                creature.UpdateMovement();
                creature.UpdateAnim(this.time);
            }
        }
    }

    public void RenderPowerUps(Graphics g) {
        if (!this.levelFinished) {
            Enumeration e = this.powerups.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                PowerUp powerup = (PowerUp)this.powerups.get(key);
                powerup.paint(g);
            }
        }
    }

    public void UpdatePowerUps() {
        if (!this.levelFinished) {
            Enumeration e = this.powerups.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                PowerUp powerup = (PowerUp)this.powerups.get(key);
                powerup.UpdateMovement();
                powerup.UpdateAnim(this.time);
                if (!powerup.isOutofBorder()) continue;
                this.powerups.remove(key);
                powerup = null;
            }
        }
    }

    public void RenderEffects(Graphics g) {
        if (!this.levelFinished) {
            Enumeration e = this.effects.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                Effect effect = (Effect)this.effects.get(key);
                effect.Paint(g);
            }
        }
    }

    public void UpdateEffects() {
        if (!this.levelFinished) {
            Enumeration e = this.effects.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                Effect effect = (Effect)this.effects.get(key);
                effect.UpdateMovement();
                effect.UpdateAction(this.creatures);
                effect.UpdateAnim(this.time);
                if (effect.checkLifeSpan()) continue;
                this.effects.remove(key);
                effect.Release();
                effect = null;
            }
        }
    }

    public void RenderStringEffects(Graphics g) {
        if (!this.levelFinished) {
            Enumeration e = this.stringeffects.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                StringEffect effect = (StringEffect)this.stringeffects.get(key);
                effect.Paint(g);
            }
        }
    }

    public void UpdateStringEffects() {
        if (!this.levelFinished) {
            Enumeration e = this.stringeffects.keys();
            while (e.hasMoreElements()) {
                Integer key = (Integer)e.nextElement();
                StringEffect effect = (StringEffect)this.stringeffects.get(key);
                if (effect.UpdateMovement()) continue;
                this.stringeffects.remove(key);
                effect = null;
            }
        }
    }

    public boolean isHitPowerUpHud(TouchEvent message) {
        int y;
        int x = message.getX(1);
        int index = this.hud.isHit(x, y = message.getY(1));
        if (index > -1) {
            int powerupType = this.hud.GetPowerupType(index);
            this.UnleashPowerup(powerupType);
            return true;
        }
        return false;
    }

    public boolean isHitPowerUps(TouchEvent message) {
        Enumeration e1;
        if (!this.levelFinished && (e1 = this.powerups.keys()).hasMoreElements()) {
            while (e1.hasMoreElements()) {
                Integer key = (Integer)e1.nextElement();
                PowerUp powerUp = (PowerUp)this.powerups.get(key);
                if (!powerUp.CheckTouchEvent(message.getX(1), message.getY(1))) continue;
                powerUp.Unleash();
                this.powerups.remove(key);
                powerUp = null;
                return true;
            }
        }
        return false;
    }

    public boolean isHitCreatures(TouchEvent message) {
        if (!this.levelFinished && this.player.getAmmo() != 0) {
            Enumeration e = this.creatures.keys();
            while (e.hasMoreElements()) {
                int index;
                Integer key = (Integer)e.nextElement();
                Creature creature = (Creature)this.creatures.get(key);
                this.xbuf = message.getX(1);
                this.ybuf = message.getY(1);
                if (!creature.CheckTouchEvent(message.getX(1), message.getY(1))) continue;
                this.player.setAmmo(this.player.getAmmo() - 1);
                if (this.player.getAmmo() == 0 && (index = this.hud.HaveBulletPowerUp()) != -1) {
                    this.hud.powerupBoxes[index].isEmpty = true;
                    this.UnleashPowerup(15);
                }
                Effect effectFire = this.addEffect(4);
                Sprite spriteFire = effectFire.sprite;
                spriteFire.setPosition(message.getX(1) - spriteFire.getWidth() / 2, message.getY(1) - spriteFire.getHeight() / 2);
                if (creature.getHealth() == 0) {
                    creature.Die(message.getX(1), message.getY(1));
                }
                return true;
            }
            Effect effectFire = this.addEffect(4);
            Sprite spriteFire = effectFire.sprite;
            spriteFire.setPosition(message.getX(1) - spriteFire.getWidth() / 2, message.getY(1) - spriteFire.getHeight() / 2);
        }
        return false;
    }

    public boolean isHitCreaturesBossLvl(TouchEvent message) {
        if (!this.levelFinished && this.player.getAmmo() != 0) {
            Sprite spriteFire;
            Effect effectFire;
            Enumeration e = this.creatures.keys();
            boolean creatureHit = false;
            while (e.hasMoreElements()) {
                int index;
                Integer key = (Integer)e.nextElement();
                Creature creature = (Creature)this.creatures.get(key);
                this.xbuf = message.getX(1);
                this.ybuf = message.getY(1);
                if (!creature.CheckTouchEvent(message.getX(1), message.getY(1))) continue;
                creatureHit = true;
                this.player.setAmmo(this.player.getAmmo() - 1);
                if (this.player.getAmmo() == 0 && (index = this.hud.HaveBulletPowerUp()) != -1) {
                    this.hud.powerupBoxes[index].isEmpty = true;
                    this.UnleashPowerup(15);
                }
                effectFire = this.addEffect(4);
                spriteFire = effectFire.sprite;
                spriteFire.setPosition(message.getX(1) - spriteFire.getWidth() / 2, message.getY(1) - spriteFire.getHeight() / 2);
                if (creature.getHealth() != 0) continue;
                creature.Die(message.getX(1), message.getY(1));
            }
            if (creatureHit) {
                return true;
            }
            effectFire = this.addEffect(4);
            spriteFire = effectFire.sprite;
            spriteFire.setPosition(message.getX(1) - spriteFire.getWidth() / 2, message.getY(1) - spriteFire.getHeight() / 2);
        }
        return false;
    }

    public void CreatureBlooded(Creature creature, int x, int y) {
        int creatureType = creature.getType();
        int bloodtype = 0;
        switch (creatureType) {
            case 0: {
                bloodtype = 1;
                break;
            }
            case 4: {
                bloodtype = 1;
                break;
            }
            case 3: {
                bloodtype = 1;
            }
        }
        Effect effect = this.addEffect(bloodtype);
        Sprite sprite = effect.sprite;
        sprite.setPosition(x - sprite.getWidth() / 2, y - sprite.getHeight() / 2);
    }

    public void EnableCreaturesMovement() {
        this.levelInterface.EnableCreatureMovement(true);
        this.spawningisEnable = true;
        this.creatureMoveEnableTimer.cancel();
        this.creatureMoveEnableTimer = null;
    }

    public void UnleashPowerup(int powerupType) {
        Enumeration e = null;
        Integer key = null;
        Creature creature = null;
        switch (powerupType) {
            case 4: {
                this.player.addHealth(50);
                this.hud.ComputeAndSetHealthBarFrame(this.player.getHealth());
                break;
            }
            case 5: {
                this.player.addHealth(100);
                this.hud.ComputeAndSetHealthBarFrame(this.player.getHealth());
                break;
            }
            case 12: {
                Effect effect = this.addEffect(2);
                int randomX = MainCanvas.generator.nextInt(480 - effect.sprite.getWidth());
                effect.setPos(randomX, 0);
                effect.FlashTheLightning(this.creatures);
                break;
            }
            case 15: {
                this.player.setAmmo(16);
                break;
            }
            case 16: {
                Effect effect = this.addEffect(5);
                effect.ThrowBlades(true);
                effect = this.addEffect(5);
                effect.ThrowBlades(false);
                break;
            }
            case 14: {
                Effect effect = this.addEffect(3);
                effect.CastFireball();
                effect = this.addEffect(3);
                effect.CastFireball();
                effect = this.addEffect(3);
                effect.CastFireball();
                effect = this.addEffect(3);
                effect.CastFireball();
                effect = this.addEffect(3);
                effect.CastFireball();
                effect = this.addEffect(3);
                effect.CastFireball();
                break;
            }
            case 13: {
                this.levelInterface.EnableCreatureMovement(false);
                this.spawningisEnable = false;
                this.creatureMoveEnableTimer = new CreatureMoveEnableTimer(this);
                this.mainTimer.schedule(this.creatureMoveEnableTimer, 4000L);
                break;
            }
            case 6: {
                this.levelInterface.ShakeScreen();
                if (this.creatures == null) break;
                e = this.creatures.keys();
                while (e.hasMoreElements()) {
                    key = (Integer)e.nextElement();
                    creature = (Creature)this.creatures.get(key);
                    creature.Die();
                }
                break;
            }
        }
    }

    public void PowerupUnleashed(PowerUp powerup) {
        Level level = this.levelDesigner.GetLevel();
        switch (powerup.type) {
            case 4: {
                if (this.player.getHealth() < 50) {
                    this.UnleashPowerup(4);
                    break;
                }
            }
            case 5: {
                if (this.player.getHealth() < 50) {
                    this.UnleashPowerup(5);
                    break;
                }
            }
            case 6: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                level.addPowerupPoints(250L);
                int index = this.hud.CheckEmptyPowerUpBox();
                if (index == -1) break;
                this.hud.AddPowerUp(powerup, index);
                break;
            }
            case 0: {
                level.addExtraPoints(250L);
                StringEffect effect = new StringEffect("+250", 255, 255, 0, (int)powerup.getX(), (int)powerup.getY());
                this.stringeffects.put(new Integer(this.spawnedStringEffectCounter), effect);
                ++this.spawnedStringEffectCounter;
                break;
            }
            case 1: {
                level.addExtraPoints(500L);
                StringEffect effect = new StringEffect("+500", 255, 255, 0, (int)powerup.getX(), (int)powerup.getY());
                this.stringeffects.put(new Integer(this.spawnedStringEffectCounter), effect);
                ++this.spawnedStringEffectCounter;
                break;
            }
            case 2: {
                level.addExtraPoints(1000L);
                StringEffect effect = new StringEffect("+1000", 255, 255, 0, (int)powerup.getX(), (int)powerup.getY());
                this.stringeffects.put(new Integer(this.spawnedStringEffectCounter), effect);
                ++this.spawnedStringEffectCounter;
                break;
            }
            case 3: {
                level.addExtraPoints(4000L);
                StringEffect effect = new StringEffect("+4000", 255, 255, 0, (int)powerup.getX(), (int)powerup.getY());
                this.stringeffects.put(new Integer(this.spawnedStringEffectCounter), effect);
                ++this.spawnedStringEffectCounter;
            }
        }
    }

    public void CreatureSpawn(CreatureSpec[] creatureSpec) {
        if (!this.maxCreaturesReached) {
            Vector powerupsVec = new Vector();
            this.levelDesigner.groupManager.ConfigureCreature(7, creatureSpec, 0, creatureSpec.length, false);
            for (int i = 0; i < creatureSpec.length; ++i) {
                switch (creatureSpec[i].type) {
                    case 5: 
                    case 9: 
                    case 12: 
                    case 16: {
                        int random = MainCanvas.generator.nextInt(3);
                        switch (random) {
                            case 0: {
                                creatureSpec[i].powerUpType = 15;
                                break;
                            }
                            case 1: {
                                creatureSpec[i].powerUpType = 5;
                            }
                        }
                        this.spawnCreature(creatureSpec[i], true);
                        this.levelDesigner.GetLevel().setRemainingCreatures(this.levelDesigner.GetLevel().getRemainingCreatures() + 1);
                    }
                }
            }
            powerupsVec.removeAllElements();
            Object var2_2 = null;
        }
    }

    public void CreatureDied(Creature creature, int x, int y) {
        Level level = this.levelDesigner.GetLevel();
        if (!this.maxCreaturesReached) {
            Vector<Integer> powerupsVec;
            CreatureSpec[] creatureSpecs;
            if (creature.getType() == 4) {
                creatureSpecs = new CreatureSpec[2];
                powerupsVec = new Vector<Integer>();
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(1));
                powerupsVec.addElement(new Integer(0));
                powerupsVec.addElement(new Integer(1));
                creatureSpecs[0] = new CreatureSpec(3);
                creatureSpecs[1] = new CreatureSpec(3);
                this.levelDesigner.groupManager.ConfigureCreature(9, creatureSpecs, 0, 2, true);
                creatureSpecs[0].x = x;
                creatureSpecs[0].y = y;
                creatureSpecs[1].x = x;
                creatureSpecs[1].y = y;
                if (x < 240) {
                    if (y < 180) {
                        creatureSpecs[0].dirx = 1.0f;
                        creatureSpecs[0].diry = 0.0f;
                        creatureSpecs[1].dirx = 0.0f;
                        creatureSpecs[1].diry = 1.0f;
                    } else {
                        creatureSpecs[0].dirx = 1.0f;
                        creatureSpecs[0].diry = 0.0f;
                        creatureSpecs[1].dirx = 0.0f;
                        creatureSpecs[1].diry = -1.0f;
                    }
                } else if (y < 180) {
                    creatureSpecs[0].dirx = -1.0f;
                    creatureSpecs[0].diry = 0.0f;
                    creatureSpecs[1].dirx = 0.0f;
                    creatureSpecs[1].diry = 1.0f;
                } else {
                    creatureSpecs[0].dirx = -1.0f;
                    creatureSpecs[0].diry = 0.0f;
                    creatureSpecs[1].dirx = 0.0f;
                    creatureSpecs[1].diry = -1.0f;
                }
                this.spawnCreature(creatureSpecs[0], true);
                this.spawnCreature(creatureSpecs[1], true);
                level.setRemainingCreatures(level.getRemainingCreatures() + 2);
                creatureSpecs = null;
            }
            if (creature.getType() == 13) {
                creatureSpecs = new CreatureSpec[2];
                powerupsVec = new Vector();
                powerupsVec.addElement(new Integer(15));
                powerupsVec.addElement(new Integer(2));
                creatureSpecs[0] = new CreatureSpec(14);
                creatureSpecs[1] = new CreatureSpec(14);
                this.levelDesigner.groupManager.ConfigureCreature(9, creatureSpecs, 0, 2, true);
                if (x < 240) {
                    if (y < 180) {
                        creatureSpecs[0].dirx = 1.0f;
                        creatureSpecs[0].diry = 0.0f;
                        creatureSpecs[1].dirx = 0.0f;
                        creatureSpecs[1].diry = 1.0f;
                        creatureSpecs[0].x = x + 10;
                        creatureSpecs[0].y = y + 10;
                        creatureSpecs[1].x = x + 10;
                        creatureSpecs[1].y = y + 10;
                    } else {
                        creatureSpecs[0].dirx = 1.0f;
                        creatureSpecs[0].diry = 0.0f;
                        creatureSpecs[1].dirx = 0.0f;
                        creatureSpecs[1].diry = -1.0f;
                        creatureSpecs[0].x = x + 10;
                        creatureSpecs[0].y = y - 10;
                        creatureSpecs[1].x = x + 10;
                        creatureSpecs[1].y = y - 10;
                    }
                } else if (y < 180) {
                    creatureSpecs[0].dirx = -1.0f;
                    creatureSpecs[0].diry = 0.0f;
                    creatureSpecs[1].dirx = 0.0f;
                    creatureSpecs[1].diry = 1.0f;
                    creatureSpecs[0].x = x - 10;
                    creatureSpecs[0].y = y + 10;
                    creatureSpecs[1].x = x - 10;
                    creatureSpecs[1].y = y + 10;
                } else {
                    creatureSpecs[0].dirx = -1.0f;
                    creatureSpecs[0].diry = 0.0f;
                    creatureSpecs[1].dirx = 0.0f;
                    creatureSpecs[1].diry = -1.0f;
                    creatureSpecs[0].x = x - 10;
                    creatureSpecs[0].y = y - 10;
                    creatureSpecs[1].x = x - 10;
                    creatureSpecs[1].y = y - 10;
                }
                this.spawnCreature(creatureSpecs[0], true);
                this.spawnCreature(creatureSpecs[1], true);
                level.setRemainingCreatures(level.getRemainingCreatures() + 2);
                creatureSpecs = null;
            }
        }
        if (x == -1 && y == -1) {
            this.CreatureBlooded(creature, creature.sprite.getX() + creature.sprite.getWidth() / 2, creature.sprite.getY() + creature.sprite.getHeight() / 2);
        } else {
            this.CreatureBlooded(creature, x, y);
        }
        String point = "+" + String.valueOf(creature.getPoint());
        StringEffect streffect = new StringEffect(point, 255, 255, 0, creature.getX(), creature.getY());
        this.stringeffects.put(new Integer(this.spawnedStringEffectCounter), streffect);
        ++this.spawnedStringEffectCounter;
        level.setRemainingCreatures(level.getRemainingCreatures() - 1);
        level.addCreaturePoints(creature.getPoint());
        PowerUp powerup = creature.getPowerup();
        if (powerup != null) {
            this.powerups.put(new Integer(this.spawnedPowerUpCounter), powerup);
            powerup.setPos(creature.getX(), creature.getY());
            ++this.spawnedPowerUpCounter;
        }
        Integer integer = new Integer(creature.getId());
        this.creatures.remove(integer);
        integer = null;
        creature.sprite = null;
        creature = null;
    }

    public void CreatureBite(Creature creature) {
        Effect effectBite = this.addEffect(6);
        Sprite sprite = creature.sprite;
        effectBite.setPos(sprite.getX(), sprite.getY());
        String biteStr = null;
        switch (creature.getType()) {
            case 1: {
                this.player.loseHealth(5);
                biteStr = "-" + String.valueOf(5);
                break;
            }
            case 10: {
                this.player.loseHealth(3);
                biteStr = "-" + String.valueOf(3);
                break;
            }
            case 12: {
                this.player.loseHealth(7);
                biteStr = "-" + String.valueOf(7);
                break;
            }
            case 7: {
                this.player.loseHealth(5);
                biteStr = "-" + String.valueOf(5);
                break;
            }
            case 9: {
                this.player.loseHealth(5);
                biteStr = "-" + String.valueOf(5);
                break;
            }
            case 16: {
                this.player.loseHealth(5);
                biteStr = "-" + String.valueOf(5);
                break;
            }
            case 18: {
                this.player.loseHealth(5);
                biteStr = "-" + String.valueOf(5);
                effectBite.setPos(sprite.getX() + sprite.getWidth() / 2 - effectBite.sprite.getWidth() / 2, sprite.getY() + sprite.getHeight() / 2);
                this.levelInterface.ShakeScreen();
                break;
            }
            case 19: {
                this.player.loseHealth(10);
                biteStr = "-" + String.valueOf(10);
                effectBite.setPos(sprite.getX() + sprite.getWidth() / 2 - effectBite.sprite.getWidth() / 2, sprite.getY() + sprite.getHeight() / 2);
                this.levelInterface.ShakeScreen();
            }
        }
        int health = this.player.getHealth();
        this.hud.ComputeAndSetHealthBarFrame(health);
        StringEffect effect = new StringEffect(biteStr, 255, 0, 0, creature.sprite.getWidth() / 2 + creature.getX(), creature.getY());
        this.stringeffects.put(new Integer(this.spawnedStringEffectCounter), effect);
        ++this.spawnedStringEffectCounter;
        this.hud.setIsHit(true);
        if (health <= 0 && this.levelFailTimer == null) {
            this.drawFailure = true;
            this.levelFailTimer = new LevelFailTimer(this);
            this.mainTimer.schedule(this.levelFailTimer, 2000L);
            this.levelInterface.SetTouchingAvailable(false);
        }
    }

    public void ThornMakeDamage(Creature creature) {
        this.player.loseHealth(2);
        int health = this.player.getHealth();
        this.hud.ComputeAndSetHealthBarFrame(health);
        String biteStr = "-" + String.valueOf(2);
        StringEffect effect = new StringEffect(biteStr, 255, 0, 0, creature.sprite.getWidth() / 2 + creature.getX(), creature.getY());
        this.stringeffects.put(new Integer(this.spawnedStringEffectCounter), effect);
        ++this.spawnedStringEffectCounter;
        this.hud.setIsHit(true);
        if (health <= 0 && this.levelFailTimer == null) {
            this.drawFailure = true;
            this.levelFailTimer = new LevelFailTimer(this);
            this.mainTimer.schedule(this.levelFailTimer, 2000L);
            this.levelInterface.SetTouchingAvailable(false);
        }
    }

    public void JellyMakeDamage(Creature creature) {
        this.player.loseHealth(JellyFishCreature.JellyDAMAGE);
        int health = this.player.getHealth();
        this.hud.ComputeAndSetHealthBarFrame(health);
        String biteStr = "-" + String.valueOf(JellyFishCreature.JellyDAMAGE);
        StringEffect effect = new StringEffect(biteStr, 255, 0, 0, creature.sprite.getWidth() / 2 + creature.getX(), creature.getY());
        this.stringeffects.put(new Integer(this.spawnedStringEffectCounter), effect);
        ++this.spawnedStringEffectCounter;
        this.hud.setIsHit(true);
        if (health <= 0 && this.levelFailTimer == null) {
            this.drawFailure = true;
            this.levelFailTimer = new LevelFailTimer(this);
            this.mainTimer.schedule(this.levelFailTimer, 2000L);
            this.levelInterface.SetTouchingAvailable(false);
        }
    }

    public void CreatureBurn(Creature creature) {
        this.player.loseHealth(2);
        int health = this.player.getHealth();
        this.hud.ComputeAndSetHealthBarFrame(health);
        String biteStr = "-" + String.valueOf(2);
        StringEffect effect = new StringEffect(biteStr, 255, 0, 0, creature.sprite.getWidth() / 2 + creature.getX(), creature.getY());
        this.stringeffects.put(new Integer(this.spawnedStringEffectCounter), effect);
        ++this.spawnedStringEffectCounter;
        this.hud.setIsHit(true);
        if (health <= 0 && this.levelFailTimer == null) {
            this.drawFailure = true;
            this.levelFailTimer = new LevelFailTimer(this);
            this.mainTimer.schedule(this.levelFailTimer, 2000L);
            this.levelInterface.SetTouchingAvailable(false);
        }
    }

    public void LevelFailed() {
        this.drawFailure = false;
        this.player.loseLife();
        if (this.player.getLife() == -1) {
            this.PlayerDied();
        } else {
            this.levelInterface.LevelFailed();
        }
    }

    public void AddCreaturePoint(long point) {
        Level level = this.levelDesigner.GetLevel();
        level.addCreaturePoints(point);
    }

    public void PlayerDied() {
        this.levelInterface.SetTouchingAvailable(false);
        this.levelFinished = true;
        try {
            this.levelBackground = Image.createImage((String)"/Images/youdied.jpg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.playerDeathTimer == null) {
            this.playerDeathTimer = new PlayerDeathTimer(this);
            this.mainTimer.schedule(this.playerDeathTimer, 3000L);
        }
    }
}

