/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.rim.device.api.lcdui.BlackBerryCanvas;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.KeyListener;
import net.rim.device.api.ui.TouchEvent;
import net.rim.device.api.ui.component.Dialog;

public class MainCanvas
extends BlackBerryCanvas
implements KeyListener,
LevelInterface,
ButtonEventInterface {
    private LevelDesigner levelDesigner;
    private boolean levelFailed;
    private Timer timer;
    private TimerTask timerTask;
    private TimerTask creatureUpdateTask;
    private Image buffer;
    public static int width;
    public static int height;
    private MainCanvasInterface mainCanvasInterface;
    private LevelManager levelManager;
    public static final int gameFrameRate = 30;
    private Player newplayer;
    private boolean touchingAvailable;
    private boolean creatureTouchingAvailable;
    private long prevCurrentTime;
    private long currentTime;
    private long prevCurrentTime1;
    private long prevMenuTime;
    public static final Random generator;
    private boolean creaturesCanMove;
    private Button mapFinishOkButton;
    private Button levelFinishOkButton;
    private Image levelBackground;
    private int gameState;
    private final int GS_INSCORE;
    private final int GS_INGAME;
    private final int GS_INMAP;
    private final int GS_INDEATH;
    private boolean gameStarting;
    private Map map;
    private SpriteLoader spriteLoader;
    private long currentShakeTime;
    Graphics savedGraphics;
    private int shakeX;
    private boolean shaking;

    public void RegisterKeys() {
        Application.getApplication().addKeyListener((KeyListener)this);
    }

    public void UnRegisterKeys() {
        Application.getApplication().removeKeyListener((KeyListener)this);
    }

    public MainCanvas(MainCanvasInterface mainCanvasInterface) {
        this.GS_INSCORE = 0;
        this.GS_INGAME = 1;
        this.GS_INMAP = 2;
        this.GS_INDEATH = 3;
        this.mainCanvasInterface = mainCanvasInterface;
        this.Init();
        this.touchingAvailable = true;
        this.gameState = 2;
        this.gameStarting = false;
    }

    public void Init() {
        this.RegisterKeys();
        this.timer = new Timer();
        this.timerTask = new GameTimer((Canvas)this);
        this.timer.schedule(this.timerTask, 0L, 30L);
        width = this.getWidth();
        height = this.getHeight();
        this.buffer = Image.createImage((int)width, (int)height);
        this.levelDesigner = new LevelDesigner(this);
        generator.setSeed(System.currentTimeMillis());
        this.creaturesCanMove = true;
        this.creatureTouchingAvailable = true;
        this.spriteLoader = new SpriteLoader();
        this.map = new Map(this.spriteLoader);
        this.shakeX = 10;
        this.shaking = false;
    }

    public void Release() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.creatureUpdateTask != null) {
            this.creatureUpdateTask.cancel();
            this.creatureUpdateTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.levelFailed = true;
        if (this.levelManager != null) {
            this.levelManager.Release();
            this.levelManager = null;
        }
        this.buffer = null;
        this.UnRegisterKeys();
    }

    public void SetupMapMenu() {
        MainMidlet.soundManager.PlayMusic(6, -1);
        this.map.update(this.levelDesigner.getCurrentLevel());
        this.gameState = 2;
        if (this.mapFinishOkButton != null) {
            this.mapFinishOkButton = null;
        }
        this.mapFinishOkButton = new Button(this);
        this.mapFinishOkButton.setTextSize(0);
        this.mapFinishOkButton.setText("Start");
        this.mapFinishOkButton.setX(204);
        this.mapFinishOkButton.setY(322);
        this.mapFinishOkButton.setColor(127, 51, 0);
        this.mapFinishOkButton.setTouchedColor(0, 0, 0);
    }

    public boolean keyChar(char key, int status, int time) {
        return false;
    }

    public void sizeChanged(int w, int h) {
        if (w < h) {
            this.mainCanvasInterface.ShowOrientationMessage((Displayable)this);
        }
    }

    public boolean keyDown(int keycode, int time) {
        if (keycode == 0x10010000) {
            MainMidlet.soundManager.VolumeDown();
        }
        if (keycode == 0x10000000) {
            MainMidlet.soundManager.VolumeUp();
        }
        if (keycode == 0x1B0000) {
            if (this.creatureUpdateTask != null) {
                this.creatureUpdateTask.cancel();
                this.creatureUpdateTask = null;
            }
            if (Dialog.ask((int)3, (String)"Quit Game ?") == -1) {
                if (this.creatureUpdateTask == null) {
                    this.creatureUpdateTask = new CreatureUpdateTimer(this);
                    this.timer.schedule(this.creatureUpdateTask, 0L, 30L);
                }
                return true;
            }
            Level level = this.levelDesigner.GetLevel();
            long total = 0L;
            if (level != null) {
                long prevtotal = this.levelDesigner.getCreaturePoints() + this.levelDesigner.getPowerupPoints() + this.levelDesigner.getExtraPoints();
                total = prevtotal + level.getCreaturePoints() + level.getExtraPoints() + level.getPowerupPoints();
                this.mainCanvasInterface.exitGame(total);
            } else {
                this.mainCanvasInterface.exitGame();
            }
        }
        return true;
    }

    public boolean keyRepeat(int keycode, int time) {
        return false;
    }

    public boolean keyStatus(int keycode, int time) {
        return false;
    }

    public boolean keyUp(int keycode, int time) {
        return false;
    }

    public void touchEvent(TouchEvent message) {
        int event = message.getEvent();
        if (this.touchingAvailable) {
            if (this.gameState == 1 && event == 13569) {
                boolean isHitPowerUps = false;
                boolean isHitPowerUpHud = false;
                boolean isHitCreatures = false;
                isHitPowerUps = this.levelManager.isHitPowerUps(message);
                if (isHitPowerUps) {
                    return;
                }
                isHitPowerUpHud = this.levelManager.isHitPowerUpHud(message);
                if (isHitPowerUpHud) {
                    return;
                }
                if (this.creatureTouchingAvailable) {
                    isHitCreatures = this.levelDesigner.GetLevel().isitBossLevel() ? this.levelManager.isHitCreaturesBossLvl(message) : this.levelManager.isHitCreatures(message);
                    if (isHitCreatures) {
                        return;
                    }
                    if (!(isHitCreatures || isHitPowerUpHud || isHitPowerUps)) {
                        int index;
                        this.newplayer.setAmmo(this.newplayer.getAmmo() - 1);
                        if (this.newplayer.getAmmo() == 0 && (index = this.levelManager.hud.HaveBulletPowerUp()) != -1) {
                            this.levelManager.hud.powerupBoxes[index].isEmpty = true;
                            this.levelManager.UnleashPowerup(15);
                        }
                    }
                }
            }
            if (this.gameState == 0) {
                this.levelFinishOkButton.setMessage(message);
            }
            if (this.gameState == 2) {
                this.mapFinishOkButton.setMessage(message);
            }
        }
    }

    void menuLoop(Graphics g) {
        if (this.gameState == 3) {
            // empty if block
        }
        if (this.gameState == 0) {
            if (this.levelBackground != null) {
                g.drawImage(this.levelBackground, 0, 0, 20);
            }
            this.ShowScore(g);
            if (this.levelFinishOkButton != null) {
                this.levelFinishOkButton.UpdateColor(g);
                this.levelFinishOkButton.UpdateText(g);
            }
        }
        if (this.gameState == 2) {
            this.map.updateAnim(System.currentTimeMillis());
            this.map.paint(g);
            if (this.mapFinishOkButton != null) {
                this.mapFinishOkButton.UpdateColor(g);
                this.mapFinishOkButton.UpdateText(g);
            }
        }
    }

    protected void paint(Graphics g) {
        this.savedGraphics = g;
        if (this.buffer != null) {
            g = this.buffer.getGraphics();
        }
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, width, height);
        g.setColor(255, 0, 0);
        if (this.gameState == 1) {
            this.gameLoop(g);
        } else {
            this.menuLoop(g);
        }
        if (this.buffer != null) {
            this.savedGraphics.drawImage(this.buffer, 0, 0, 20);
        }
    }

    public void updateShakeScreen() {
        if (this.currentTime - this.currentShakeTime > 30L) {
            this.savedGraphics.translate(this.shakeX, 0);
            this.currentShakeTime = this.currentTime;
            if (this.shakeX == 0) {
                this.shaking = false;
                this.shakeX = 10;
            }
            if (this.shakeX == 2) {
                this.shakeX = 0;
            }
            if (this.shakeX == -2) {
                this.shakeX = 2;
            }
            if (this.shakeX == 4) {
                this.shakeX = -2;
            }
            if (this.shakeX == -4) {
                this.shakeX = 4;
            }
            if (this.shakeX == -6) {
                this.shakeX = 4;
            }
            if (this.shakeX == 6) {
                this.shakeX = -6;
            }
            if (this.shakeX == -8) {
                this.shakeX = 6;
            }
            if (this.shakeX == 8) {
                this.shakeX = -8;
            }
            if (this.shakeX == -10) {
                this.shakeX = 8;
            }
            if (this.shakeX == 10) {
                this.shakeX = -10;
            }
        }
    }

    public void updateObjectMovements() {
        this.levelManager.Update(System.currentTimeMillis());
        if (this.creaturesCanMove) {
            this.levelManager.UpdateCreatures();
        }
        this.levelManager.UpdatePowerUps();
        this.levelManager.UpdateEffects();
        this.levelManager.UpdateStringEffects();
    }

    public void ShakeScreen() {
        this.shaking = true;
    }

    private void gameLoop(Graphics g) {
        if (!this.levelFailed) {
            this.currentTime = System.currentTimeMillis();
            long difference = this.currentTime - this.prevCurrentTime;
            long fps = 0L;
            if (difference > 0L) {
                fps = 1000L / difference;
            }
            this.prevCurrentTime = this.currentTime;
            this.levelManager.LevelPaint(g);
            this.levelManager.RenderCreatures(g);
            this.levelManager.RenderPowerUps(g);
            this.levelManager.RenderEffects(g);
            this.levelManager.RenderStringEffects(g);
            this.levelManager.HudPaint(g);
            if (this.gameStarting) {
                String drawstr = this.levelDesigner.getCurrentLevel() < 9 ? "Level-0" + (this.levelDesigner.getCurrentLevel() + 1) : "Level-" + (this.levelDesigner.getCurrentLevel() + 1);
                g.drawString(drawstr + " " + this.levelDesigner.GetLevel().getLevelInfo(), 240, 180, 1);
                if (this.currentTime - this.prevMenuTime > 2000L) {
                    this.prevMenuTime = this.currentTime;
                    this.gameStarting = false;
                }
                this.creatureTouchingAvailable = false;
            } else {
                this.creatureTouchingAvailable = true;
            }
            if (this.shaking) {
                this.updateShakeScreen();
            }
        }
    }

    public void LevelFinished() {
        MainMidlet.soundManager.PlayMusic(7, 1);
        this.gameState = 0;
        try {
            this.levelBackground = Image.createImage((String)"/Images/levelFinishBackground.jpg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.levelFinishOkButton = new Button(this);
        this.levelFinishOkButton.setTextSize(0);
        this.levelFinishOkButton.setText("Continue");
        this.levelFinishOkButton.setX(195);
        this.levelFinishOkButton.setY(322);
        this.levelFinishOkButton.setColor(127, 51, 0);
        this.levelFinishOkButton.setTouchedColor(0, 0, 0);
    }

    public void ShowScore(Graphics g) {
        g.setFont(Font.getFont((int)0, (int)0, (int)0));
        g.setColor(231, 181, 115);
        g.drawString("SCORE", 210, 30, 16);
        g.setColor(127, 51, 0);
        if (this.levelDesigner.getCurrentLevel() > 0) {
            long prevtotal = this.levelDesigner.getCreaturePoints() + this.levelDesigner.getPowerupPoints() + this.levelDesigner.getExtraPoints();
            g.drawString("So far Total :", 83, 74, 16);
            g.drawString(Long.toString(prevtotal), 400, 74, 8);
            g.drawString("Creatures Timing :", 83, 110, 16);
            g.drawString(Long.toString(this.levelDesigner.GetLevel().getCreaturePoints()), 400, 110, 8);
            g.drawString("Power Ups :", 83, 146, 16);
            g.drawString(Long.toString(this.levelDesigner.GetLevel().getPowerupPoints()), 400, 146, 8);
            g.drawString("Extras :", 83, 182, 16);
            g.drawString(Long.toString(this.levelDesigner.GetLevel().getExtraPoints()), 400, 182, 8);
            long total = this.levelDesigner.GetLevel().getCreaturePoints() + this.levelDesigner.GetLevel().getPowerupPoints() + this.levelDesigner.GetLevel().getExtraPoints();
            g.drawString("Current Total :", 83, 218, 16);
            g.drawString(Long.toString(total), 400, 218, 8);
        } else {
            g.drawString("Creatures Timing :", 83, 70, 16);
            g.drawString(Long.toString(this.levelDesigner.GetLevel().getCreaturePoints()), 400, 70, 8);
            g.drawString("Power Ups :", 83, 121, 16);
            g.drawString(Long.toString(this.levelDesigner.GetLevel().getPowerupPoints()), 400, 121, 8);
            g.drawString("Extras :", 83, 172, 16);
            g.drawString(Long.toString(this.levelDesigner.GetLevel().getExtraPoints()), 400, 172, 8);
            long total = this.levelDesigner.GetLevel().getCreaturePoints() + this.levelDesigner.GetLevel().getPowerupPoints() + this.levelDesigner.GetLevel().getExtraPoints();
            g.drawString("Total :", 83, 223, 16);
            g.drawString(Long.toString(total), 400, 223, 8);
        }
    }

    public void StartNewGame() {
        this.newplayer = new Player();
        this.levelDesigner.CreateLevel(this.newplayer);
        this.levelManager = new LevelManager(this.timer, this.spriteLoader, this.levelDesigner, this, this.newplayer);
        this.levelFailed = false;
        this.touchingAvailable = true;
        this.gameState = 1;
        this.creaturesCanMove = true;
        if (this.creatureUpdateTask != null) {
            this.creatureUpdateTask.cancel();
            this.creatureUpdateTask = null;
        }
        this.creatureUpdateTask = new CreatureUpdateTimer(this);
        this.timer.schedule(this.creatureUpdateTask, 0L, 30L);
        MainMidlet.soundManager.PlayMusic(4, -1);
    }

    public void StartGameTimer() {
        if (this.creatureUpdateTask == null) {
            this.creatureUpdateTask = new CreatureUpdateTimer(this);
            this.timer.schedule(this.creatureUpdateTask, 0L, 30L);
        }
    }

    public void KillGameTimer() {
        if (this.creatureUpdateTask != null) {
            this.creatureUpdateTask.cancel();
            this.creatureUpdateTask = null;
        }
    }

    public void StartLevel(Player player) {
        Level level = this.levelDesigner.GetLevel();
        this.levelDesigner.UpdatePoints(level.getCreaturePoints(), level.getExtraPoints(), level.getPowerupPoints());
        this.levelDesigner.CreateLevel(player);
        this.levelManager = new LevelManager(this.timer, this.spriteLoader, this.levelDesigner, this, player);
        this.levelFailed = false;
        this.touchingAvailable = true;
        this.creaturesCanMove = true;
        if (this.creatureUpdateTask != null) {
            this.creatureUpdateTask.cancel();
            this.creatureUpdateTask = null;
        }
        this.creatureUpdateTask = new CreatureUpdateTimer(this);
        this.timer.schedule(this.creatureUpdateTask, 0L, 30L);
        this.gameState = 1;
        Level level1 = this.levelDesigner.GetLevel();
        int theme = level1.getTheme();
        if (level1.isitBossLevel()) {
            MainMidlet.soundManager.PlayMusic(8, -1);
        } else {
            MainMidlet.soundManager.PlayMusic(theme, -1);
        }
    }

    public void LevelFailed() {
        this.gameState = 3;
        this.levelFailed = true;
        this.newplayer.setHealth(100);
        if (this.creatureUpdateTask != null) {
            this.creatureUpdateTask.cancel();
            this.creatureUpdateTask = null;
        }
        if (this.levelManager != null) {
            this.levelManager.Release();
            this.levelManager = null;
        }
        this.StartLevel(this.newplayer);
        this.prevMenuTime = System.currentTimeMillis();
        this.gameStarting = true;
    }

    public void PlayerFinished() {
        if (this.levelManager != null) {
            this.levelManager.Release();
            this.levelManager = null;
        }
        Level level = this.levelDesigner.GetLevel();
        long prevtotal = this.levelDesigner.getCreaturePoints() + this.levelDesigner.getPowerupPoints() + this.levelDesigner.getExtraPoints();
        long total = prevtotal + level.getCreaturePoints() + level.getExtraPoints() + level.getPowerupPoints();
        this.mainCanvasInterface.exitGame(total);
    }

    public void SetTouchingAvailable(boolean touchit) {
        this.touchingAvailable = touchit;
    }

    public void EnableCreatureMovement(boolean move) {
        this.creaturesCanMove = move;
    }

    public void SendScore(long score) {
        this.mainCanvasInterface.sendScore(score);
    }

    public void FinishGame() {
        Level level = this.levelDesigner.GetLevel();
        long prevtotal = this.levelDesigner.getCreaturePoints() + this.levelDesigner.getPowerupPoints() + this.levelDesigner.getExtraPoints();
        long total = prevtotal + level.getCreaturePoints() + level.getExtraPoints() + level.getPowerupPoints();
        this.mainCanvasInterface.FinishGame(total);
    }

    public void buttonClicked(Button button) {
        if (button.getText().compareTo("Continue") == 0) {
            this.levelDesigner.nextLevel();
            this.newplayer.setHealth(100);
            if (this.creatureUpdateTask != null) {
                this.creatureUpdateTask.cancel();
                this.creatureUpdateTask = null;
            }
            if (this.levelManager != null) {
                this.levelManager.Release();
                this.levelManager = null;
            }
            if (this.levelDesigner.getCurrentLevel() == LevelDesigner.totalnofLevel) {
                this.FinishGame();
                return;
            }
            if (this.levelDesigner.isNewThemeRequired()) {
                this.SetupMapMenu();
            } else {
                this.StartLevel(this.newplayer);
                this.prevMenuTime = System.currentTimeMillis();
                this.gameStarting = true;
            }
        }
        if (button.getText().compareTo("Start") == 0) {
            if (this.levelDesigner.getCurrentLevel() == LevelDesigner.startLevel) {
                this.StartNewGame();
            } else {
                this.StartLevel(this.newplayer);
            }
            this.prevMenuTime = System.currentTimeMillis();
            this.gameStarting = true;
        }
    }

    static {
        generator = new Random();
    }
}

