/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class MainMidlet
extends MIDlet
implements MenuCanvasInterface,
MainCanvasInterface {
    private MenuCanvas menuCanvas;
    private MainCanvas mainCanvas;
    private HelpCanvas helpCanvas;
    private CreditsCanvas creditsCanvas;
    private MessageCanvas messageCanvas;
    private EndGameCanvas endGameCanvas;
    private static boolean gameStarted = false;
    private static boolean gamePaused = false;
    public static SoundManager soundManager = new SoundManager();

    public void startApp() {
        if (!gameStarted) {
            this.menuCanvas = new MenuCanvas(this);
            Pattern.PopulateTrigLookupTable();
            if (this.menuCanvas.getWidth() < this.menuCanvas.getHeight()) {
                this.ShowOrientationMessage((Displayable)this.menuCanvas);
            } else {
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menuCanvas);
                soundManager.PlayMusic(5, -1);
            }
        } else {
            Displayable display = Display.getDisplay((MIDlet)this).getCurrent();
            if (display == this.menuCanvas) {
                soundManager.PlayMusic(5, -1);
            }
            if (display == this.mainCanvas && gamePaused) {
                soundManager.PlayMusic(soundManager.getLastPlayedMusic(), -1);
                this.mainCanvas.StartGameTimer();
                gamePaused = false;
            }
        }
        gameStarted = true;
    }

    public void pauseApp() {
        Displayable display = Display.getDisplay((MIDlet)this).getCurrent();
        if (display == this.mainCanvas && !gamePaused) {
            this.mainCanvas.KillGameTimer();
        }
        soundManager.StopMusic();
        gamePaused = true;
    }

    public void destroyApp(boolean unconditional) {
    }

    public void quitGame() {
        soundManager.StopMusic();
        if (this.menuCanvas != null) {
            this.menuCanvas.Release();
            this.menuCanvas = null;
        }
        if (this.mainCanvas != null) {
            this.mainCanvas.Release();
            this.mainCanvas = null;
        }
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void newGame() {
        Displayable display;
        if (this.mainCanvas != null) {
            this.mainCanvas.Release();
            this.mainCanvas = null;
        }
        this.mainCanvas = new MainCanvas(this);
        this.mainCanvas.SetupMapMenu();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainCanvas);
        while ((display = Display.getDisplay((MIDlet)this).getCurrent()) != this.mainCanvas) {
        }
        if (this.menuCanvas != null) {
            this.menuCanvas.Release();
            this.menuCanvas = null;
        }
    }

    public void restartLevel(Player player) {
        Displayable display;
        if (this.mainCanvas != null) {
            this.mainCanvas.Release();
            this.mainCanvas = null;
        }
        this.mainCanvas = new MainCanvas(this);
        this.mainCanvas.StartLevel(player);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainCanvas);
        while ((display = Display.getDisplay((MIDlet)this).getCurrent()) != this.mainCanvas) {
        }
        if (this.menuCanvas != null) {
            this.menuCanvas.Release();
            this.menuCanvas = null;
        }
    }

    public void restartLevel() {
        this.newGame();
    }

    public void exitGame(long total) {
        if (this.mainCanvas != null) {
            this.mainCanvas.Release();
            this.mainCanvas = null;
        }
        this.menuCanvas = new MenuCanvas(this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menuCanvas);
        this.sendScore(total);
        if (this.menuCanvas.getWidth() < this.menuCanvas.getHeight()) {
            this.ShowOrientationMessage((Displayable)this.menuCanvas);
        }
    }

    public void exitGame() {
        if (this.mainCanvas != null) {
            this.mainCanvas.Release();
            this.mainCanvas = null;
        }
        this.menuCanvas = new MenuCanvas(this);
        if (this.menuCanvas.getWidth() < this.menuCanvas.getHeight()) {
            this.ShowOrientationMessage((Displayable)this.menuCanvas);
        } else {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menuCanvas);
            soundManager.StopMusic();
            soundManager.PlayMusic(5, -1);
        }
    }

    public void Help() {
        if (this.menuCanvas != null) {
            this.menuCanvas.Release();
            this.menuCanvas = null;
        }
        this.helpCanvas = new HelpCanvas(this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.helpCanvas);
    }

    public void Credits() {
        if (this.menuCanvas != null) {
            this.menuCanvas.Release();
            this.menuCanvas = null;
        }
        this.creditsCanvas = new CreditsCanvas(this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.creditsCanvas);
    }

    public void backtoMainMenu() {
        if (this.creditsCanvas != null) {
            this.creditsCanvas.Release();
            this.creditsCanvas = null;
        }
        if (this.helpCanvas != null) {
            this.helpCanvas.Release();
            this.helpCanvas = null;
        }
        this.menuCanvas = new MenuCanvas(this);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menuCanvas);
    }

    public void showScore(String[] rankData) {
        Alert newalert = new Alert("Score", "Your Rank is : " + rankData[0] + "\nYour Score is : " + rankData[2], null, AlertType.ALARM);
        newalert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)newalert);
    }

    public void sendScore(long score) {
        ScoreManager scoreManager = new ScoreManager();
        String[] rankData = scoreManager.RetrieveRank(String.valueOf(score));
        Alert newalert = new Alert("Score", "Current score : " + String.valueOf(score) + "\nYour Highest on Net: " + rankData[2] + "\nYour Rank on Net: " + rankData[0], null, AlertType.ALARM);
        newalert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)newalert);
    }

    public void ShowOrientationMessage(Displayable currentDisplay) {
        this.messageCanvas = new MessageCanvas(this, currentDisplay);
        Alert newAlert = new Alert("Info", "Please rotate the device to landscape then touch the screen !", null, AlertType.INFO);
        newAlert.setTimeout(-2);
        Display.getDisplay((MIDlet)this).setCurrent(newAlert, (Displayable)this.messageCanvas);
    }

    public void ReturnFromOrientationMsg(Displayable disp) {
        Display.getDisplay((MIDlet)this).setCurrent(disp);
        soundManager.PlayMusic(soundManager.getLastPlayedMusic(), -1);
    }

    public void FinishGame(long score) {
        if (this.mainCanvas != null) {
            this.mainCanvas.Release();
            this.mainCanvas = null;
        }
        this.endGameCanvas = new EndGameCanvas(this, score);
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.endGameCanvas);
    }
}

