/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Map {
    public static final int[] pathData = new int[]{223, 266, 217, 264, 211, 262, 206, 259, 200, 257, 194, 254, 189, 251, 183, 249, 178, 246, 172, 242, 167, 239, 162, 235, 157, 231, 154, 226, 153, 220, 156, 216, 162, 212, 167, 209, 173, 207, 179, 204, 184, 202, 190, 199, 195, 196, 201, 193, 206, 190, 211, 187, 217, 184, 223, 182, 229, 184, 234, 188, 238, 192, 242, 197, 245, 203, 246, 209, 247, 215, 249, 221, 254, 224, 260, 225, 266, 224, 272, 223, 278, 221, 284, 220, 290, 217, 296, 215, 301, 212, 307, 209, 312, 206, 318, 204, 324, 202, 330, 201, 337, 201, 343, 202, 349, 200, 354, 197, 357, 191, 359, 186, 361, 180, 363, 174, 364, 168, 363, 161, 361, 156, 358, 150, 353, 146, 349, 142, 344, 138, 343, 132, 345, 126, 346, 120, 347, 114, 348, 108, 349, 101, 350, 95, 349, 89, 348, 83, 346, 77, 343, 72, 339, 67, 334, 63, 328, 62, 322, 64, 317, 67, 312, 71, 307, 75, 303, 79, 298, 84, 294, 89, 290, 93, 285, 97, 280, 101, 275, 105, 270, 108, 264, 110, 258, 111, 252, 112, 246, 112, 239, 111, 233, 109, 228, 107, 223, 103, 219, 98, 216, 92, 215, 86, 216, 80, 216, 74, 211, 72, 205, 75, 200, 77, 194, 79, 188, 81, 182, 83, 176, 85, 170, 86, 164, 88, 158, 89, 151, 89, 145, 89, 139, 87, 135, 83, 131, 78, 128, 73, 124, 68, 120, 63, 117, 58, 114, 52, 113, 46, 111, 41, 110, 48, 109, 54, 108, 60, 108, 66, 107, 72, 106, 78, 104, 85, 101, 90, 97, 95, 94, 100, 92, 106, 92, 112, 91, 118, 90, 124, 90, 130, 91, 136, 92, 142, 96, 147, 102, 147, 109, 146, 115, 144, 120, 142, 125, 142, 119, 145, 115, 149, 113, 155, 115, 161, 117, 166, 120, 172, 123, 178, 126, 183, 131, 187, 136, 190, 142, 191, 149, 191, 155, 190, 161, 189, 167, 188, 173, 186, 179, 184, 185, 182, 191, 180, 197, 178, 203, 176, 209, 175, 215, 173, 221, 172, 227, 172, 233, 171, 239, 171, 246, 172, 252, 174, 258, 174, 264, 173, 269, 169, 273, 165, 277, 160, 281, 155, 284, 150, 288, 145, 292, 140, 291, 142, 288, 148, 285, 153, 283, 159, 280, 164, 278, 170, 276, 176, 275, 182, 274, 188, 274, 195, 275, 201, 275, 207, 275, 213, 274, 219, 274, 226, 277, 231, 281, 236, 286, 239, 292, 242, 298, 244, 304, 246, 309, 249, 315, 252, 320, 255, 325, 259, 330, 263, 335, 267, 339, 271, 344, 275};
    public static final int[] pathDataThemeIndexes = new int[]{0, 14, 48, 66, 78, 102, 124, 148, 186, 214};
    Image mapImage;
    Image markImage;
    SpriteLoader spriteLoader;
    Sprite mapCursor;
    int currentLevel = 0;
    int currentTheme = 0;
    long prevTimeAnim = 0L;
    long prevTimePath;
    int pointCounter;
    boolean drawCursor;

    public Map(SpriteLoader spriteLoader) {
        this.spriteLoader = spriteLoader;
        try {
            this.mapCursor = spriteLoader.getMapCursor();
            this.mapImage = Image.createImage((String)"/Images/map.jpg");
            this.markImage = Image.createImage((String)"/Images/mark.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drawCursor = true;
    }

    public void update(int currentLevel) {
        this.currentLevel = currentLevel;
        this.currentTheme = currentLevel / 5;
        this.mapCursor.setPosition(pathData[pathDataThemeIndexes[this.currentTheme]], pathData[pathDataThemeIndexes[this.currentTheme] + 1]);
        this.mapCursor.setPosition(this.mapCursor.getX() - this.mapCursor.getWidth() / 2, this.mapCursor.getY() - this.mapCursor.getHeight() / 2);
        if (this.currentTheme > 0) {
            this.pointCounter = pathDataThemeIndexes[this.currentTheme - 1];
        }
    }

    public void updateAnim(long time) {
        if (time - this.prevTimeAnim > (long)this.spriteLoader.mapCursorseq001Delay) {
            this.prevTimeAnim = time;
            this.mapCursor.nextFrame();
        }
        if (time - this.prevTimePath > 300L) {
            this.prevTimePath = time;
            if (this.pointCounter < pathDataThemeIndexes[this.currentTheme]) {
                this.pointCounter += 2;
                this.drawCursor = false;
            } else {
                this.drawCursor = true;
            }
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.mapImage, 0, 0, 20);
        if (this.drawCursor) {
            this.mapCursor.paint(g);
        }
        if (this.currentTheme > 0) {
            int i;
            for (i = 0; i < pathDataThemeIndexes[this.currentTheme - 1]; i += 2) {
                g.drawArc(pathData[i], pathData[i + 1], 3, 3, 0, 360);
            }
            for (i = pathDataThemeIndexes[this.currentTheme - 1]; i < this.pointCounter; i += 2) {
                g.drawArc(pathData[i], pathData[i + 1], 3, 3, 0, 360);
            }
            for (i = 0; i < this.currentTheme; ++i) {
                g.drawImage(this.markImage, pathData[pathDataThemeIndexes[i]] - 5, pathData[pathDataThemeIndexes[i] + 1] - 5, 20);
            }
        }
    }
}

