/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class NeedleCreature
extends Creature {
    public static final int AttackDamage = 7;
    private boolean stopMovement = false;
    int biteInterval;
    boolean enableBiting;
    private long currentTimeBite;
    private long checkTimeforInside;

    public NeedleCreature(int id, int patternType, SpriteLoader spriteLoader, CreatureInterface creatureInterface) {
        super(spriteLoader, 12, creatureInterface);
        this.pattern = new Pattern(patternType);
        this.sprite = spriteLoader.getCreatureneedle();
        if (spriteLoader.getCreatureneedle() != null) {
            this.sprite = new Sprite(this.sprite);
        }
        this.sprite.setFrameSequence(spriteLoader.creatureNeedleseq001);
        this.setCurrentAnim(0);
        this.Health = 1;
        this.speedX = 4.0f;
        this.speedY = 4.0f;
        this.biteInterval = MainCanvas.generator.nextInt(2000) + 2000;
        this.point = 250L;
        this.id = id;
        this.stopMovement = false;
        this.enableBiting = true;
        this.currentTimeBite = System.currentTimeMillis();
        this.animDelay = spriteLoader.creatureNeedleseq001Delay;
    }

    private boolean isHit(int x, int y) {
        if (this.sprite != null) {
            this.Xbuf = this.sprite.getX();
            this.Ybuf = this.sprite.getY();
            this.widthbuf = this.sprite.getWidth();
            this.heightbuf = this.sprite.getHeight();
            return x > this.Xbuf && y > this.Ybuf && x < this.Xbuf + this.widthbuf && y < this.Ybuf + this.heightbuf;
        }
        return false;
    }

    public boolean CheckTouchEvent(int x, int y) {
        if (this.Health > 0 && this.isHit(x, y)) {
            --this.Health;
            MainMidlet.soundManager.PlaySound(0);
            if (this.Health != 0) {
                this.creatureInterface.CreatureBlooded(this, x, y);
            }
            return true;
        }
        return false;
    }

    public void UpdateMovement() {
        if (!this.stopMovement) {
            this.pattern.Update(this);
        }
        this.UpdatePoint();
    }

    private void UpdatePoint() {
        if (this.point > 100L) {
            --this.point;
        }
    }

    public void UpdateAnim(long now) {
        if (now - this.checkTimeforInside > 1000L) {
            this.checkTimeforInside = now;
            this.enableBiting = this.sprite.getX() > 0 && this.sprite.getX() < MainCanvas.width ? this.sprite.getY() > 0 && this.sprite.getY() < MainCanvas.height : false;
        }
        if (now - this.currentTimeBite > (long)this.biteInterval) {
            this.currentTimeBite = now;
            if (this.enableBiting) {
                this.Bite();
            }
        }
        if (now - this.currentTime > this.animDelay) {
            this.currentTime = now;
            if (this.sprite != null) {
                this.sprite.nextFrame();
                if (this.sprite.getFrame() == 6 && this.getCurrentAnim() == 1) {
                    this.sprite.setFrameSequence(this.spriteLoader.creatureNeedleseq001);
                    this.animDelay = this.spriteLoader.creatureNeedleseq001Delay;
                    this.setCurrentAnim(0);
                    this.stopMovement = false;
                }
            }
        }
    }

    public void paint(Graphics g) {
        if (this.sprite != null) {
            this.sprite.paint(g);
        }
    }

    public void Bite() {
        this.sprite.setFrameSequence(this.spriteLoader.creatureNeedleAttack);
        this.animDelay = this.spriteLoader.creatureNeedleAttackDelay;
        this.setCurrentAnim(1);
        this.stopMovement = true;
        this.creatureInterface.CreatureBite(this);
    }

    public void Die(int x, int y) {
        super.Die(x, y);
        this.creatureInterface.CreatureDied(this, x, y);
    }

    public void Die() {
        super.Die();
        this.creatureInterface.CreatureDied(this, -1, -1);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }

    public void Release() {
        super.Die();
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }
}

