/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class PowerUp {
    public int type;
    public static final int NOPOWERUP = -1;
    public static final int TYPE_POINT250 = 0;
    public static final int TYPE_POINT500 = 1;
    public static final int TYPE_POINT1000 = 2;
    public static final int TYPE_POINT4000 = 3;
    public static final int TYPE_HEALTH50 = 4;
    public static final int TYPE_HEALTH100 = 5;
    public static final int TYPE_NUKE = 6;
    public static final int TYPE_DIAMOND = 7;
    public static final int TYPE_RUBY = 8;
    public static final int TYPE_AMETHIST = 9;
    public static final int TYPE_EMERALD = 10;
    public static final int TYPE_SAPHIRE = 11;
    public static final int TYPE_LIGHTNING = 12;
    public static final int TYPE_SLEEP = 13;
    public static final int TYPE_FIREBALL = 14;
    public static final int TYPE_BULLET = 15;
    public static final int TYPE_BLADE = 16;
    public static final int SLEEPTIME = 4000;
    protected float X;
    protected float Y;
    protected float velX;
    protected float velY;
    protected float accel;
    private PowerupInterface powerupinterface;
    Sprite sprite;
    long time;
    long animDelay;

    public PowerUp(int type, SpriteLoader spriteLoader, PowerupInterface powerupinterface) {
        try {
            switch (type) {
                case 4: {
                    this.sprite = spriteLoader.getHealth_50();
                    if (spriteLoader.getHealth_50() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.health_50seq001Delay;
                    break;
                }
                case 5: {
                    this.sprite = spriteLoader.getHealthPotion();
                    if (spriteLoader.getHealthPotion() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.healthPotionseq001Delay;
                    break;
                }
                case 0: {
                    this.sprite = spriteLoader.getStar_250();
                    if (spriteLoader.getStar250() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.star_250seq001Delay;
                    break;
                }
                case 1: {
                    this.sprite = spriteLoader.getStar_500();
                    if (spriteLoader.getStar_500() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.star_500seq001Delay;
                    break;
                }
                case 6: {
                    this.sprite = spriteLoader.getAtomicPowerup();
                    if (spriteLoader.getAtomicPowerup() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.AtomicPowerupseq001Delay;
                    break;
                }
                case 12: {
                    this.sprite = spriteLoader.getThunderPowerup();
                    if (spriteLoader.getThunderPowerup() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.thunderPowerupseq001Delay;
                    break;
                }
                case 13: {
                    this.sprite = spriteLoader.getSleepingPowerup();
                    if (spriteLoader.getSleepingPowerup() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.SleepingPowerupseq001Delay;
                    break;
                }
                case 14: {
                    this.sprite = spriteLoader.getFireballhud();
                    if (spriteLoader.getThunderPowerup() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.fireballhudseq001Delay;
                    break;
                }
                case 15: {
                    this.sprite = spriteLoader.getBulletHud();
                    if (spriteLoader.getBulletHud() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.bulletHudseq001Delay;
                    break;
                }
                case 16: {
                    this.sprite = spriteLoader.getBladesHud();
                    if (spriteLoader.getBladesHud() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                    this.animDelay = spriteLoader.bladesHudseq001Delay;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.type = type;
        this.time = 0L;
        this.velX = MainCanvas.generator.nextFloat() * 4.0f - 2.0f;
        this.velY = -4.0f;
        this.accel = 0.15f;
        this.powerupinterface = powerupinterface;
    }

    public void setPos(int x, int y) {
        if (this.sprite != null) {
            this.sprite.setPosition(x, y);
            this.X = x;
            this.Y = y;
        }
    }

    public void paint(Graphics g) {
        if (this.sprite != null) {
            this.sprite.paint(g);
        }
    }

    public boolean isOutofBorder() {
        if (this.X + (float)this.sprite.getWidth() < 0.0f) {
            return true;
        }
        if (this.X > 480.0f) {
            return true;
        }
        return this.Y > 360.0f;
    }

    public void UpdateAnim(long now) {
        if (now - this.time > this.animDelay) {
            this.time = now;
            if (this.sprite != null) {
                this.sprite.nextFrame();
            }
        }
    }

    public void UpdateMovement() {
        if (this.sprite != null && this.Y < (float)(360 + this.sprite.getHeight())) {
            this.velY += this.accel;
            this.Y += this.velY;
            this.X += this.velX;
            this.sprite.setPosition((int)this.X, (int)this.Y);
        }
    }

    public float getX() {
        return this.X;
    }

    public void setX(float X) {
        this.X = X;
    }

    public float getY() {
        return this.Y;
    }

    public void setY(float Y) {
        this.Y = Y;
    }

    public boolean CheckTouchEvent(int x, int y) {
        if (this.sprite != null) {
            int X = this.sprite.getX();
            int Y = this.sprite.getY();
            int width = this.sprite.getWidth();
            int height = this.sprite.getHeight();
            return x > X && y > Y && x < X + width && y < Y + height;
        }
        return false;
    }

    public void Unleash() {
        MainMidlet.soundManager.PlaySound(1);
        this.powerupinterface.PowerupUnleashed(this);
    }
}

