/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import net.rim.device.api.system.Alert;

public class SoundManager {
    static final int CREATURE_DIE = 0;
    static final int POWERUP_UNLEASHED = 1;
    static final int MENU_SELECT = 2;
    static final short[] SOUND_EYE_DEATH = new short[]{1500, 100, 1400, 90, 1300, 80, 1200, 70, 1200, 50, 1100, 40};
    static final short[] SOUND_POWERUP_HEALTH = new short[]{1100, 40, 1200, 50, 1300, 60, 1400, 70, 1500, 80, 1600, 90};
    static final short[] SOUND_BUTTON_SELECT = new short[]{1700, 30, 1400, 30};
    static final int MUSIC_THEME_WATER = 0;
    static final int MUSIC_THEME_DESERT = 1;
    static final int MUSIC_THEME_SWAMP = 2;
    static final int MUSIC_THEME_JUNGLE = 3;
    static final int MUSIC_THEME_UNDERGROUND = 4;
    static final int MUSIC_MENU = 5;
    static final int MUSIC_MAP = 6;
    static final int MUSIC_THEME_SCORE = 7;
    static final int MUSIC_THEME_BOSS = 8;
    static short volumeValue = (short)60;
    static short lastPlayedMusic;
    Player musicPlayer = null;
    VolumeControl vc;

    public SoundManager() {
        lastPlayedMusic = (short)5;
    }

    public static short getLastPlayedMusic() {
        return lastPlayedMusic;
    }

    public void PlayMusic(int index, int loopcount) {
        InputStream is = null;
        switch (index) {
            case 5: {
                is = this.getClass().getResourceAsStream("/Sounds/menu.mid");
                lastPlayedMusic = (short)5;
                break;
            }
            case 6: {
                is = this.getClass().getResourceAsStream("/Sounds/map.mid");
                lastPlayedMusic = (short)6;
                break;
            }
            case 7: {
                is = this.getClass().getResourceAsStream("/Sounds/score.mid");
                lastPlayedMusic = (short)7;
                break;
            }
            case 4: {
                is = this.getClass().getResourceAsStream("/Sounds/theme1.mid");
                lastPlayedMusic = (short)4;
                break;
            }
            case 0: {
                is = this.getClass().getResourceAsStream("/Sounds/theme2.mid");
                lastPlayedMusic = 0;
                break;
            }
            case 2: {
                is = this.getClass().getResourceAsStream("/Sounds/theme3.mid");
                lastPlayedMusic = (short)2;
                break;
            }
            case 1: {
                is = this.getClass().getResourceAsStream("/Sounds/theme4.mid");
                lastPlayedMusic = 1;
                break;
            }
            case 3: {
                is = this.getClass().getResourceAsStream("/Sounds/theme5.mid");
                lastPlayedMusic = (short)3;
                break;
            }
            case 8: {
                is = this.getClass().getResourceAsStream("/Sounds/boss.mid");
                lastPlayedMusic = (short)8;
            }
        }
        try {
            this.musicPlayer = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            this.musicPlayer.prefetch();
            this.musicPlayer.realize();
            this.musicPlayer.setLoopCount(loopcount);
            this.musicPlayer.start();
            Control[] cs = this.musicPlayer.getControls();
            for (int i = 0; i < cs.length; ++i) {
                if (!(cs[i] instanceof VolumeControl)) continue;
                this.vc = (VolumeControl)cs[i];
            }
            this.vc.setLevel((int)volumeValue);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void VolumeDown() {
        if ((volumeValue = (short)(volumeValue - 20)) < 0) {
            volumeValue = 0;
        }
        this.vc.setLevel((int)volumeValue);
    }

    public void VolumeUp() {
        if ((volumeValue = (short)(volumeValue + 20)) > 100) {
            volumeValue = (short)100;
        }
        this.vc.setLevel((int)volumeValue);
    }

    public void StopMusic() {
        try {
            if (this.musicPlayer != null) {
                this.musicPlayer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void PlaySound(int index) {
        switch (index) {
            case 0: {
                Alert.startAudio((short[])SOUND_EYE_DEATH, (int)volumeValue);
                break;
            }
            case 1: {
                Alert.startAudio((short[])SOUND_POWERUP_HEALTH, (int)volumeValue);
                break;
            }
            case 2: {
                Alert.startAudio((short[])SOUND_BUTTON_SELECT, (int)volumeValue);
            }
        }
    }
}

