/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class WormCreature
extends Creature {
    boolean isMoving;
    public static final int AttackDamage = 5;

    public WormCreature(int id, int patternType, SpriteLoader spriteLoader, CreatureInterface creatureInterface) {
        super(spriteLoader, 7, creatureInterface);
        this.pattern = new Pattern(patternType);
        this.sprite = spriteLoader.getCreatureworm();
        if (spriteLoader.getCreatureworm() != null) {
            this.sprite = new Sprite(this.sprite);
        }
        this.id = id;
        this.Health = 1;
        this.speedX = 5.0f;
        this.speedY = 5.0f;
        this.point = 250L;
        this.isMoving = true;
        this.sprite.setFrameSequence(spriteLoader.creatureWormseq001);
        this.setCurrentAnim(0);
        this.animDelay = spriteLoader.creatureWormseq001Delay;
    }

    private boolean isHit(int x, int y) {
        if (this.sprite != null) {
            this.Xbuf = this.sprite.getX();
            this.Ybuf = this.sprite.getY();
            this.widthbuf = this.sprite.getWidth();
            this.heightbuf = this.sprite.getHeight();
            return x > this.Xbuf && y > this.Ybuf && x < this.Xbuf + this.widthbuf && y < this.Ybuf + this.heightbuf;
        }
        return false;
    }

    public boolean CheckTouchEvent(int x, int y) {
        if (this.Health > 0 && this.isHit(x, y)) {
            --this.Health;
            MainMidlet.soundManager.PlaySound(0);
            if (this.Health != 0) {
                this.creatureInterface.CreatureBlooded(this, x, y);
            }
            return true;
        }
        return false;
    }

    public void UpdateMovement() {
        if (this.isMoving) {
            this.pattern.Update(this);
        }
        this.UpdatePoint();
        int state = this.pattern.getState();
        if (state == 4) {
            if (this.isMoving) {
                this.sprite.setFrameSequence(this.spriteLoader.creatureWormseq001);
                this.sprite.setFrame(0);
                this.animDelay = this.spriteLoader.creatureWormseq001Delay;
            }
            this.isMoving = false;
            this.setCurrentAnim(1);
        }
    }

    private void UpdatePoint() {
        if (this.point > 100L) {
            --this.point;
        }
    }

    public void UpdateAnim(long now) {
        if (now - this.currentTime > this.animDelay) {
            this.currentTime = now;
            if (this.sprite != null && !this.isMoving) {
                this.sprite.nextFrame();
                if (this.sprite.getFrame() == 7 && this.getCurrentAnim() == 1) {
                    this.creatureInterface.CreatureBite(this);
                }
                if (this.sprite.getFrame() == 9 && this.getCurrentAnim() == 1) {
                    this.sprite.setFrameSequence(this.spriteLoader.creatureWormseq001);
                    this.animDelay = this.spriteLoader.creatureWormseq001Delay;
                    this.setCurrentAnim(0);
                    this.isMoving = true;
                }
            }
        }
    }

    public void paint(Graphics g) {
        if (this.sprite != null) {
            this.sprite.paint(g);
        }
    }

    public void Die() {
        super.Die();
        this.creatureInterface.CreatureDied(this, -1, -1);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }

    public void Die(int x, int y) {
        super.Die(x, y);
        this.creatureInterface.CreatureDied(this, x, y);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }
}

