#include "utils.fx"

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
sampler2D inputTex0 : register(s0);
sampler2D inputTex1 : register(s1);

Texture g_inputBgTexture;
Texture g_inputNoiseTexture;
Texture g_inputNoisePermTexture;
float4x4 	g_worldViewProjection;
float		g_noisePhase0;
float		g_noisePhase1;


sampler BgSampler = sampler_state
{
	Texture = <g_inputBgTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = POINT;
  AddressU = Wrap;
  AddressV = Wrap;
};


sampler NoiseSampler = sampler_state
{
	Texture = <g_inputNoiseTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};

sampler PermSampler = sampler_state
{
	Texture = <g_inputNoisePermTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};


//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV0  : TEXCOORD0;  // vertex texture coords 
    float2 TextureUV1  : TEXCOORD1;  // vertex texture coords 
};

VS_OUTPUT NoiseVS( float4 vPos : POSITION, 
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0,
                         float2 vTexCoord1 : TEXCOORD1)
{
    VS_OUTPUT Output;

		Output.Position = vPos; // mul(vPos, g_worldViewProjection);
		Output.Diffuse = vColor;
		Output.TextureUV0 = vTexCoord0;
		Output.TextureUV1 = vTexCoord1;
    
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;
};


float4 NoisePS( float2 uv0 : TEXCOORD0, float2 uv1 : TEXCOORD1, float4 color : COLOR0) : COLOR0
{ 
		uv1 = uv0;
		uv0.x -= g_noisePhase0*0.0005;
		
		// uv0.x *= 1 + sin(g_noisePhase0*0.001 * uv0.y)*0.01;
		// uv0.y *= 1 + cos(g_noisePhase0*0.004 * uv0.x)*0.03;
		uv0.y += g_noisePhase1*0.01;
			
		float4 p = tex2D(PermSampler, uv0*0.9);
		float4 ap = p;
		
		p.x -= g_noisePhase0*0.08;
		p.y += g_noisePhase1*0.1;
		
		float4 ps;
		ps.x = p.x + uv0.x;
		ps.y = p.y + g_noisePhase1*0.1 + uv0.y;
		ps.z = 0;
		ps.w = 1;
		
		// float4 p2 = tex2Dlod(PermSampler, ps) - 0.5;
		
		float ss = 0.3 + sin(-g_noisePhase0*0.01)*0.2;
		float4 puv = p*ss; // + p2*0.02;
		// puv.w *= (1.0- (uv0.y-0.5) )*18;
		// puv.x*=0.1;
		// puv.y*=0.2;
		// puv += g_noisePhase1*0.01;
		// puv.w *= 4;
		
		float4 uvw;
		uvw.x = uv1.x;
		uvw.y = uv1.y;
		uvw.z = 0;
		uvw.w = 0;
		
		// puv += g_noisePhase1*0.02;
		
		float4 bgc = tex2Dlod(BgSampler, uvw);

		float4 c0 = tex2D(NoiseSampler, puv+uvw) - 0.2;
		c0 *= 1.5;
		c0 -= 0.5;
		
		float4 c = c0; // lerp(c0, c1, uv1.y + 0.4);
		// c += 0.5;
  	
  	return (bgc*color - c*0.4);
}


technique Plane
{
    pass P0
    {   
        VertexShader = compile vs_3_0 NoiseVS( );
        PixelShader  = compile ps_3_0 NoisePS( ); 
    }
}


