float    g_fTime;                   // App's time in seconds
//float4x4 g_mWorld;                  // World matrix for object
float4x4 g_mWorldViewProjection;    // World * View * Projection matrix
float4	g_bgColor;
float	g_canvasBrightness;
const int g_stripeSubTextures = 0;
const int g_currentSubTexture = 0;
float g_stripeSubTextureX = 0;
float g_stripeSubTextureWidth = 0;
float g_bumpColorFactor = 0.3;
float g_paintColorFactor = 2.0;
float g_blurFactor = 0.1;
float g_blurContrast = 1.0;


float g_paintColorSaturation;
float g_paintBrightness;

texture InputTexture;
texture GradientTexture;
texture NoiseTexture;


//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Vertex shader output structure
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Position   : POSITION;   // vertex position 
    float4 Diffuse    : COLOR0;     // vertex diffuse color (note that COLOR0 is clamped from 0..1)
    float2 TextureUV0  : TEXCOORD0;  // vertex texture coords 
    float2 TextureUV1  : TEXCOORD1;  // vertex texture coords 
};

sampler2D inputTex0 : register(s0);
sampler2D inputTex1 : register(s1);
	

float g_flip;

//--------------------------------------------------------------------------------------
// This shader computes standard transform and lighting
//--------------------------------------------------------------------------------------
VS_OUTPUT RenderSceneVS( float4 vPos : POSITION, 
												 float4 vColor : COLOR0,
                         float2 vTexCoord0 : TEXCOORD0,
                         float2 vTexCoord1 : TEXCOORD1)
{
    VS_OUTPUT Output;

/*
		float4x4 worldViewProjection = g_mWorldViewProjection;
		
		float2 sc;
		sincos(g_fTime, sc.x, sc.y);
		
		float4 rvPos = vPos;
		rvPos.x = vPos.x * sc.y + vPos.y * sc.x;
		rvPos.y = vPos.x * sc.x - vPos.y * sc.y;
		
		Output.Position = rvPos;
		Output.Position = mul(rvPos, worldViewProjection);
		*/
			
		vPos.y *= g_flip;
		
		Output.Position = vPos;
		Output.Diffuse = vColor; // (255, 255, 255, 255);
		Output.TextureUV0 = vTexCoord0;
		Output.TextureUV1 = vTexCoord1;
    
    return Output;    
}


//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : COLOR0;  // Pixel color    
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------

float	getGrayScale(float4 a_color)
{
	   float4 rgb2lum = float4(0.30, 0.59, 0.11, 0);
	    
     return dot(a_color, rgb2lum);
}

float4 RenderScenePS( float2 uv0 : TEXCOORD0, float2 uv1 : TEXCOORD1, float4 color : COLOR0) : COLOR0
{ 
	float offset = 0.001;
	float offset2 = 0.1;
	float scale = 4.8f;
	float scale2 = 0.1f;
	
    float4 Color; 
    float4 OrigColor;
    OrigColor = tex2D (inputTex0, uv0);
    
/*
	const int SCALE = 5;
	
	float2 ouv = In.TextureUV0;
	float2 uv;
	int count = 0;
    for (int y=-SCALE; y<=SCALE; y++)
    	for (int x=-SCALE; x<=SCALE; x++)
    	{
    		uv.x = ouv.x + x*0.005; 
    		uv.y = ouv.y - y*0.001;
    		
    		float a = (SCALE - (x)) * (SCALE - (y));
    		a *= 0.01;
    		Color += (tex2D(inputTex0, uv.xy) * a);
    		
    		count++;
	   	}
    
    OrigColor = OrigColor * (Color * 0.2);
*/
	  Color = OrigColor;
    
    // offset2 += (Color.r+Color.g)*0.05;
    
    float2 displacementL = uv0 - (offset2); // * ((0.5 - Color.r)));
    float2 displacementR = uv0 + (offset2); //  * ((0.5 - Color.g)));;

    // Color += tex2D(inputTex0, uv1); // +displacementL);	
    
    Color += tex2D( inputTex0 , uv0+offset)*scale; 
		Color -= tex2D( inputTex0 , uv0-offset)*scale; 
	
	return Color;
		
   Color = Color*g_bumpColorFactor + OrigColor*g_paintColorFactor;
    
    /*
    float4 ct = Color + 0.8;
    float a = sqrt(ct.r*ct.r + ct.g*ct.g + ct.b*ct.b);
    a *= 0.5;
    */
    // a *= a * 0.4;
    // a = 0.5;
    // a *= a;
    // a = 0.5;
    
    /*if (a>1) a=1;
    if (a<0.1) a=0.1;
   */
   
   	// a = 0;
   
    float4 bgColor = (tex2D(inputTex1, uv1)*g_canvasBrightness*0.06);
    // g_bgColor += 0.5;
    // bgColor = bgColor + g_bgColor;
    // float4 ocolor = lerp(bgColor, (Color), 0.7); // getGrayScale(Color)*1.2);
        
    float4 ocolor = bgColor*(Color*getGrayScale(Color)*10.8)*g_bgColor;
 
    return ocolor;
}



sampler DistortSampler = sampler_state
{
	Texture = <InputTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Clamp;
};

float4 blur( float2 uv0 : TEXCOORD0, float2 uv1 : TEXCOORD1, float4 color : COLOR0) : COLOR0
{ 
		float2 ouv = uv0;
		float4 ncolor = tex2D(inputTex0, ouv); // In.Diffuse;
		
		float sx = sin(ncolor.y*2)*0.2f;
		float sy = sin(ncolor.z*3)*0.2f;

		float4 colorSum = 0; // 
		float4 ocolor = tex2D(DistortSampler, ouv);;
		for (int i=0; i<g_stripeSubTextures; i++)
		{
			float x = i * g_stripeSubTextureWidth;
			
			float2 uv = ouv;
			uv.x += x;
			uv.x += sx;
			uv.y += sy;
			
			int c = g_stripeSubTextures - i;

			float alpha = 1-(c / g_stripeSubTextures);
			alpha = 1.0f/g_stripeSubTextures;
			// alpha *= 0.05;
			// alpha = 0.04f;
			float4 cc = tex2D(DistortSampler, uv);
			cc -= 0.5;
			cc *= g_blurContrast;
			cc += 0.5;
			
			colorSum += cc * alpha;	
		}
		colorSum = lerp(ocolor, colorSum, g_blurFactor);
		// colorSum = lerp(ocolor-colorSum, ocolor, 1.0);
		// colorSum = (ocolor-colorSum) * ocolor;
		
		return colorSum * color * 1;
	
		const float scale = 1.0f;
		const float off = 1.00f;
		
		const float SSCALE = 0.025f;
		const float SSCALE2 = SSCALE *0.5;
		
		float2 uv = uv0;
		
	
    float4 OrigColor;
    float4 Color = 0; // tex2D (input, uv);
 //    OrigColor = tex2D(inputTex0, uv0); // In.Diffuse;
    
    ncolor = tex2D(inputTex0, uv); // In.Diffuse;
	//ouv.x += sin(ncolor.x+ncolor.y)*0.45f;
	//ouv.y += sin(ncolor.z)*0.45f;
 	OrigColor = ncolor; // tex2D(inputTex0, uv); // In.Diffuse;
    
    // OrigColor *= 2.6;
    
    /*
	  OrigColor.x = uv.x;
	  OrigColor.y = uv.y;
	  OrigColor.z = 0.5;
	  OrigColor.w = 1;  
	  */
	    
    float2 off2d;
    

	const int SCALE = 2;
	
	int count = 0;
    for (int y=-SCALE; y<=SCALE; y++)
    	for (int x=-SCALE; x<=SCALE; x++)
    	{
    		uv.x = ouv.x + x*0.002; 
    		uv.y = ouv.y - y*0.002;
    		
    		float a = (SCALE - (x)) * (SCALE - (y));
    		// a /= 25;
    		a *= 0.07;
    		// a = 1.0 + a; // *0.5f;
    		Color += (tex2D(inputTex0, uv.xy) * a); ///1.0;
    		
    		count++;
    	}
 
    	
  		// Color = Color / count;
  		
  		// Color = tex2D(input, In.TextureUV);
  		
  		/*
 			Color -= 0.5;
 			Color *= 2.5;
 			Color += 0.5;
 			*/
  		
  	// 	OrigColor = Color;
  	
   
    // float total = (OrigColor-r + OrigColor.g + OrigColor.b)/3;
    // Color = 0.5 + Color;
    
    // Color = Color * (1 + 1.6);

    // OrigColor = lerp(Color * In.Diffuse, OrigColor, 0.8);
    OrigColor *= color;
 
   
    /*
    off *= sin(diffuse.r + diffuse.g + OrigColor.b);
    
    float4 c1 = tex2D (input, uv.xy * off);
    
    off *= cos(diffuse.b + diffuse.a + OrigColor.r);
    float4 c2 = tex2D (input, uv.xy * off);
    
    float p = (ouv.y + 0. + sin(c1.r+c2.g+c2.a));
    
		float4 noiseColor = c1*c2*p;

    OrigColor = OrigColor * diffuse;
    OrigColor = OrigColor + (noiseColor*0.15);
    */
    
    return 1; //OrigColor*1.2;
}


	
sampler PaintSampler = sampler_state
{
	Texture = <InputTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};

sampler PaintGradientSampler = sampler_state
{
	Texture = <GradientTexture>;
	MipFilter = POINT;
	MinFilter = POINT;
	MagFilter = POINT;
  AddressU = CLAMP;
  AddressV = CLAMP;
};
	
sampler PaintNoiseSampler = sampler_state
{
	Texture = <NoiseTexture>;
	MipFilter = LINEAR;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
  AddressU = Wrap;
  AddressV = Wrap;
};

static inline float	findEdgeSobel(float texelx, float2 a_uv, sampler a_sampler)
{
 	  const int NUM = 9;
	  float threshold = 0.1; // 01;
	
		float offset=1;
	
	    float2 c[NUM] = 
		{
            float2(-texelx, texelx), 
            float2( 0.00 ,  texelx),
            float2( texelx, texelx),
            float2(-texelx, 0.00),
            float2( 0.0,   0.0),
            float2( texelx, texelx),
            float2(-texelx, -texelx),
            float2( 0.00 ,  -texelx),
            float2( texelx,-texelx),
	   };
	   
	   float m[NUM] =
	   {
	   		-1,
	   		-1,
	   		-1,
	   		
	   		-1,
	   		12,
	   		-1,
	   		
	   		-1,
	   		-1,
	   		-1
	   };
	
	   // float4 col[NUM];    
	   int i;
	   /*
	
	   
	   col[0] = tex2D(a_sampler, a_uv + c[0]);
	   col[1] = tex2D(a_sampler, a_uv + c[1]);
	   col[2] = tex2D(a_sampler, a_uv + c[2]);
	   col[3] = tex2D(a_sampler, a_uv + c[3]);
	   col[4] = tex2D(a_sampler, a_uv + c[4]);
	   col[5] = tex2D(a_sampler, a_uv + c[5]);
	   col[6] = tex2D(a_sampler, a_uv + c[6]);
	   col[7] = tex2D(a_sampler, a_uv + c[7]);
	   col[8] = tex2D(a_sampler, a_uv + c[8]);
	   */

	   
	
	   float3 rgb2lum = float3(0.30, 0.59, 0.11);
	    
	   float lum[NUM];
	   float total = 0;
     lum[0] = dot(tex2D(a_sampler, a_uv + c[0]), rgb2lum);
     lum[1] = dot(tex2D(a_sampler, a_uv + c[1]), rgb2lum);
     lum[2] = dot(tex2D(a_sampler, a_uv + c[2]), rgb2lum);
     lum[3] = dot(tex2D(a_sampler, a_uv + c[3]), rgb2lum);
     lum[4] = dot(tex2D(a_sampler, a_uv + c[4]), rgb2lum);
     lum[5] = dot(tex2D(a_sampler, a_uv + c[5]), rgb2lum);
     lum[6] = dot(tex2D(a_sampler, a_uv + c[6]), rgb2lum);
     lum[7] = dot(tex2D(a_sampler, a_uv + c[7]), rgb2lum);
     lum[8] = dot(tex2D(a_sampler, a_uv + c[8]), rgb2lum);

	   for (i = 0; i < NUM; i++) 
	   {
	     total += lum[i]*m[i];
	   }
	   
		float x = lum[2]+  lum[8]+2*lum[5]-lum[0]-2*lum[3]-lum[6];
    float y = lum[6]+2*lum[7]+  lum[8]-lum[0]-2*lum[1]-lum[2];	   
	
	   float edge = ((x*x + y*y) < threshold)? 1.0:0.0;
	   	
	   return 1-edge;
}

static inline float	findEdge(float texelx, float2 a_uv, sampler a_sampler)
{
	float2 uv = a_uv;
	
	float4 col[5];
	
	col[0] = tex2D(a_sampler, uv + float2(0, -texelx));
	col[1] = tex2D(a_sampler, uv + float2(0, +texelx));
	col[2] = tex2D(a_sampler, uv + float2(-texelx, 0));
	col[3] = tex2D(a_sampler, uv + float2(+texelx, 0));
	col[4] = tex2D(a_sampler, uv);
		
   float3 rgb2lum = float3(0.30, 0.59, 0.11);
   
   float sum = 0;
   
   sum -= dot(col[0], rgb2lum)*4;
   sum -= dot(col[1], rgb2lum)*4;
   sum -= dot(col[2], rgb2lum)*4;
   sum -= dot(col[3], rgb2lum)*4;
   sum += dot(col[4], rgb2lum)*16;
	    
	 sum *= 0.3f;
	 
	 sum -= 0.5;
	 sum *= 2.0;
	 sum += 0.5;
	 
	 // if (sum<0) sum = -sum;
	 // if (sum>1) sum = -sum;
	 
	return sum;
}

float randomNoise = 0;

float4	convertRgbToYuv(float4 a_rgb)
{
		float4 yuv;
		/*
		yuv.x = (0.257*a_rgb.r) + (0.504*a_rgb.g) + (0.098*a_rgb.b) + (16.0f/256.0f);
		yuv.y = (0.439*a_rgb.r) - (0.368*a_rgb.g) + (0.071*a_rgb.b);
		yuv.z =-(0.148*a_rgb.r) - (0.291*a_rgb.g) + (0.439*a_rgb.b);
		
		yuv.x = clamp(yuv.x, 0, 1);
		yuv.y = clamp(yuv.y, -0.5f, 0.5f);
		yuv.z = clamp(yuv.z, -0.5f, 0.5f);
		*/
		
		yuv.x = 0.299*a_rgb.r + 0.587*a_rgb.g + 0.114*a_rgb.b;
		yuv.y = (a_rgb.b-yuv.x)*0.565;
		yuv.z = (a_rgb.r-yuv.x)*0.713;
		yuv.w = 1;
		
		return yuv;
}

float4	convertYuvToRgb(float4 a_yuv)
{
	float4 rgb;
	/*
	float y = 1.164 * (a_yuv.x - (16.0f/256.0f));
	float u = a_yuv.y;
	float v = a_yuv.z;
	
	rgb.r = y	+ 2.018*u;
	rgb.g = y - 0.813*v - 0.391*u;
	rgb.b = y - 1.596*v;

	rgb.x = clamp(rgb.x, 0, 1);
	rgb.y = clamp(rgb.y, 0, 1);
	rgb.z = clamp(rgb.z, 0, 1);
	*/
	
	rgb.r = a_yuv.x + 1.403*a_yuv.z;
	rgb.g = a_yuv.x - 0.344*a_yuv.y - 0.713*a_yuv.z;
	rgb.b = a_yuv.x + 1.770*a_yuv.y;
	rgb.w = 1;
	
	return rgb;
}

float4 blur2( float2 uv0 : TEXCOORD0, float2 uv1 : TEXCOORD1, float4 color : COLOR0) : COLOR0
{ 
		float4 ouv;
		ouv.x = uv0.x;
		ouv.y = uv0.y;
		ouv.z = 0;
		// ouv.w = 6.0;
		float4 oouv = ouv;
		
		// return tex2Dlod(PaintSampler, ouv);
		
		
		float edge = findEdgeSobel(0.015f, ouv, PaintSampler);
		// edge = 0;
		edge *= 0.4;
		
		// float4 samp = tex2D(PaintSampler, ouv);
		ouv -=  float4(0.005f, 0.005f, 0, 0);
		float4 col = tex2D(PaintNoiseSampler, ouv);
		col -= 0.5;
		// col += samp;
		
		
		float d = getGrayScale(col);

		ouv.w = (1-edge)*3; // + 2.5;
		float scale = 0.025f * (1-edge);
		ouv.x += col.x*scale; // - 0.025f;
		ouv.y += col.y*scale; // - 0.025f; // (d-0.5)*scale; // - 0.025f;;
		
		//ouv.x += sin(col.g*5+col.r*10+randomNoise)*0.015f;
		//ouv.y += sin(col.g*3+col.b*5+randomNoise)*0.015f;
		
		float4 inputCol;
		float w = ouv.w * 0.5;
		for (int i=0; i<4; i++)
		{
			ouv.w = w * i * (1-edge);
			inputCol += tex2Dlod(PaintSampler, ouv);
		}
		
		inputCol *= 0.18f;
		
		// inputCol = tex2Dlod(PaintSampler, float4(ouv.x, ouv.y, 0, 7));
		
		float4 yuv = convertRgbToYuv(inputCol);
		
		yuv.y *= g_paintColorSaturation;
		yuv.z *= g_paintColorSaturation;
		yuv.x *= g_paintBrightness;
		
		yuv.y = clamp(yuv.y, -0.5, 0.5);
		yuv.z = clamp(yuv.z, -0.5, 0.5);
		
		inputCol = convertYuvToRgb(yuv); // + edge;
		
		// float4 gradient;
		
		// inputCol = saturate(inputCol);
		
		// gradient = tex2D(PaintGradientSampler, inputCol); // *inputCol;

		/*gradient.r = tex2D(PaintGradientSampler, float2(inputCol.r, 0)).x;
		gradient.g = tex2D(PaintGradientSampler, float2(0, inputCol.g)).y;
		gradient.b = tex2D(PaintGradientSampler, float2(inputCol.b, inputCol.b)).z;
		gradient.a = 1;
		*/
		
		
		// inputCol = gradient;

		// inputCol = tex2D(PaintSampler, oouv) + edge;
		
		return inputCol;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target
//--------------------------------------------------------------------------------------
technique Paint
{
    pass P0
    {          
        VertexShader = compile vs_3_0 RenderSceneVS( );
        PixelShader  = compile ps_3_0 RenderScenePS( ); 
        // PixelShader  = compile ps_3_0 blur( ); 
    }
}

technique Blur
{
    pass P0
    {   
        VertexShader = compile vs_3_0 RenderSceneVS( );
        PixelShader  = compile ps_3_0 blur( ); 
        // PixelShader  = compile ps_3_0 blur( ); 
    }
}

technique LodBlur
{
	pass PO
	{	
        VertexShader = compile vs_3_0 RenderSceneVS( );
        PixelShader  = compile ps_3_0 blur2( ); 		
	}
	
}
