
float g_time;

float4x4 g_mWorld;                  // World matrix for object
float4x4 g_mView;   
float4x4 g_mWorldViewProjection;    // World * View * Projection matrix

float4 g_texCoordScale;
float4 g_texCoordOfs;

float4 g_materialDiffuse;

float g_materialAmbient;


float g_diffuseIntensity;
float g_heightIntensity;
float g_specularIntensity;

float4 g_diffuseTexCoordScale;
float4 g_diffuseTexCoordOfs;

float4 g_heightTexCoordScale;
float4 g_heightTexCoordOfs;

float4 g_specularTexCoordScale;
float4 g_specularTexCoordOfs;



struct VS_INPUT {
    float4 vPosition : POSITION;
    float3 vNormal : NORMAL;
    float2 vTexcoord : TEXCOORD0;
    float3 vTangent : TEXCOORD1; // TANGENT;
    float3 vBiNormal : TEXCOORD2; // BINORMAL;
};

struct VS_OUTPUT_BASIC {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vNormal : TEXCOORD1;
    float4  vPosSS : TEXCOORD2;
    float4  vTangent : TEXCOORD3;
    float4  vBiNormal : TEXCOORD4;
    float4  vTexcoordHS : TEXCOORD5;
};



VS_OUTPUT_BASIC vs_deferred_draw( const VS_INPUT v ) {
  VS_OUTPUT_BASIC o;
  
  o.vPosition = mul(v.vPosition, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
//  o.vPosWorld = mul(v.vPosition, g_mWorld);
  
// o.vPosSS.z = o.vPosition.z / o.vPosition.w;
// o.vDiffuse = float4(1.0, 1.0, 1.0, 1.0);
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  o.vNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
//  o.vTangent = float4((normalize(v.vTangent)+1.0)*0.5, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  o.vTexcoord = v.vTexcoord*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = v.vTexcoord*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = v.vTexcoord*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}

texture tex0;
texture tex1;
texture tex2;



sampler smDiffuse =
sampler_state {
  Texture = <tex0>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smHeight =
sampler_state {
  Texture = <tex1>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};

sampler smSpecular =
sampler_state {
  Texture = <tex2>;
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};




struct MRT_OUT {
  float4 rt0 : COLOR0; // depth
  float4 rt1 : COLOR1; // normal
  float4 rt2 : COLOR2; // diffuse
  float4 rt3 : COLOR3; // ambspec
};

MRT_OUT ps_deferred_draw( VS_OUTPUT_BASIC In ) {
  MRT_OUT o;
 
  o.rt2 = tex2D(smDiffuse, In.vTexcoord)*g_materialDiffuse*g_diffuseIntensity;
  if (o.rt2.a < 0.005)
    discard;
    

  float4 bumpe = 0;
  
  float2 res = float2(512.0, 512.0);
  
  
  
  bumpe.x = tex2D(smHeight, In.vTexcoordHS.xy+float2(1.0/res.x, 0.0)).g - tex2D(smHeight, In.vTexcoordHS.xy+float2(-1.0/res.x, 0.0)).g;
  bumpe.y = tex2D(smHeight, In.vTexcoordHS.xy+float2(0.0, 1.0/res.y)).g - tex2D(smHeight, In.vTexcoordHS.xy+float2(0.0, -1.0/res.y)).g;
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
  
     
  o.rt0 = In.vPosSS.z / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, In.vTexcoordHS.zw).g*g_specularIntensity;
  
  o.rt3.z = 0.0;  
  
  return o;
}

technique bump {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw( );
        PixelShader  = compile ps_3_0 ps_deferred_draw( );
    }
}





struct VS_OUTPUT_cfl {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vNormal : TEXCOORD1;
    float4  vPosSS : TEXCOORD2;
    float4  vTangent : TEXCOORD3;
    float4  vBiNormal : TEXCOORD4;
    float4  vTexcoordHS : TEXCOORD5;
    float4  vPosWorld : TEXCOORD6;
};


float g_cfl_normAmount = 0.0006;
float4 g_cfl_distXYZ = float4(0.4, 0.0, 0.0, 0.0);
float g_cfl_distStartX = -30.0;
float g_cfl_distMul = 0.05;
float g_cfl_distStartTime = 1.50;

float g_clipPosStart = 260.0f;
float g_clipSpeed = 16.0;

float g_cfl_normSize = 0.0;


VS_OUTPUT_cfl vs_clip_from_left( const VS_INPUT v ) {
  VS_OUTPUT_cfl o;
  
  float4 vPos = v.vPosition;
  float4 vPosW = mul(vPos, g_mWorld);
  float3 vNor = normalize(v.vNormal);
  float3 vNorW = mul(vNor, (float3x3)(g_mWorld));

  float hietsu = g_time*g_clipSpeed - (vPosW.x+g_clipPosStart) - 10.0;
  hietsu = smoothstep(0.0, 1.0, hietsu*0.01);
//   hietsu = clamp(hietsu, 0.0, 1.0);

  
  float steppo = smoothstep(g_cfl_distStartTime, g_cfl_distStartTime+2.5, g_time);
  float steppo2 = smoothstep(g_cfl_distStartTime, g_cfl_distStartTime+0.25, g_time);
  
  float kulmer = clamp(sin((vPosW.x+g_cfl_distStartX)*g_cfl_distMul-(g_time-g_cfl_distStartTime)*steppo*1.0), 0.0, 1.0);
  
  vPos = vPos + float4(vNor, 0.0)*((kulmer*g_cfl_normAmount*steppo2+hietsu*0.12)+g_cfl_normSize);
  
  vPos.y += hietsu*hietsu*5.0;
  vPos.x -= hietsu*hietsu*2.0;
  
  vPos = vPos + kulmer*g_cfl_distXYZ*steppo2;

    
  o.vPosition = mul(vPos, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vPosWorld = mul(vPos, g_mWorld);
  
// o.vPosSS.z = o.vPosition.z / o.vPosition.w;
// o.vDiffuse = float4(1.0, 1.0, 1.0, 1.0);
  o.vNormal = float4((normalize(mul(vNorW, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  float3 normalResult;

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
//  o.vTangent = float4((normalize(v.vTangent)+1.0)*0.5, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  o.vTexcoord = v.vTexcoord*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = v.vTexcoord*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = v.vTexcoord*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}


MRT_OUT ps_clip_from_left( VS_OUTPUT_cfl In ) {
  MRT_OUT o;
 
  o.rt2 = tex2D(smDiffuse, In.vTexcoord)*g_materialDiffuse*g_diffuseIntensity;
  if (o.rt2.a < 0.005)
    discard;
    
  float4 heikki = tex2D(smHeight, In.vTexcoordHS.xy);

  float clipper = (In.vPosWorld.x+g_clipPosStart-10.0+heikki.g*heikki.g*160.0) - g_time*g_clipSpeed;
    
  if (clipper < 0.0)
    discard;
    
  clipper = clamp(1.0-clipper*0.10, 0.0, 1.0);
  
 // o.rt2 *= (1.0)+(1.0-clipper)*1.0;
  o.rt2.a = 1.0;
        
  float4 bumpe = 0;
  
  float2 res = float2(512.0, 512.0);
  
 
  bumpe.x = tex2D(smHeight, In.vTexcoordHS.xy+float2(1.0/res.x, 0.0)).g - tex2D(smHeight, In.vTexcoordHS.xy-float2(1.0/res.x, 0.0)).g;
  bumpe.y = tex2D(smHeight, In.vTexcoordHS.xy+float2(0.0, 1.0/res.y)).g - tex2D(smHeight, In.vTexcoordHS.xy-float2(0.0, 1.0/res.y)).g;
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
  
     
  o.rt0 = In.vPosSS.z / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, In.vTexcoordHS.zw).g*g_specularIntensity;
  o.rt3.z = clipper;
   
  
  return o;
}


technique bumpClipFromLeft {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_clip_from_left( );
        PixelShader  = compile ps_3_0 ps_clip_from_left( );
    }
}









VS_OUTPUT_cfl vs_clip_from_right( const VS_INPUT v ) {
  VS_OUTPUT_cfl o;
  
  float4 vPos = v.vPosition;
  float4 vPosW = mul(vPos, g_mWorld);
  float3 vNor = normalize(v.vNormal);
  float3 vNorW = mul(vNor, (float3x3)(g_mWorld));

  float hietsu = g_time*g_clipSpeed - (-vPosW.x+g_clipPosStart) - 10.0;
  hietsu = smoothstep(0.0, 1.0, hietsu*0.01);
//   hietsu = clamp(hietsu, 0.0, 1.0);

  
  float steppo = smoothstep(g_cfl_distStartTime, g_cfl_distStartTime+2.5, g_time);
  float steppo2 = smoothstep(g_cfl_distStartTime, g_cfl_distStartTime+0.25, g_time);
  
  float kulmer = clamp(sin((vPosW.x+g_cfl_distStartX)*g_cfl_distMul-(g_time-g_cfl_distStartTime)*steppo*1.0), 0.0, 1.0);
  
  vPos = vPos + float4(vNor, 0.0)*((kulmer*g_cfl_normAmount*steppo2+hietsu*0.12)+g_cfl_normSize);
  
  vPos.y += hietsu*hietsu*5.0;
  vPos.x -= hietsu*hietsu*2.0;
  
  vPos = vPos + kulmer*g_cfl_distXYZ*steppo2;

    
  o.vPosition = mul(vPos, g_mWorldViewProjection);
  o.vPosSS = o.vPosition;
  
  o.vPosWorld = mul(vPos, g_mWorld);
  
// o.vPosSS.z = o.vPosition.z / o.vPosition.w;
// o.vDiffuse = float4(1.0, 1.0, 1.0, 1.0);
  o.vNormal = float4((normalize(mul(vNorW, (float3x3)(g_mView)))+0.0)*1.0, 0.0);

  float3 normalResult;

  normalResult = mul(v.vTangent, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
//  o.vTangent = float4((normalize(v.vTangent)+1.0)*0.5, 0.0);

  normalResult = mul(v.vBiNormal, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
  
  o.vTexcoord = v.vTexcoord*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = v.vTexcoord*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = v.vTexcoord*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}


MRT_OUT ps_clip_from_right( VS_OUTPUT_cfl In ) {
  MRT_OUT o;
 
  o.rt2 = tex2D(smDiffuse, In.vTexcoord)*g_materialDiffuse*g_diffuseIntensity;
  if (o.rt2.a < 0.005)
    discard;
    
  float4 heikki = tex2D(smHeight, In.vTexcoordHS.xy);

  float clipper = (-In.vPosWorld.x+g_clipPosStart-10.0+heikki.g*heikki.g*160.0) - g_time*g_clipSpeed;
    
  if (clipper < 0.0)
    discard;
    
  clipper = clamp(1.0-clipper*0.10, 0.0, 1.0);
  
 // o.rt2 *= (1.0)+(1.0-clipper)*1.0;
  o.rt2.a = 1.0;
        
  float4 bumpe = 0;
  
  float2 res = float2(512.0, 512.0);
  
 
  bumpe.x = tex2D(smHeight, In.vTexcoordHS.xy+float2(1.0/res.x, 0.0)).g - tex2D(smHeight, In.vTexcoordHS.xy-float2(1.0/res.x, 0.0)).g;
  bumpe.y = tex2D(smHeight, In.vTexcoordHS.xy+float2(0.0, 1.0/res.y)).g - tex2D(smHeight, In.vTexcoordHS.xy-float2(0.0, 1.0/res.y)).g;
  bumpe = bumpe*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
  
     
  o.rt0 = In.vPosSS.z / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, In.vTexcoordHS.zw).g*g_specularIntensity;
  o.rt3.z = clipper;
   
  
  return o;
}


technique bumpClipFromRight {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_clip_from_right( );
        PixelShader  = compile ps_3_0 ps_clip_from_right( );
    }
}

