/*
 * Decompiled with CFR 0.152.
 */
public class MSAFluidSolver2D {
    public float[] r = null;
    public float[] g = null;
    public float[] b = null;
    public float[] u = null;
    public float[] v = null;
    public float[] rOld = null;
    public float[] gOld = null;
    public float[] bOld = null;
    public float[] uOld = null;
    public float[] vOld = null;
    public final String VERSION = "1.3.0";
    static final float FLUID_DEFAULT_NX = 100.0f;
    static final float FLUID_DEFAULT_NY = 100.0f;
    static final float FLUID_DEFAULT_DT = 1.0f;
    static final float FLUID_DEFAULT_VISC = 1.0E-4f;
    static final float FLUID_DEFAULT_FADESPEED = 0.0f;
    static final int FLUID_DEFAULT_SOLVER_ITERATIONS = 10;
    protected float width;
    protected float height;
    protected float invWidth;
    protected float invHeight;
    protected int _NX;
    protected int _NY;
    protected int _numCells;
    protected float _invNX;
    protected float _invNY;
    protected float _invNumCells;
    protected float _dt;
    protected boolean _isInited = false;
    protected boolean _isRGB;
    protected int _solverIterations;
    protected float visc;
    protected float _fadeSpeed;
    protected float[] _tmp;
    protected float _avgDensity;
    protected float uniformity;
    protected float _avgSpeed;

    public String version() {
        return "1.3.0";
    }

    public MSAFluidSolver2D(int n, int n2) {
        this.setup(n, n2);
    }

    public MSAFluidSolver2D setup(int n, int n2) {
        this.setDeltaT(1.0f);
        this.setFadeSpeed(0.0f);
        this.setSolverIterations(10);
        this._NX = n;
        this._NY = n2;
        this._numCells = (this._NX + 2) * (this._NY + 2);
        this._invNumCells = 1.0f / (float)this._numCells;
        this._invNX = 1.0f / (float)this._NX;
        this._invNY = 1.0f / (float)this._NY;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.invWidth = 1.0f / this.width;
        this.invHeight = 1.0f / this.height;
        this.reset();
        this.enableRGB(false);
        return this;
    }

    public MSAFluidSolver2D setDeltaT(float f) {
        this._dt = f;
        return this;
    }

    public MSAFluidSolver2D setFadeSpeed(float f) {
        this._fadeSpeed = f;
        return this;
    }

    public MSAFluidSolver2D setSolverIterations(int n) {
        this._solverIterations = n;
        return this;
    }

    public MSAFluidSolver2D enableRGB(boolean bl) {
        this._isRGB = bl;
        return this;
    }

    public MSAFluidSolver2D setVisc(float f) {
        this.visc = f;
        return this;
    }

    public void randomizeColor() {
        int n = 0;
        while (n < this.getWidth()) {
            int n2 = 0;
            while (n2 < this.getHeight()) {
                int n3 = this.FLUID_IX(n, n2);
                this.r[n3] = this.rOld[n3] = (float)Math.random();
                if (this._isRGB) {
                    this.g[n3] = this.gOld[n3] = (float)Math.random();
                    this.b[n3] = this.bOld[n3] = (float)Math.random();
                }
                ++n2;
            }
            ++n;
        }
    }

    public void destroy() {
        this._isInited = false;
        this.r = null;
        this.rOld = null;
        this.g = null;
        this.gOld = null;
        this.b = null;
        this.bOld = null;
        this.u = null;
        this.uOld = null;
        this.v = null;
        this.vOld = null;
    }

    public void reset() {
        this.destroy();
        this._isInited = true;
        this.r = new float[this._numCells];
        this.rOld = new float[this._numCells];
        this.g = new float[this._numCells];
        this.gOld = new float[this._numCells];
        this.b = new float[this._numCells];
        this.bOld = new float[this._numCells];
        this.u = new float[this._numCells];
        this.uOld = new float[this._numCells];
        this.v = new float[this._numCells];
        this.vOld = new float[this._numCells];
        int n = 0;
        while (n < this._numCells) {
            this.vOld[n] = 0.0f;
            this.v[n] = 0.0f;
            this.uOld[n] = 0.0f;
            this.u[n] = 0.0f;
            this.bOld[n] = 0.0f;
            this.b[n] = 0.0f;
            this.gOld[n] = 0.0f;
            this.g[n] = 0.0f;
            this.rOld[n] = 0.0f;
            this.r[n] = 0.0f;
            ++n;
        }
    }

    public int getIndexForCellPosition(int n, int n2) {
        if (n < 1) {
            n = 1;
        } else if (n > this._NX) {
            n = this._NX;
        }
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > this._NY) {
            n2 = this._NY;
        }
        return this.FLUID_IX(n, n2);
    }

    public int getIndexForNormalizedPosition(float f, float f2) {
        return this.getIndexForCellPosition((int)Math.floor(f * (float)(this._NX + 2)), (int)Math.floor(f2 * (float)(this._NY + 2)));
    }

    public boolean isInited() {
        return this._isInited;
    }

    public int getNumCells() {
        return this._numCells;
    }

    public int getWidth() {
        return this._NX + 2;
    }

    public int getHeight() {
        return this._NY + 2;
    }

    public float getVisc() {
        return this.visc;
    }

    public float getAvgDensity() {
        return this._avgDensity;
    }

    public float getUniformity() {
        return this.uniformity;
    }

    public float getAvgSpeed() {
        return this._avgSpeed;
    }

    public void update() {
        this.addSourceUV();
        this.swapU();
        this.swapV();
        this.diffuseUV(0, this.visc);
        this.project(this.u, this.v, this.uOld, this.vOld);
        this.swapU();
        this.swapV();
        this.advect(1, this.u, this.uOld, this.uOld, this.vOld);
        this.advect(2, this.v, this.vOld, this.uOld, this.vOld);
        this.project(this.u, this.v, this.uOld, this.vOld);
        if (this._isRGB) {
            this.addSourceRGB();
            this.swapRGB();
            this.diffuseRGB(0, 0.0f);
            this.swapRGB();
            this.advectRGB(0, this.u, this.v);
            this.fadeRGB();
        } else {
            this.addSource(this.r, this.rOld);
            this.swapR();
            this.diffuse(0, this.r, this.rOld, 0.0f);
            this.swapRGB();
            this.advect(0, this.r, this.rOld, this.u, this.v);
            this.fadeR();
        }
    }

    protected void fadeR() {
        float f = 1.0f - this._fadeSpeed;
        this._avgDensity = 0.0f;
        this._avgSpeed = 0.0f;
        float f2 = 0.0f;
        this._avgSpeed = 0.0f;
        int n = 0;
        while (n < this._numCells) {
            this.vOld[n] = 0.0f;
            this.uOld[n] = 0.0f;
            this.rOld[n] = 0.0f;
            this._avgSpeed += this.u[n] * this.u[n] + this.v[n] * this.v[n];
            this.r[n] = Math.min(1.0f, this.r[n]);
            float f3 = this.r[n];
            this._avgDensity += f3;
            float f4 = f3 - this._avgDensity;
            f2 += f4 * f4;
            int n2 = n++;
            this.r[n2] = this.r[n2] * f;
        }
        this._avgDensity *= this._invNumCells;
        this.uniformity = 1.0f / (1.0f + f2 * this._invNumCells);
    }

    protected void fadeRGB() {
        float f = 1.0f - this._fadeSpeed;
        this._avgDensity = 0.0f;
        this._avgSpeed = 0.0f;
        float f2 = 0.0f;
        this._avgSpeed = 0.0f;
        int n = 0;
        while (n < this._numCells) {
            this.vOld[n] = 0.0f;
            this.uOld[n] = 0.0f;
            this.rOld[n] = 0.0f;
            this.bOld[n] = 0.0f;
            this.gOld[n] = 0.0f;
            this._avgSpeed += this.u[n] * this.u[n] + this.v[n] * this.v[n];
            this.r[n] = Math.min(1.0f, this.r[n]);
            this.g[n] = Math.min(1.0f, this.g[n]);
            this.b[n] = Math.min(1.0f, this.b[n]);
            float f3 = Math.max(this.r[n], Math.max(this.g[n], this.b[n]));
            this._avgDensity += f3;
            float f4 = f3 - this._avgDensity;
            f2 += f4 * f4;
            int n2 = n;
            this.r[n2] = this.r[n2] * f;
            int n3 = n;
            this.g[n3] = this.g[n3] * f;
            int n4 = n++;
            this.b[n4] = this.b[n4] * f;
        }
        this._avgDensity *= this._invNumCells;
        this._avgSpeed *= this._invNumCells;
        this.uniformity = 1.0f / (1.0f + f2 * this._invNumCells);
    }

    protected void addSourceUV() {
        int n = 0;
        while (n < this._numCells) {
            int n2 = n;
            this.u[n2] = this.u[n2] + this._dt * this.uOld[n];
            int n3 = n;
            this.v[n3] = this.v[n3] + this._dt * this.vOld[n];
            ++n;
        }
    }

    protected void addSourceRGB() {
        int n = 0;
        while (n < this._numCells) {
            int n2 = n;
            this.r[n2] = this.r[n2] + this._dt * this.rOld[n];
            int n3 = n;
            this.g[n3] = this.g[n3] + this._dt * this.gOld[n];
            int n4 = n;
            this.b[n4] = this.b[n4] + this._dt * this.bOld[n];
            ++n;
        }
    }

    protected void addSource(float[] fArray, float[] fArray2) {
        int n = 0;
        while (n < this._numCells) {
            int n2 = n;
            fArray[n2] = fArray[n2] + this._dt * fArray2[n];
            ++n;
        }
    }

    protected void advect(int n, float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float f = this._dt * (float)this._NX;
        int n2 = 1;
        while (n2 <= this._NX) {
            int n3 = 1;
            while (n3 <= this._NY) {
                float f2 = (float)n2 - f * fArray3[this.FLUID_IX(n2, n3)];
                float f3 = (float)n3 - f * fArray4[this.FLUID_IX(n2, n3)];
                if ((double)f2 > (double)this._NX + 0.5) {
                    f2 = (float)this._NX + 0.5f;
                }
                if ((double)f2 < 0.5) {
                    f2 = 0.5f;
                }
                int n4 = (int)f2;
                int n5 = n4 + 1;
                if ((double)f3 > (double)this._NY + 0.5) {
                    f3 = (float)this._NY + 0.5f;
                }
                if ((double)f3 < 0.5) {
                    f3 = 0.5f;
                }
                int n6 = (int)f3;
                int n7 = n6 + 1;
                float f4 = f2 - (float)n4;
                float f5 = 1.0f - f4;
                float f6 = f3 - (float)n6;
                float f7 = 1.0f - f6;
                fArray[this.FLUID_IX((int)n2, (int)n3)] = f5 * (f7 * fArray2[this.FLUID_IX(n4, n6)] + f6 * fArray2[this.FLUID_IX(n4, n7)]) + f4 * (f7 * fArray2[this.FLUID_IX(n5, n6)] + f6 * fArray2[this.FLUID_IX(n5, n7)]);
                ++n3;
            }
            ++n2;
        }
        this.setBoundary(n, fArray);
    }

    protected void advectRGB(int n, float[] fArray, float[] fArray2) {
        float f = this._dt * (float)this._NX;
        int n2 = 1;
        while (n2 <= this._NX) {
            int n3 = 1;
            while (n3 <= this._NY) {
                float f2 = (float)n2 - f * fArray[this.FLUID_IX(n2, n3)];
                float f3 = (float)n3 - f * fArray2[this.FLUID_IX(n2, n3)];
                if ((double)f2 > (double)this._NX + 0.5) {
                    f2 = (float)this._NX + 0.5f;
                }
                if ((double)f2 < 0.5) {
                    f2 = 0.5f;
                }
                int n4 = (int)f2;
                int n5 = n4 + 1;
                if ((double)f3 > (double)this._NY + 0.5) {
                    f3 = (float)this._NY + 0.5f;
                }
                if ((double)f3 < 0.5) {
                    f3 = 0.5f;
                }
                int n6 = (int)f3;
                int n7 = n6 + 1;
                float f4 = f2 - (float)n4;
                float f5 = 1.0f - f4;
                float f6 = f3 - (float)n6;
                float f7 = 1.0f - f6;
                this.r[this.FLUID_IX((int)n2, (int)n3)] = f5 * (f7 * this.rOld[this.FLUID_IX(n4, n6)] + f6 * this.rOld[this.FLUID_IX(n4, n7)]) + f4 * (f7 * this.rOld[this.FLUID_IX(n5, n6)] + f6 * this.rOld[this.FLUID_IX(n5, n7)]);
                this.g[this.FLUID_IX((int)n2, (int)n3)] = f5 * (f7 * this.gOld[this.FLUID_IX(n4, n6)] + f6 * this.gOld[this.FLUID_IX(n4, n7)]) + f4 * (f7 * this.gOld[this.FLUID_IX(n5, n6)] + f6 * this.gOld[this.FLUID_IX(n5, n7)]);
                this.b[this.FLUID_IX((int)n2, (int)n3)] = f5 * (f7 * this.bOld[this.FLUID_IX(n4, n6)] + f6 * this.bOld[this.FLUID_IX(n4, n7)]) + f4 * (f7 * this.bOld[this.FLUID_IX(n5, n6)] + f6 * this.bOld[this.FLUID_IX(n5, n7)]);
                ++n3;
            }
            ++n2;
        }
        this.setBoundaryRGB(n);
    }

    protected void diffuse(int n, float[] fArray, float[] fArray2, float f) {
        float f2 = this._dt * f * (float)this._NX * (float)this._NY;
        this.linearSolver(n, fArray, fArray2, f2, 1.0f + 4.0f * f2);
    }

    protected void diffuseRGB(int n, float f) {
        float f2 = this._dt * f * (float)this._NX * (float)this._NY;
        this.linearSolverRGB(n, f2, 1.0f + 4.0f * f2);
    }

    protected void diffuseUV(int n, float f) {
        float f2 = this._dt * f * (float)this._NX * (float)this._NY;
        this.linearSolverUV(n, f2, 1.0f + 4.0f * f2);
    }

    protected void project(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        int n;
        int n2 = 1;
        while (n2 <= this._NX) {
            n = 1;
            while (n <= this._NY) {
                fArray4[this.FLUID_IX((int)n2, (int)n)] = (fArray[this.FLUID_IX(n2 + 1, n)] - fArray[this.FLUID_IX(n2 - 1, n)] + fArray2[this.FLUID_IX(n2, n + 1)] - fArray2[this.FLUID_IX(n2, n - 1)]) * -0.5f / (float)this._NX;
                fArray3[this.FLUID_IX((int)n2, (int)n)] = 0.0f;
                ++n;
            }
            ++n2;
        }
        this.setBoundary(0, fArray4);
        this.setBoundary(0, fArray3);
        this.linearSolver(0, fArray3, fArray4, 1.0f, 4.0f);
        n2 = 1;
        while (n2 <= this._NX) {
            n = 1;
            while (n <= this._NY) {
                int n3 = this.FLUID_IX(n2, n);
                fArray[n3] = fArray[n3] - 0.5f * (float)this._NX * (fArray3[this.FLUID_IX(n2 + 1, n)] - fArray3[this.FLUID_IX(n2 - 1, n)]);
                int n4 = this.FLUID_IX(n2, n);
                fArray2[n4] = fArray2[n4] - 0.5f * (float)this._NX * (fArray3[this.FLUID_IX(n2, n + 1)] - fArray3[this.FLUID_IX(n2, n - 1)]);
                ++n;
            }
            ++n2;
        }
        this.setBoundary(1, fArray);
        this.setBoundary(2, fArray2);
    }

    protected void linearSolver(int n, float[] fArray, float[] fArray2, float f, float f2) {
        int n2 = 0;
        while (n2 < this._solverIterations) {
            int n3 = 1;
            while (n3 <= this._NX) {
                int n4 = 1;
                while (n4 <= this._NY) {
                    fArray[this.FLUID_IX((int)n3, (int)n4)] = (f * (fArray[this.FLUID_IX(n3 - 1, n4)] + fArray[this.FLUID_IX(n3 + 1, n4)] + fArray[this.FLUID_IX(n3, n4 - 1)] + fArray[this.FLUID_IX(n3, n4 + 1)]) + fArray2[this.FLUID_IX(n3, n4)]) / f2;
                    ++n4;
                }
                ++n3;
            }
            this.setBoundary(n, fArray);
            ++n2;
        }
    }

    protected void linearSolverRGB(int n, float f, float f2) {
        int n2 = 0;
        while (n2 < this._solverIterations) {
            int n3 = 1;
            while (n3 <= this._NX) {
                int n4 = 1;
                while (n4 <= this._NY) {
                    int n5 = this.FLUID_IX(n3, n4);
                    int n6 = n5 - 1;
                    int n7 = n5 + 1;
                    int n8 = n5 - (this._NX + 2);
                    int n9 = n5 + (this._NX + 2);
                    this.r[n5] = (f * (this.r[n6] + this.r[n7] + this.r[n8] + this.r[n9]) + this.rOld[n5]) / f2;
                    this.g[n5] = (f * (this.g[n6] + this.g[n7] + this.g[n8] + this.g[n9]) + this.gOld[n5]) / f2;
                    this.b[n5] = (f * (this.b[n6] + this.b[n7] + this.b[n8] + this.b[n9]) + this.bOld[n5]) / f2;
                    ++n4;
                }
                ++n3;
            }
            this.setBoundaryRGB(n);
            ++n2;
        }
    }

    protected void linearSolverUV(int n, float f, float f2) {
        int n2 = 0;
        while (n2 < this._solverIterations) {
            int n3 = 1;
            while (n3 <= this._NX) {
                int n4 = 1;
                while (n4 <= this._NY) {
                    int n5 = this.FLUID_IX(n3, n4);
                    int n6 = n5 - 1;
                    int n7 = n5 + 1;
                    int n8 = n5 - (this._NX + 2);
                    int n9 = n5 + (this._NX + 2);
                    this.u[n5] = (f * (this.u[n6] + this.u[n7] + this.u[n8] + this.u[n9]) + this.uOld[n5]) / f2;
                    this.v[n5] = (f * (this.v[n6] + this.v[n7] + this.v[n8] + this.v[n9]) + this.vOld[n5]) / f2;
                    ++n4;
                }
                ++n3;
            }
            this.setBoundaryRGB(n);
            ++n2;
        }
    }

    protected void setBoundary(int n, float[] fArray) {
        int n2 = 1;
        while (n2 <= this._NX) {
            if (n2 <= this._NY) {
                fArray[this.FLUID_IX((int)0, (int)n2)] = n == 1 ? -fArray[this.FLUID_IX(1, n2)] : fArray[this.FLUID_IX(1, n2)];
                fArray[this.FLUID_IX((int)(this._NX + 1), (int)n2)] = n == 1 ? -fArray[this.FLUID_IX(this._NX, n2)] : fArray[this.FLUID_IX(this._NX, n2)];
            }
            fArray[this.FLUID_IX((int)n2, (int)0)] = n == 2 ? -fArray[this.FLUID_IX(n2, 1)] : fArray[this.FLUID_IX(n2, 1)];
            fArray[this.FLUID_IX((int)n2, (int)(this._NY + 1))] = n == 2 ? -fArray[this.FLUID_IX(n2, this._NY)] : fArray[this.FLUID_IX(n2, this._NY)];
            ++n2;
        }
        fArray[this.FLUID_IX((int)0, (int)0)] = 0.5f * (fArray[this.FLUID_IX(1, 0)] + fArray[this.FLUID_IX(0, 1)]);
        fArray[this.FLUID_IX((int)0, (int)(this._NY + 1))] = 0.5f * (fArray[this.FLUID_IX(1, this._NY + 1)] + fArray[this.FLUID_IX(0, this._NY)]);
        fArray[this.FLUID_IX((int)(this._NX + 1), (int)0)] = 0.5f * (fArray[this.FLUID_IX(this._NX, 0)] + fArray[this.FLUID_IX(this._NX + 1, 1)]);
        fArray[this.FLUID_IX((int)(this._NX + 1), (int)(this._NY + 1))] = 0.5f * (fArray[this.FLUID_IX(this._NX, this._NY + 1)] + fArray[this.FLUID_IX(this._NX + 1, this._NY)]);
    }

    protected void setBoundaryRGB(int n) {
        int n2 = 1;
        while (n2 <= this._NX) {
            int n3;
            int n4;
            if (n2 <= this._NY) {
                n4 = this.FLUID_IX(0, n2);
                n3 = this.FLUID_IX(1, n2);
                this.r[n4] = n == 1 ? -this.r[n3] : this.r[n3];
                this.g[n4] = n == 1 ? -this.g[n3] : this.g[n3];
                this.b[n4] = n == 1 ? -this.b[n3] : this.b[n3];
                n4 = this.FLUID_IX(this._NX + 1, n2);
                n3 = this.FLUID_IX(this._NX, n2);
                this.r[n4] = n == 1 ? -this.r[n3] : this.r[n3];
                this.g[n4] = n == 1 ? -this.g[n3] : this.g[n3];
                this.b[n4] = n == 1 ? -this.b[n3] : this.b[n3];
            }
            n4 = this.FLUID_IX(n2, 0);
            n3 = this.FLUID_IX(n2, 1);
            this.r[n4] = n == 2 ? -this.r[n3] : this.r[n3];
            this.g[n4] = n == 2 ? -this.g[n3] : this.g[n3];
            this.b[n4] = n == 2 ? -this.b[n3] : this.b[n3];
            n4 = this.FLUID_IX(n2, this._NY + 1);
            n3 = this.FLUID_IX(n2, this._NY);
            this.r[n4] = n == 2 ? -this.r[n3] : this.r[n3];
            this.g[n4] = n == 2 ? -this.g[n3] : this.g[n3];
            this.b[n4] = n == 2 ? -this.b[n3] : this.b[n3];
            ++n2;
        }
    }

    protected void swapU() {
        this._tmp = this.u;
        this.u = this.uOld;
        this.uOld = this._tmp;
    }

    protected void swapV() {
        this._tmp = this.v;
        this.v = this.vOld;
        this.vOld = this._tmp;
    }

    protected void swapR() {
        this._tmp = this.r;
        this.r = this.rOld;
        this.rOld = this._tmp;
    }

    protected void swapRGB() {
        this._tmp = this.r;
        this.r = this.rOld;
        this.rOld = this._tmp;
        this._tmp = this.g;
        this.g = this.gOld;
        this.gOld = this._tmp;
        this._tmp = this.b;
        this.b = this.bOld;
        this.bOld = this._tmp;
    }

    protected int FLUID_IX(int n, int n2) {
        return n + (this._NX + 2) * n2;
    }
}

