/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorGraphics;
import editor.SlicksEditor;
import editor.TextInput;
import editor.TrackPanel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import other.Console;
import slicks.engine.ImageLoader;
import slicks.model.Track;
import slicks.model.TrackBlock;
import slicks.model.TrackMarker;
import slicks.model.TrackReadWrite;
import slicks.ui.Renderer;

public class EditorMenuBar
implements ActionListener {
    public static JMenuBar myMenuBar;
    JMenu menu;
    JFileChooser fc;
    ImageLoader il;
    JMenuItem fileMenu;
    JMenuItem viewMenu;
    SlicksEditor editor;

    public EditorMenuBar(JMenuBar passBar, ImageLoader il) {
        this.il = il;
        myMenuBar = passBar;
        this.menu = new JMenu("File");
        this.menu.setMnemonic(73);
        this.menu.getAccessibleContext().setAccessibleDescription("The only menu in this program that has menu items");
        myMenuBar.add(this.menu);
        this.fileMenu = new JMenuItem("Load Track", 76);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("Save Track", 83);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("Set Track Size", 84);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("Clear Track", 67);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("Make Base Track Again", null);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.menu = new JMenu("Edit");
        this.menu.setMnemonic(69);
        this.menu.getAccessibleContext().setAccessibleDescription("Edit");
        myMenuBar.add(this.menu);
        this.fileMenu = new JMenuItem("Create ControlPoints", 67);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("Stop Editing ControlPoints", 83);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.menu = new JMenu("View");
        this.menu.setMnemonic(73);
        this.menu.getAccessibleContext().setAccessibleDescription("View");
        myMenuBar.add(this.menu);
        this.fileMenu = new JMenuItem("Enable/Disable View ControlPoints", 113);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("Enable/Disable Guideboxes", 68);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("View 800x600 - NO EDIT", 114);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("View 1280x720 - EDITABLE", 115);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("View 1920x1080 - NO EDIT", 116);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
        this.fileMenu = new JMenuItem("Check Tiles", 84);
        this.menu.add(this.fileMenu);
        this.fileMenu.addActionListener(this);
    }

    public void passEditorToMenu(SlicksEditor editor) {
        this.editor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        File file;
        int returnVal;
        if (arg0.getActionCommand() == "Load Track") {
            this.fc = new JFileChooser();
            this.fc.setCurrentDirectory(new File(String.valueOf(this.editor.path) + "/res/tracks"));
            returnVal = this.fc.showOpenDialog(myMenuBar);
            if (returnVal == 0) {
                file = this.fc.getSelectedFile();
                URL url = this.editor.getResourceURL("/tracks/" + file.getName());
                Console.print("try to read " + file.getName());
                try {
                    this.editor.loadTrack(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                this.editor.trackTop.setName(file.getName());
                this.editor.loadTrackIntoTree(this.editor.trackTop);
                this.editor.editorGraphics.assignTrack(this.editor.track);
                Console.print("EditMenuBar RequestFocus");
                this.editor.trackPanel.requestFocusInWindow();
                this.editor.trackPanel.drawBuffer();
            } else {
                Console.print("Load track command cancelled by user.");
            }
        }
        if (arg0.getActionCommand() == "Save Track") {
            Console.print(arg0.getActionCommand());
            this.fc = new JFileChooser();
            this.fc.setCurrentDirectory(new File(String.valueOf(this.editor.path) + "/res/tracks"));
            returnVal = this.fc.showSaveDialog(myMenuBar);
            if (returnVal == 0) {
                file = this.fc.getSelectedFile();
                String savePath = String.valueOf(this.editor.path) + "\\res\\tracks\\" + file.getName();
                Console.print("savePath: " + savePath);
                String name = file.getName();
                name.replace(".txt", "");
                this.editor.track.trackName = name;
                Console.print("track name is: " + name);
                TrackReadWrite tr = new TrackReadWrite();
                try {
                    tr.writeTrack(this.editor.track, savePath);
                }
                catch (IOException e) {
                    Console.print("");
                }
            } else {
                Console.print("Save track command cancelled by user.");
            }
        }
        if (arg0.getActionCommand() == "Set Track Size") {
            if (this.editor.track != null) {
                TextInput cfr_ignored_0 = this.editor.textInput;
                TextInput.createAndShowGUI(this.editor.track);
            } else {
                Console.print("no Track object");
            }
            this.editor.trackPanel.adjustmentValueChanged(null);
            this.editor.trackPanel.validate();
        }
        if (arg0.getActionCommand() == "Clear Track") {
            if (this.editor.track != null) {
                Console.print("Track cleared");
                this.editor.track = null;
                this.editor.editorGraphics.track = null;
                this.editor.track = new Track();
                this.editor.editorGraphics.assignTrack(this.editor.track);
                this.editor.loadTrackIntoTree(this.editor.trackTop);
                this.editor.trackPanel.assignTrackToPanel(this.editor.track, this.editor.editorGraphics);
                this.editor.trackModel.nodeChanged(this.editor.trackTop);
            } else {
                Console.print("no Track to clear");
            }
            this.editor.trackPanel.adjustmentValueChanged(null);
            this.editor.trackPanel.validate();
        }
        if (arg0.getActionCommand() == "Make Base Track Again" && this.editor.track != null) {
            Console.print("makebaseTrackAgain");
            this.makeTrackData(this.editor.track);
            this.editor.editorGraphics.assignTrack(this.editor.track);
            this.editor.loadTrackIntoTree(this.editor.trackTop);
            this.editor.trackPanel.assignTrackToPanel(this.editor.track, this.editor.editorGraphics);
            this.editor.trackModel.nodeChanged(this.editor.trackTop);
        }
        if (arg0.getActionCommand() == "Create ControlPoints") {
            Console.print(arg0.getActionCommand());
            TrackPanel cfr_ignored_1 = this.editor.trackPanel;
            TrackPanel cfr_ignored_2 = this.editor.trackPanel;
            TrackPanel.mouseState = TrackPanel.STATE_EDIT_CONTROL_POINTS;
        }
        if (arg0.getActionCommand() == "Stop Editing ControlPoints") {
            Console.print(arg0.getActionCommand());
            TrackPanel cfr_ignored_3 = this.editor.trackPanel;
            TrackPanel cfr_ignored_4 = this.editor.trackPanel;
            TrackPanel.mouseState = TrackPanel.STATE_POINTER;
        }
        if (arg0.getActionCommand() == "Enable/Disable Guideboxes") {
            Console.print(arg0.getActionCommand());
            this.editor.editorGraphics.viewGuideBoxes = !this.editor.editorGraphics.viewGuideBoxes;
        }
        if (arg0.getActionCommand() == "Check Tiles") {
            Console.print(arg0.getActionCommand());
            this.checkTileSizes(this.editor.track);
        }
        if (arg0.getActionCommand() == "Enable/Disable View ControlPoints") {
            this.editor.editorGraphics.viewControlPoints = !this.editor.editorGraphics.viewControlPoints;
        }
        if (arg0.getActionCommand() == "View 800x600 - NO EDIT") {
            SlicksEditor.allowEdit = false;
            Console.print(arg0.getActionCommand());
            EditorGraphics cfr_ignored_5 = this.editor.editorGraphics;
            EditorGraphics cfr_ignored_6 = this.editor.editorGraphics;
            EditorGraphics.resolution = EditorGraphics.RES_800x600;
            this.editor.editorGraphics.loadTrackImages(this.editor.track);
            this.editor.trackPanel.drawPanel();
            this.editor.trackPanel.validate();
            this.editor.trackPanel.hbar.paint(this.editor.trackPanel.getGraphics());
            this.editor.trackPanel.vbar.paint(this.editor.trackPanel.getGraphics());
            this.editor.trackPanel.adjustmentValueChanged(null);
            this.editor.trackPanel.validate();
        }
        if (arg0.getActionCommand() == "View 1280x720 - EDITABLE") {
            SlicksEditor.allowEdit = true;
            Console.print(arg0.getActionCommand());
            EditorGraphics cfr_ignored_7 = this.editor.editorGraphics;
            EditorGraphics cfr_ignored_8 = this.editor.editorGraphics;
            EditorGraphics.resolution = EditorGraphics.RES_1280x720;
            this.editor.editorGraphics.loadTrackImages(this.editor.track);
            this.editor.trackPanel.drawPanel();
            this.editor.trackPanel.adjustmentValueChanged(null);
            this.editor.trackPanel.validate();
        }
        if (arg0.getActionCommand() == "View 1920x1080 - NO EDIT") {
            SlicksEditor.allowEdit = false;
            Console.print(arg0.getActionCommand());
            EditorGraphics cfr_ignored_9 = this.editor.editorGraphics;
            EditorGraphics cfr_ignored_10 = this.editor.editorGraphics;
            EditorGraphics.resolution = EditorGraphics.RES_1920x1080;
            this.editor.editorGraphics.loadTrackImages(this.editor.track);
            this.editor.trackPanel.drawPanel();
            this.editor.trackPanel.adjustmentValueChanged(null);
            this.editor.trackPanel.validate();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Console.print("textbox");
    }

    public void checkTileSizes(Track track) {
        int i = 0;
        while (i < track.trackpieces.size()) {
            TrackBlock piece = track.trackpieces.elementAt(i);
            Point piecewh = piece.getWH();
            if (Renderer.resolution != Renderer.RES_1280x720) {
                piecewh.x = (int)((double)piecewh.x * Renderer.screenRatio[Renderer.resolution]);
                piecewh.y = (int)((double)piecewh.y * Renderer.screenRatio[Renderer.resolution]);
            }
            if (track.trackpieces.elementAt((int)i).blockImg.getWidth() != piecewh.x) {
                Console.print("piece " + i + " width discrepancy : " + track.trackpieces.elementAt((int)i).blockImg.getWidth() + "," + piecewh.x);
            }
            if (track.trackpieces.elementAt((int)i).blockImg.getHeight() != piecewh.y) {
                Console.print("piece " + i + " height discrepancy : " + track.trackpieces.elementAt((int)i).blockImg.getHeight() + "," + piecewh.y);
            }
            ++i;
        }
    }

    public void makeTrackData(Track track) {
        Console.print("load TrackPieceData");
        track.trackpieces.removeAllElements();
        track.invisiblepieces.removeAllElements();
        track.markerpieces.removeAllElements();
        track.width = 1280;
        track.height = 720;
        TrackBlock trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 57;
        trackpiece.y = 60;
        trackpiece.width = 389;
        trackpiece.height = 166;
        trackpiece.filename = "/trackpieces/a1.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 446;
        trackpiece.y = 85;
        trackpiece.width = 386;
        trackpiece.height = 216;
        trackpiece.filename = "/trackpieces/a2.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 832;
        trackpiece.y = 161;
        trackpiece.width = 225;
        trackpiece.height = 182;
        trackpiece.filename = "/trackpieces/a3.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 1057;
        trackpiece.y = 205;
        trackpiece.width = 177;
        trackpiece.height = 145;
        trackpiece.filename = "/trackpieces/a4.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 41;
        trackpiece.y = 226;
        trackpiece.width = 163;
        trackpiece.height = 168;
        trackpiece.filename = "/trackpieces/b1.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 1070;
        trackpiece.y = 350;
        trackpiece.width = 168;
        trackpiece.height = 93;
        trackpiece.filename = "/trackpieces/b2.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 52;
        trackpiece.y = 394;
        trackpiece.width = 229;
        trackpiece.height = 199;
        trackpiece.filename = "/trackpieces/c1.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 281;
        trackpiece.y = 438;
        trackpiece.width = 97;
        trackpiece.height = 188;
        trackpiece.filename = "/trackpieces/c2.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 378;
        trackpiece.y = 480;
        trackpiece.width = 336;
        trackpiece.height = 167;
        trackpiece.filename = "/trackpieces/c3.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 714;
        trackpiece.y = 472;
        trackpiece.width = 163;
        trackpiece.height = 163;
        trackpiece.filename = "/trackpieces/c4.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 877;
        trackpiece.y = 453;
        trackpiece.width = 143;
        trackpiece.height = 159;
        trackpiece.filename = "/trackpieces/c5.png";
        track.trackpieces.add(trackpiece);
        trackpiece = new TrackBlock();
        trackpiece.type = TrackBlock.BLOCK_TYPE_TRACK;
        trackpiece.x = 1020;
        trackpiece.y = 442;
        trackpiece.width = 210;
        trackpiece.height = 145;
        trackpiece.filename = "/trackpieces/c6.png";
        track.trackpieces.add(trackpiece);
        TrackMarker startPos1 = new TrackMarker();
        startPos1.type = TrackBlock.BLOCK_TYPE_MARKER;
        startPos1.setXY(new Point(120, 120));
        startPos1.filename = "/markers/start.png";
        track.markerpieces.add(startPos1);
    }
}

