/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.SlicksEditor;
import editor.TrackPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import other.Console;
import slicks.model.TrackBlock;
import slicks.model.TrackMarker;

public class PiecePanel
extends JScrollPane
implements MouseListener,
ImageObserver {
    SlicksEditor editor;
    JScrollPane view;
    JLabel piecepicture = new JLabel();
    ImageIcon[] icons;
    int[] heightindex;

    public PiecePanel(SlicksEditor ed) {
        this.piecepicture.setFont(this.piecepicture.getFont().deriveFont(2));
        this.piecepicture.setHorizontalAlignment(0);
        this.icons = new ImageIcon[12];
        this.heightindex = new int[12];
        this.editor = ed;
        this.view = new JScrollPane(this.piecepicture);
        this.setFocusable(true);
        this.addMouseListener(this);
    }

    public void updateLabel(String file) {
        ImageIcon icon = PiecePanel.createImageIcon(file);
        this.piecepicture.setIcon(icon);
        if (icon != null) {
            this.piecepicture.setText(null);
            this.piecepicture.setToolTipText("Click to Select");
        } else {
            this.piecepicture.setText("Image not found");
        }
        this.paintComponent(this.getGraphics(), icon);
    }

    public String makePath(DefaultMutableTreeNode node) {
        if (node.getUserObject().getClass() != String.class) {
            TreeNode[] nodepath = node.getPath();
            String root = "";
            int j = 0;
            while (j < nodepath.length) {
                if (nodepath[j].toString().compareTo("TrackLibrary") != 0) {
                    if (nodepath[j].toString().startsWith("\\")) {
                        String path = "/" + nodepath[j].toString().substring(1);
                        root = String.valueOf(root) + path;
                    } else {
                        root = String.valueOf(root) + "/" + nodepath[j].toString();
                    }
                }
                ++j;
            }
            String editorPath = root;
            return editorPath;
        }
        return null;
    }

    public void updateLabel(DefaultMutableTreeNode node) {
        int ico = 0;
        int i = 0;
        while (i < this.icons.length) {
            this.icons[i] = null;
            ++i;
        }
        DefaultMutableTreeNode next = node;
        while (next != null && ico < this.icons.length) {
            String path = this.makePath(next);
            if (path != null) {
                this.icons[ico] = PiecePanel.createImageIcon(path);
                this.heightindex[ico] = this.icons[ico].getIconHeight();
                ++ico;
                next = next.getNextNode();
                continue;
            }
            next = null;
        }
        if (this.icons[0] != null) {
            this.piecepicture.setText(null);
            this.piecepicture.setToolTipText("Click to Select");
        } else {
            this.piecepicture.setText("Image not found");
        }
        this.paintComponent(this.getGraphics(), this.icons[0]);
    }

    @Override
    public void validate() {
        Console.print("validate");
        if (this.icons[0] != null) {
            Console.print("PiecePanel RequestFocus");
            this.requestFocusInWindow();
            this.paintComponent(this.getGraphics(), this.icons[0]);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.icons[0] != null) {
            Console.print("paintPiecePic NOT WORKING");
            this.paintComponent(g, this.icons[0]);
        }
    }

    public void paintComponent(Graphics g, ImageIcon icon) {
        Dimension d = this.getSize();
        this.setBackground(this.getBackground());
        Console.print("dim w:" + d.width + ", h:" + d.height);
        g.clearRect(0, 0, d.width, d.height);
        g.setColor(Color.blue);
        g.drawRect(0, 0, this.icons[0].getIconWidth(), this.icons[0].getIconHeight());
        int posY = 0;
        if (this.icons != null) {
            int i = 0;
            while (i < this.icons.length) {
                if (this.icons[i] != null) {
                    this.icons[i].paintIcon(this, g, 0, posY);
                    g.drawRect(0, posY, this.icons[i].getIconWidth(), this.icons[i].getIconHeight());
                    posY += this.icons[i].getIconHeight() + 1;
                }
                ++i;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean notFirstPiece = false;
        DefaultMutableTreeNode node = SlicksEditor.suggestedPieceNode;
        TrackBlock tb = SlicksEditor.suggestedPiece;
        if (SlicksEditor.suggestedPiece != null && e.getY() > SlicksEditor.suggestedPiece.getWH().y) {
            notFirstPiece = true;
            int mousePos = e.getY() - SlicksEditor.suggestedPiece.getWH().y;
            Console.print("over by " + mousePos + ", suggestedpiece name " + SlicksEditor.suggestedPiece.filename);
            int piecestack = 0;
            int i = 1;
            while (i < 12) {
                node = node.getNextNode();
                if (mousePos < (piecestack += this.heightindex[i])) {
                    Console.print("on the " + i + "th piece, stack " + piecestack);
                    break;
                }
                ++i;
            }
        }
        if (tb != null) {
            if (notFirstPiece) {
                Console.print("notFirstPiece");
                tb = new TrackBlock((TrackBlock)node.getUserObject());
                tb.x = TrackPanel.width / 2 - tb.width / 2;
                tb.y = TrackPanel.height / 2 - tb.height / 2;
            }
            if (tb.type == TrackBlock.BLOCK_TYPE_BACKGROUND) {
                TrackBlock newpiece = new TrackBlock(tb);
                this.editor.lastCommand.add(newpiece, this.editor.track);
                Console.print("ADD BACKGROUND to trackModel");
                this.editor.trackModel.insertNodeInto(new DefaultMutableTreeNode(newpiece), this.editor.Background, 0);
                SlicksEditor.selectedPiece = newpiece;
            }
            if (tb.type == TrackBlock.BLOCK_TYPE_SOLID) {
                TrackBlock newpiece = new TrackBlock(tb);
                this.editor.lastCommand.add(newpiece, this.editor.track);
                Console.print("ADD SOLID to trackModel");
                this.editor.trackModel.insertNodeInto(new DefaultMutableTreeNode(newpiece), this.editor.Solids, 0);
                SlicksEditor.selectedPiece = newpiece;
            }
            if (tb.type == TrackBlock.BLOCK_TYPE_MARKER) {
                TrackMarker newpiece = new TrackMarker(tb);
                this.editor.lastCommand.add((TrackBlock)newpiece, this.editor.track);
                Console.print("ADD MARKER to trackModel");
                this.editor.trackModel.insertNodeInto(new DefaultMutableTreeNode(newpiece), this.editor.Markers, 0);
                SlicksEditor.selectedPiece = newpiece;
            }
            if (tb.type == TrackBlock.BLOCK_TYPE_INVISIBLE) {
                TrackMarker newpiece = new TrackMarker(tb);
                this.editor.lastCommand.add((TrackBlock)newpiece, this.editor.track);
                Console.print("ADD INVISIBLE to trackModel");
                this.editor.trackModel.insertNodeInto(new DefaultMutableTreeNode(newpiece), this.editor.Invisible, 0);
                SlicksEditor.selectedPiece = newpiece;
            }
            if (tb.type == TrackBlock.BLOCK_TYPE_TRACK) {
                TrackBlock newpiece = new TrackBlock(tb);
                Console.print("ADD TRACKPIECE to trackModel");
                this.editor.lastCommand.add(newpiece, this.editor.track);
                this.editor.trackModel.insertNodeInto(new DefaultMutableTreeNode(newpiece), this.editor.Blocks, 0);
                SlicksEditor.selectedPiece = newpiece;
            }
        }
        TrackPanel.controlPointCreating = false;
        this.editor.trackPanel.drawPanel();
        Console.print("PiecePanel RequestFocus");
        this.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = SlicksEditor.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + imgURL);
        return null;
    }
}

