/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.EditorGraphics;
import editor.SlicksEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.tree.DefaultMutableTreeNode;
import other.Console;
import slicks.client.KeyboardInput;
import slicks.model.Track;
import slicks.model.TrackBlock;
import slicks.model.TrackMarker;

public class TrackPanel
extends JPanel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
KeyListener,
FocusListener {
    public boolean firstTime = false;
    public static int width;
    public static int height;
    public SlicksEditor editor;
    public static int STATE_POINTER;
    public static int STATE_MOVING_PIECE;
    public static int STATE_EDIT_CONTROL_POINTS;
    public static boolean controlPointCreating;
    public Point controlPointStart = new Point(0, 0);
    public Point controlPointEnd = new Point(0, 0);
    public static int numControlPoints;
    public static int mouseState;
    public static int P_UP_10;
    public static int P_DOWN_10;
    public static int P_LEFT_10;
    public static int P_RIGHT_10;
    public static int P_UP_1;
    public static int P_DOWN_1;
    public static int P_LEFT_1;
    public static int P_RIGHT_1;
    public static int ROTATE_LEFT_45;
    public static int ROTATE_RIGHT_45;
    public static int ROTATE_LEFT_22p5;
    public static int ROTATE_RIGHT_22p5;
    public static int SHIFT;
    public static int DELETE;
    private EditorGraphics trackG;
    BufferedImage buffer;
    private Track track;
    JLabel label;
    public Point lastMousePos;
    public static Point checkBlockPos;
    public static Point dragPoint;
    JScrollBar hbar;
    JScrollBar vbar;
    public KeyboardInput kb;

    static {
        STATE_POINTER = 1;
        STATE_MOVING_PIECE = 2;
        STATE_EDIT_CONTROL_POINTS = 3;
        controlPointCreating = false;
        numControlPoints = 0;
        mouseState = 1;
        P_UP_10 = 87;
        P_DOWN_10 = 83;
        P_LEFT_10 = 65;
        P_RIGHT_10 = 68;
        P_UP_1 = 38;
        P_DOWN_1 = 40;
        P_LEFT_1 = 37;
        P_RIGHT_1 = 39;
        ROTATE_LEFT_45 = 81;
        ROTATE_RIGHT_45 = 69;
        ROTATE_LEFT_22p5 = 49;
        ROTATE_RIGHT_22p5 = 51;
        SHIFT = 16;
        DELETE = 127;
    }

    public TrackPanel() {
        super(true);
        this.setIgnoreRepaint(true);
        dragPoint = new Point(0, 0);
        this.lastMousePos = new Point(0, 0);
        checkBlockPos = new Point(0, 0);
        this.label = new JLabel();
        this.setLayout(new BorderLayout());
        this.hbar = new JScrollBar(0, 0, 0, 0, 0);
        this.vbar = new JScrollBar(1, 0, 0, 0, 0);
        this.hbar.addAdjustmentListener(this);
        this.vbar.addAdjustmentListener(this);
        this.hbar.setEnabled(true);
        this.vbar.setEnabled(true);
        this.add((Component)this.hbar, "South");
        this.add((Component)this.vbar, "East");
        this.add((Component)this.label, "Center");
        this.setFocusable(true);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.kb = new KeyboardInput(null);
        this.addKeyListener(this.kb);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.initializeBuffer(800, 600);
        Console.print("trackPanel created");
    }

    public void passEditor(SlicksEditor ed) {
        this.editor = ed;
    }

    public void initializeBuffer(int width, int height) {
        this.buffer = new BufferedImage(width + 1, height + 1, 1);
        TrackPanel.width = width;
        TrackPanel.height = height;
    }

    public void drawBuffer() {
        Graphics2D b = this.buffer.createGraphics();
        b.setColor(Color.gray);
        b.fillRect(0, 0, this.editor.track.width - 1, this.editor.track.height - 1);
        if (this.track == null) {
            Console.print("track is null");
        }
        this.drawTrack(b);
        if (mouseState == STATE_MOVING_PIECE && SlicksEditor.selectedPiece != null) {
            try {
                if (this.trackG != null) {
                    this.trackG.drawBlock(b, SlicksEditor.selectedPiece);
                }
            }
            catch (Exception e) {
                Console.print("ex: " + e);
            }
        }
        this.validate();
        b.dispose();
    }

    public void drawScreen() {
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.drawImage((Image)this.buffer, 0, 0, this);
        Toolkit.getDefaultToolkit().sync();
        g.dispose();
    }

    public void drawPanel() {
        this.drawBuffer();
        this.drawScreen();
    }

    public void assignTrackToPanel(Track track, EditorGraphics trackG) {
        if (this.firstTime) {
            this.firstTime = false;
        }
        this.track = track;
        this.trackG = trackG;
        this.initializeBuffer(track.width, track.height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.drawPanel();
        if (mouseState == STATE_EDIT_CONTROL_POINTS) {
            if (controlPointCreating) {
                g.setColor(Color.red);
                g.drawRect(this.controlPointStart.x - 1, this.controlPointStart.y - 1, 2, 2);
                if (Math.abs(this.lastMousePos.x - this.controlPointStart.x) > Math.abs(this.lastMousePos.y - this.controlPointStart.y)) {
                    g.drawLine(this.controlPointStart.x, this.controlPointStart.y, this.lastMousePos.x, this.controlPointStart.y);
                } else {
                    g.drawLine(this.controlPointStart.x, this.controlPointStart.y, this.controlPointStart.x, this.lastMousePos.y);
                }
            } else {
                g.setColor(Color.blue);
            }
            g.drawRect(this.lastMousePos.x - 1, this.lastMousePos.y - 1, 2, 2);
        }
    }

    public void blink(boolean show) {
        this.repaint();
    }

    public void drawTrack(Graphics g) {
        if (this.track != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setClip(0, 0, w - 17, h - 17);
            this.trackG.drawTrack(g, this.track);
        }
    }

    @Override
    public void validate() {
        if (this.trackG != null && this.track.height > 0) {
            Dimension d = this.getSize();
            Dimension d0 = new Dimension((int)((double)this.track.width * EditorGraphics.screenRatio[EditorGraphics.resolution]) + 1, (int)((double)this.track.height * EditorGraphics.screenRatio[EditorGraphics.resolution]) + 1);
            Dimension d1 = this.vbar.getSize();
            Dimension d2 = this.hbar.getSize();
            width = d.width;
            height = d.height;
            int w = Math.max(d.width - d1.width, 0);
            int h = Math.max(d.height - d2.height, 0);
            this.vbar.setBounds(w, 0, d1.width, h);
            this.hbar.setBounds(0, h, w, d2.height);
            int xs = Math.max(d0.width - w, 0);
            this.hbar.setMaximum(xs + xs / 5);
            this.hbar.setBlockIncrement(xs / 5);
            this.hbar.setEnabled(xs > 0);
            int ys = Math.max(d0.height - h, 0);
            this.vbar.setMaximum(ys + ys / 5);
            this.vbar.setBlockIncrement(ys / 5);
            this.vbar.setEnabled(ys > 0);
            this.hbar.setVisibleAmount(this.hbar.getBlockIncrement());
            this.vbar.setVisibleAmount(this.vbar.getBlockIncrement());
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent arg0) {
        Dimension d0 = this.getSize();
        int x = this.hbar.getValue();
        int y = this.vbar.getValue();
        EditorGraphics.keypointX = -x;
        EditorGraphics.keypointY = -y;
        this.validate();
        Graphics g = this.getGraphics();
        this.paintComponent(g);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Console.print("click " + e.getX() + "," + e.getY() + " state: " + mouseState);
        this.lastMousePos.x = e.getX();
        this.lastMousePos.y = e.getY();
        Console.print("TrackPanel RequestFocus");
        this.requestFocusInWindow();
        if (SlicksEditor.allowEdit) {
            if (mouseState == STATE_POINTER) {
                try {
                    if (this.trackG == null) {
                        Console.print("trakG is null");
                    }
                    if (this.trackG.getBlock(e.getX(), e.getY())) {
                        Console.print("chosen piece clicked");
                        this.drawPanel();
                    }
                }
                catch (Exception ex) {
                    Console.print("no blocks to tag " + ex);
                }
            }
            if (mouseState == STATE_MOVING_PIECE) {
                Console.print("moving clicked");
            }
            if (mouseState == STATE_EDIT_CONTROL_POINTS) {
                if (!controlPointCreating) {
                    this.controlPointStart.x = e.getX();
                    this.controlPointStart.y = e.getY();
                    controlPointCreating = true;
                } else if (controlPointCreating) {
                    controlPointCreating = false;
                    this.controlPointEnd.x = e.getX();
                    this.controlPointEnd.y = e.getY();
                    Console.print("create control marker now!");
                    if (Math.abs(this.lastMousePos.x - this.controlPointStart.x) > Math.abs(this.lastMousePos.y - this.controlPointStart.y)) {
                        Console.print("creating hor cp, start " + this.controlPointStart.x + "," + this.controlPointStart.y + " end " + this.controlPointEnd.x + "," + this.controlPointEnd.y);
                        Console.print("keyPt X: " + EditorGraphics.keypointX + ", y: " + EditorGraphics.keypointY);
                        TrackMarker cp = new TrackMarker();
                        cp.type = TrackBlock.BLOCK_TYPE_MARKER;
                        cp.markerType = 2;
                        if (this.controlPointStart.x > this.controlPointEnd.x) {
                            Console.print("start x > end x_");
                            cp.x = -EditorGraphics.keypointX + this.controlPointEnd.x;
                        } else {
                            cp.x = -EditorGraphics.keypointX + this.controlPointStart.x;
                        }
                        cp.y = -EditorGraphics.keypointY + this.controlPointStart.y;
                        this.controlPointEnd.x = -EditorGraphics.keypointX + e.getX();
                        this.controlPointEnd.y = -EditorGraphics.keypointY + this.controlPointStart.y;
                        cp.controlPointWidth = Math.abs(this.controlPointEnd.x - this.controlPointStart.x);
                        Console.print("create hor w: " + cp.controlPointWidth);
                        cp.name = "" + numControlPoints;
                        cp.filename = "" + numControlPoints;
                        this.editor.lastCommand.add((TrackBlock)cp, this.editor.track);
                        this.editor.trackModel.insertNodeInto(new DefaultMutableTreeNode(cp), this.editor.Markers, 0);
                        SlicksEditor.selectedPiece = cp;
                        ++numControlPoints;
                    } else {
                        Console.print("creating vert cp");
                        Console.print("keyPt X: " + EditorGraphics.keypointX + ", y: " + EditorGraphics.keypointY);
                        TrackMarker cp = new TrackMarker();
                        cp.type = TrackBlock.BLOCK_TYPE_MARKER;
                        cp.markerType = 3;
                        cp.x = -EditorGraphics.keypointX + this.controlPointStart.x;
                        cp.y = this.controlPointStart.y > this.controlPointEnd.y ? -EditorGraphics.keypointY + this.controlPointEnd.y : -EditorGraphics.keypointY + this.controlPointStart.y;
                        this.controlPointEnd.x = -EditorGraphics.keypointX + this.controlPointStart.x;
                        this.controlPointEnd.y = -EditorGraphics.keypointY + e.getY();
                        cp.controlPointHeight = Math.abs(this.controlPointEnd.y - this.controlPointStart.y);
                        Console.print("create vert w: " + cp.controlPointHeight);
                        cp.name = "" + numControlPoints;
                        cp.filename = "" + numControlPoints;
                        this.editor.lastCommand.add((TrackBlock)cp, this.editor.track);
                        this.editor.trackModel.insertNodeInto(new DefaultMutableTreeNode(cp), this.editor.Markers, 0);
                        SlicksEditor.selectedPiece = cp;
                        ++numControlPoints;
                    }
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Console.print("TrackPanel RequestFocus");
        this.requestFocusInWindow();
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (mouseState == STATE_MOVING_PIECE) {
            mouseState = STATE_POINTER;
        }
        this.drawPanel();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SlicksEditor.allowEdit) {
            if (mouseState == STATE_POINTER) {
                try {
                    Console.print("pointer");
                    if (this.trackG.getBlock(e.getX(), e.getY())) {
                        mouseState = STATE_MOVING_PIECE;
                        this.drawPanel();
                    }
                }
                catch (Exception ex) {
                    Console.print("no blocks to tag " + ex);
                }
            }
            if (mouseState == STATE_MOVING_PIECE) {
                try {
                    SlicksEditor.selectedPiece.x = e.getX() - TrackPanel.dragPoint.x - EditorGraphics.keypointX;
                    SlicksEditor.selectedPiece.y = e.getY() - TrackPanel.dragPoint.y - EditorGraphics.keypointY;
                    this.drawPanel();
                }
                catch (Exception ex) {
                    Console.print("no blocks to tag " + ex);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        if (SlicksEditor.allowEdit && mouseState == STATE_MOVING_PIECE && SlicksEditor.selectedPiece != null) {
            SlicksEditor.selectedPiece.x = arg0.getX();
            SlicksEditor.selectedPiece.y = arg0.getY();
            this.paintComponent(this.getGraphics());
        }
        if (mouseState == STATE_EDIT_CONTROL_POINTS) {
            this.lastMousePos.x = arg0.getX();
            this.lastMousePos.y = arg0.getY();
            this.paintComponent(this.getGraphics());
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        Console.print("focG");
        this.drawPanel();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        Console.print("focL");
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        Console.print("trkPan key: " + arg0.getKeyChar());
        if (SlicksEditor.selectedPiece != null) {
            if (this.kb.currentKeys[P_UP_10]) {
                SlicksEditor.selectedPiece.y -= 10;
            }
            if (this.kb.currentKeys[P_DOWN_10]) {
                SlicksEditor.selectedPiece.y += 10;
            }
            if (this.kb.currentKeys[P_LEFT_10]) {
                SlicksEditor.selectedPiece.x -= 10;
            }
            if (this.kb.currentKeys[P_RIGHT_10]) {
                SlicksEditor.selectedPiece.x += 10;
            }
            if (this.kb.currentKeys[P_UP_1]) {
                --SlicksEditor.selectedPiece.y;
            }
            if (this.kb.currentKeys[P_DOWN_1]) {
                ++SlicksEditor.selectedPiece.y;
            }
            if (this.kb.currentKeys[P_LEFT_1]) {
                --SlicksEditor.selectedPiece.x;
            }
            if (this.kb.currentKeys[P_RIGHT_1]) {
                ++SlicksEditor.selectedPiece.x;
            }
            if (this.kb.currentKeys[ROTATE_LEFT_45]) {
                Console.print("rotate piece left");
                SlicksEditor.selectedPiece.rotateLeft(45.0f);
            }
            if (this.kb.currentKeys[ROTATE_RIGHT_45]) {
                Console.print("rotate piece right");
                SlicksEditor.selectedPiece.rotateRight(45.0f);
            }
            if (this.kb.currentKeys[ROTATE_LEFT_22p5]) {
                Console.print("rotate piece left");
                SlicksEditor.selectedPiece.rotateLeft(22.5f);
            }
            if (this.kb.currentKeys[ROTATE_RIGHT_22p5]) {
                Console.print("rotate piece right");
                SlicksEditor.selectedPiece.rotateRight(22.5f);
            }
            if (this.kb.currentKeys[DELETE]) {
                DefaultMutableTreeNode node;
                int i;
                int blocks;
                Console.print("DELETE");
                if (SlicksEditor.selectedPiece.type == TrackBlock.BLOCK_TYPE_MARKER) {
                    Console.print("MARKER");
                    if (((TrackMarker)SlicksEditor.selectedPiece).markerType == 2 || ((TrackMarker)SlicksEditor.selectedPiece).markerType == 3) {
                        --numControlPoints;
                        Console.print("deleted a control point");
                    }
                    blocks = this.editor.Markers.getChildCount();
                    i = 0;
                    while (i < blocks) {
                        node = (DefaultMutableTreeNode)this.editor.Markers.getChildAt(i);
                        if (node.getUserObject() == SlicksEditor.selectedPiece) {
                            this.editor.Markers.remove(node);
                            this.editor.trackModel.nodeStructureChanged(this.editor.Markers);
                            break;
                        }
                        ++i;
                    }
                }
                if (SlicksEditor.selectedPiece.type == TrackBlock.BLOCK_TYPE_BACKGROUND) {
                    blocks = this.editor.Background.getChildCount();
                    i = 0;
                    while (i < blocks) {
                        node = (DefaultMutableTreeNode)this.editor.Background.getChildAt(i);
                        if (node.getUserObject() == SlicksEditor.selectedPiece) {
                            this.editor.Background.remove(node);
                            this.editor.trackModel.nodeStructureChanged(this.editor.Background);
                            break;
                        }
                        ++i;
                    }
                }
                if (SlicksEditor.selectedPiece.type == TrackBlock.BLOCK_TYPE_TRACK) {
                    blocks = this.editor.Blocks.getChildCount();
                    i = 0;
                    while (i < blocks) {
                        node = (DefaultMutableTreeNode)this.editor.Blocks.getChildAt(i);
                        if (node.getUserObject() == SlicksEditor.selectedPiece) {
                            this.editor.Blocks.remove(node);
                            this.editor.trackModel.nodeStructureChanged(this.editor.Blocks);
                            break;
                        }
                        ++i;
                    }
                }
                if (SlicksEditor.selectedPiece.type == TrackBlock.BLOCK_TYPE_SOLID) {
                    blocks = this.editor.Solids.getChildCount();
                    i = 0;
                    while (i < blocks) {
                        node = (DefaultMutableTreeNode)this.editor.Solids.getChildAt(i);
                        if (node.getUserObject() == SlicksEditor.selectedPiece) {
                            Console.print("removing solid??");
                            this.editor.Solids.remove(node);
                            this.editor.trackModel.nodeStructureChanged(this.editor.Solids);
                            break;
                        }
                        ++i;
                    }
                }
                if (SlicksEditor.selectedPiece.type == TrackBlock.BLOCK_TYPE_INVISIBLE) {
                    blocks = this.editor.Invisible.getChildCount();
                    i = 0;
                    while (i < blocks) {
                        node = (DefaultMutableTreeNode)this.editor.Invisible.getChildAt(i);
                        if (node.getUserObject() == SlicksEditor.selectedPiece) {
                            this.editor.Invisible.remove(node);
                            this.editor.trackModel.nodeStructureChanged(this.editor.Invisible);
                            break;
                        }
                        ++i;
                    }
                }
                this.editor.trackModel.nodeChanged(this.editor.trackTop);
                this.track.removePiece(SlicksEditor.selectedPiece);
                SlicksEditor.selectedPiece = null;
                this.trackG.assignTrack(this.track);
                this.assignTrackToPanel(this.track, this.trackG);
                this.validate();
            }
        }
        this.paintComponent(this.getGraphics());
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

