/*
 * Decompiled with CFR 0.152.
 */
package other;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;

public class ImageRotation
extends JPanel {
    private Image image;
    private double currentAngle;

    public ImageRotation(Image image) {
        this.image = image;
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForID(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rotate(float degree) {
        this.currentAngle += (double)degree;
        if (this.currentAngle >= 360.0) {
            this.currentAngle = 0.0;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform origXform = g2d.getTransform();
        AffineTransform newXform = (AffineTransform)origXform.clone();
        int xRot = this.image.getWidth(null) / 2;
        int yRot = this.image.getHeight(null) / 2;
        newXform.rotate(Math.toRadians(this.currentAngle), xRot, yRot);
        g2d.setTransform(newXform);
        int x = 0;
        int y = 0;
        g2d.drawImage(this.image, x, y, this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }
}

