/*
 * Decompiled with CFR 0.152.
 */
package other;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImageScaling {
    public static Image getScaledInstance(BufferedImage source, double factor, GraphicsConfiguration gc) {
        if (factor >= 1.0) {
            return ImageScaling.getScaledInstance2D(source, factor, RenderingHints.VALUE_INTERPOLATION_BICUBIC, gc);
        }
        return ImageScaling.getScaledInstanceAWT(source, factor, 16);
    }

    public static BufferedImage getScaledInstance2D(BufferedImage source, double factor, Object interpolationHint, GraphicsConfiguration gc) {
        if (gc == null) {
            gc = ImageScaling.getDefaultConfiguration();
        }
        int w = (int)((double)source.getWidth() * factor);
        int h = (int)((double)source.getHeight() * factor);
        int transparency = source.getColorModel().getTransparency();
        return ImageScaling.copy(source, gc.createCompatibleImage(w, h, transparency), interpolationHint);
    }

    public static GraphicsConfiguration getDefaultConfiguration() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.getDefaultConfiguration();
    }

    public static BufferedImage copy(BufferedImage source, BufferedImage target, Object interpolationHint) {
        Graphics2D g = target.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationHint);
        double scalex = (double)target.getWidth() / (double)source.getWidth();
        double scaley = (double)target.getHeight() / (double)source.getHeight();
        AffineTransform at = AffineTransform.getScaleInstance(scalex, scaley);
        g.drawRenderedImage(source, at);
        g.dispose();
        return target;
    }

    public static Image getScaledInstanceAWT(BufferedImage source, double factor, int hint) {
        int w = (int)((double)source.getWidth() * factor);
        int h = (int)((double)source.getHeight() * factor);
        return source.getScaledInstance(w, h, hint);
    }
}

