/*
 * Decompiled with CFR 0.152.
 */
package slicks.client;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.net.URL;
import java.util.Date;
import javax.swing.ImageIcon;
import other.Console;
import slicks.client.KeyboardInput;
import slicks.engine.Engine;
import slicks.engine.ImageLoader;
import slicks.sound.SoundMan;
import slicks.sound.SoundManNull;
import slicks.ui.Renderer;

public class SlicksApplet
extends Applet
implements MouseListener,
ImageLoader,
MouseMotionListener,
Runnable,
KeyListener {
    public static boolean windowed = true;
    public static int TICK_TIME = 20;
    public static int WIDTH = 1280;
    public static int HEIGHT = 720;
    public static boolean screenChanged = false;
    public static boolean hasKeyFocus = false;
    public static boolean running = true;
    private static SoundMan sm = null;
    FocusListener[] focii;
    public URL resourceURL;
    Image offscreen;
    Dimension dim;
    long previousTime;
    public MediaTracker mt;
    public Toolkit tk;
    Engine engine;
    BufferStrategy bufferStrategy;
    DisplayMode displayMode;
    Renderer renderer;
    KeyboardInput keyboard;
    Thread mainloop = null;

    @Override
    public void start() {
        this.previousTime = new Date().getTime();
        this.mainloop = new Thread(this);
        if (this.mainloop != null) {
            this.mainloop.start();
        }
    }

    public void setWidthandHeight(int w, int h) {
        WIDTH = w;
        HEIGHT = h;
    }

    public void setBufferStrategy(BufferStrategy strategy) {
        this.bufferStrategy = strategy;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }

    @Override
    public void run() {
        while (running) {
            long now = new Date().getTime();
            int ticks = (int)((now - this.previousTime) / (long)TICK_TIME);
            if (ticks > 0) {
                this.previousTime = now;
            }
            this.engine.update(ticks);
            this.renderer.update(ticks);
            Thread.currentThread();
            Thread.yield();
        }
        System.exit(0);
    }

    @Override
    public void init() {
        Console.print("making it to init()applet");
        Engine.state = 0;
        this.setName("Slicks2");
        Console.print("setting size " + WIDTH + "," + HEIGHT);
        this.setSize(WIDTH, HEIGHT);
        this.dim = this.getSize();
        try {
            System.out.println("OpenAL NOT inited");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("error initing OpenAL");
            sm = new SoundManNull();
        }
        if (sm != null) {
            sm.play();
        }
        this.keyboard = new KeyboardInput(sm);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this.keyboard);
        this.setBackground(Color.white);
        this.hideMouse();
        if (this.offscreen == null) {
            Console.print("OFFSCREEN is NULL");
        }
        Console.print("WIDTH: " + WIDTH + ", HEIGHT: " + HEIGHT);
        this.offscreen = this.createImage(WIDTH, HEIGHT);
        Console.print("creating offscreen");
        if (this.offscreen == null) {
            Console.print("OFFSCREEN is NULL");
        }
        this.tk = this.getToolkit();
        this.mt = new MediaTracker(this);
        try {
            URL url = SlicksApplet.class.getResource("/fonts/bluefont.png");
        }
        catch (Exception e) {
            Console.print("could not find font, " + e);
        }
        if (windowed) {
            WIDTH = this.getSize().width;
            HEIGHT = this.getSize().height;
            this.renderer = new Renderer(this, this.offscreen, this.getGraphics(), this.getSize(), this.tk, sm);
        } else {
            this.renderer = new Renderer(this, this.offscreen, this.bufferStrategy, this.displayMode, this.getSize(), this.tk, sm);
        }
        this.engine = new Engine(this.renderer, this.keyboard, sm);
        this.renderer.menu.activeButtons.clear();
        this.renderer.menu.activateLocalMenu();
        Engine.state = 2;
        Console.print("INIT ENGINE STATE: " + Engine.state);
    }

    public void slam() {
        Console.print("teardown");
        this.mt = null;
        this.renderer = null;
        this.engine = null;
        this.offscreen = null;
    }

    @Override
    public void update(Graphics g) {
        this.forceResize(g);
    }

    @Override
    public void paint(Graphics g) {
        Console.print("applet paint, call renderer.paint()");
        this.requestFocus();
        if (this.renderer != null) {
            Console.print("paint-> forceResizer call");
            this.forceResize(g);
        }
    }

    public void forceResize(Graphics g) {
        this.dim = this.getSize();
        WIDTH = this.dim.width;
        HEIGHT = this.dim.height;
        Console.print("forceResize, dim " + this.dim.width + " " + this.dim.height);
        this.offscreen = this.createImage(WIDTH, HEIGHT);
        this.renderer.repaint(g, this.offscreen, this.dim.width, this.dim.height);
    }

    public void hideMouse() {
        this.setCursor(this.getToolkit().createCustomCursor(new BufferedImage(3, 3, 2), new Point(0, 0), "null"));
    }

    public void showMouse() {
        this.setCursor(null);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.engine.mouseMoved(evt);
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        if (Engine.state != 3 && this.engine != null) {
            this.engine.mouseMoved(evt);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        this.engine.mouseClicked(evt);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.engine.mousePressed(e);
        hasKeyFocus = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.engine.mouseReleased(e);
    }

    @Override
    public Image getImage(String name) {
        URL url = this.getResourceURL(name);
        Toolkit tk = this.getToolkit();
        Image img = tk.getImage(url);
        if (img == null) {
            Console.print("img " + name + " is null");
        } else if (img.getWidth(null) <= 0) {
            this.mt.addImage(img, 1);
            try {
                this.mt.waitForAll();
            }
            catch (InterruptedException e) {
                System.out.println("getImage ex: " + e);
            }
        }
        return img;
    }

    @Override
    public BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = SlicksApplet.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public URL getResourceURL(String path) {
        URL url = null;
        try {
            url = SlicksApplet.class.getResource(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return url;
    }

    public Object getResource(String path) {
        URL ob = this.getClass().getResource(path);
        return ob;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Console.print("APPLET");
        if (e.getKeyCode() == 27) {
            if (Engine.state == 3) {
                Console.print("go to game menu from APPLET");
                Engine.state = 2;
            } else {
                Console.print("killgame from APPLET");
                running = false;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Console.print("APPLET");
    }

    @Override
    public void keyTyped(KeyEvent e) {
        Console.print("APPLET");
    }
}

