/*
 * Decompiled with CFR 0.152.
 */
package slicks.model;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import other.ImageRotation;

public class TrackBlock {
    private static final long serialVersionUID = 1L;
    public String name;
    public static int BLOCK_TYPE_BACKGROUND = 0;
    public static int BLOCK_TYPE_TRACK = 1;
    public static int BLOCK_TYPE_SOLID = 2;
    public static int BLOCK_TYPE_OBJECT = 3;
    public static int BLOCK_TYPE_MARKER = 4;
    public static int BLOCK_TYPE_CREATED = 6;
    public static int BLOCK_TYPE_UNDER_CARS = 7;
    public static int BLOCK_TYPE_SHADOW = 8;
    public static int BLOCK_TYPE_INVISIBLE = 9;
    public int type;
    public BufferedImage tempImg;
    public BufferedImage blockImg;
    public BufferedImage unRotatedImg;
    public BufferedImage collisionImg;
    public String filename;
    public String heightmapname;
    public String collisionname;
    public int x;
    public int y;
    public int localX;
    public int localY;
    public int width;
    public int height;
    public float rotationDegree = 0.0f;

    public TrackBlock(String name) {
        this.name = name;
    }

    public TrackBlock() {
    }

    public TrackBlock(TrackBlock selectedPiece) {
        this.name = new String(selectedPiece.name);
        this.type = new Integer(selectedPiece.type);
        this.x = new Integer(selectedPiece.x);
        this.y = new Integer(selectedPiece.y);
        this.localX = new Integer(selectedPiece.localX);
        this.localY = new Integer(selectedPiece.localY);
        this.width = new Integer(selectedPiece.width);
        this.height = new Integer(selectedPiece.height);
        this.blockImg = selectedPiece.blockImg;
        this.filename = new String(selectedPiece.filename);
        try {
            this.heightmapname = new String(selectedPiece.heightmapname);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.heightmapname = new String(selectedPiece.heightmapname);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setFilename(String file) {
        this.filename = file;
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setXY(Point pos) {
        this.x = pos.x;
        this.y = pos.y;
    }

    public void setWH(Point pos) {
        this.width = pos.x;
        this.height = pos.y;
    }

    public void setXYScaled(Point pos, double ratio) {
        if (ratio != 1.0) {
            Point scaledpoint = new Point(this.getScaledXY(ratio, pos));
            this.localX = scaledpoint.x;
            this.localY = scaledpoint.y;
        } else {
            this.localX = pos.x;
            this.localY = pos.y;
        }
    }

    public Point getXY() {
        Point p = new Point(this.x, this.y);
        return p;
    }

    public Point getLocalXY() {
        Point p = new Point(this.localX, this.localY);
        return p;
    }

    public Point getWH() {
        Point p = new Point(this.width, this.height);
        return p;
    }

    public Point getScaledXY(double ratio, Point original) {
        Point p = new Point(this.x, this.y);
        p.x = (int)((double)p.x * ratio);
        p.y = (int)((double)p.y * ratio);
        return p;
    }

    public void rotateLeft(float degree) {
        this.rotationDegree -= degree;
        if (this.rotationDegree < 0.0f) {
            this.rotationDegree += 360.0f;
        }
        this.rotateOriginalImage(this.rotationDegree);
    }

    public void rotateRight(float degree) {
        this.rotationDegree += degree;
        if (this.rotationDegree > 360.0f) {
            this.rotationDegree -= 360.0f;
        }
        this.rotateOriginalImage(this.rotationDegree);
    }

    public void rotateOriginalImage(float degree) {
        BufferedImage image = null;
        int originalW = 0;
        int originalH = 0;
        int rotationW = 0;
        int rotationH = 0;
        if (this.unRotatedImg == null) {
            originalW = this.blockImg.getWidth();
            if (originalW != (originalH = this.blockImg.getHeight())) {
                if (originalW > originalH) {
                    rotationH = rotationW = originalW;
                } else {
                    rotationW = rotationH = originalH;
                }
            } else {
                rotationW = rotationH = originalH;
            }
            rotationH = (int)((double)rotationH * 1.5);
            rotationW = (int)((double)rotationW * 1.5);
            int x = rotationW / 2 - originalW / 2;
            int y = rotationH / 2 - originalH / 2;
            this.unRotatedImg = new BufferedImage(rotationW, rotationH, 2);
            this.unRotatedImg.getGraphics().drawImage(this.blockImg, x, y, null);
        } else {
            rotationW = this.unRotatedImg.getWidth();
            rotationH = this.unRotatedImg.getHeight();
            originalW = this.unRotatedImg.getWidth();
            originalH = this.unRotatedImg.getHeight();
        }
        ImageRotation ir = new ImageRotation(this.unRotatedImg);
        image = new BufferedImage(rotationW, rotationH, 2);
        ir.rotate(degree);
        ir.paintComponent(image.getGraphics());
        this.blockImg = this.cropImage(image);
        this.width = this.blockImg.getWidth(null);
        this.height = this.blockImg.getHeight(null);
    }

    public BufferedImage cropImage(BufferedImage img) {
        int j;
        int top = 0;
        int bottom = img.getHeight();
        int left = 0;
        int right = img.getWidth();
        boolean foundfirst = false;
        int lastX = 0;
        int lastY = 0;
        int i = 0;
        while (i < img.getHeight() - 1) {
            j = 0;
            while (j < img.getWidth() - 1) {
                if (img.getRGB(j, i) != 0) {
                    if (!foundfirst) {
                        top = i;
                        foundfirst = true;
                    }
                    lastY = i;
                }
                ++j;
            }
            ++i;
        }
        bottom = lastY;
        foundfirst = false;
        i = 0;
        while (i < img.getWidth() - 1) {
            j = 0;
            while (j < img.getHeight() - 1) {
                if (img.getRGB(i, j) != 0) {
                    if (!foundfirst) {
                        left = i;
                        foundfirst = true;
                    }
                    lastX = i;
                }
                ++j;
            }
            ++i;
        }
        right = lastX;
        int width = right - left + 1;
        int height = bottom - top + 1;
        BufferedImage cropped = new BufferedImage(width, height, 2);
        cropped.getGraphics().drawImage(img, -left, -top, null);
        return cropped;
    }

    public Point getImageWH() {
        Point p = new Point(this.blockImg.getWidth(), this.blockImg.getHeight());
        return p;
    }

    public void drawOutline(Graphics g, Color color, double ratio, int offsetX, int offsetY) {
        g.setColor(color);
        if (ratio != 1.0) {
            Point xy = this.getScaledXY(ratio, this.getXY());
            Point wh = this.getWH();
            g.drawRect(offsetX + xy.x, offsetY + xy.y, wh.x, wh.y);
        } else {
            g.drawRect(offsetX + this.x, offsetY + this.y, this.width, this.height);
        }
    }
}

