/*
 * Decompiled with CFR 0.152.
 */
package slicks.model;

import java.awt.Point;

public class Vector2 {
    private double x;
    private double y;
    private double magnitude;
    private Vector2 unit;

    public Vector2(boolean isUnit, double x, double y) {
        this.x = x;
        this.y = y;
        this.magnitude = Math.sqrt(x * x + y * y);
        this.unit = isUnit ? this : (this.magnitude == 0.0 ? new Vector2(true, 0.0, 0.0) : new Vector2(true, x / this.magnitude, y / this.magnitude));
    }

    public Vector2(double x, double y) {
        this(false, x, y);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public Vector2 getUnitVector2() {
        return this.unit;
    }

    public Vector2 scalarMult(double scalar) {
        return new Vector2(this.x * scalar, this.y * scalar);
    }

    public Vector2 add(Vector2 vec) {
        return new Vector2(this.x + vec.getX(), this.y + vec.getY());
    }

    public Vector2 add(Vector2[] vec) {
        double y2 = 0.0;
        double x2 = 0.0;
        int i = 0;
        while (i < vec.length) {
            x2 += vec[i].getX();
            y2 += vec[i].getY();
            ++i;
        }
        return new Vector2(this.x + x2, this.y + y2);
    }

    public double dot(Vector2 vec) {
        return this.x * vec.getX() + this.y * vec.getY();
    }

    public Vector2 minus(Vector2 vec) {
        return new Vector2(this.x - vec.getX(), this.y - vec.getY());
    }

    public String toString() {
        return "<" + this.x + ", " + this.y + ">";
    }

    public Vector2 getVectorFromTwoPoints(Point p1, Point p2) {
        Vector2 vec = new Vector2(p2.x - p1.x, p2.y - p1.y);
        return vec;
    }
}

