/*
 * Decompiled with CFR 0.152.
 */
package slicks.model;

public class Vector3 {
    private double x;
    private double y;
    private double z;
    private double magnitude;
    private Vector3 unit;

    public Vector3(boolean isUnit, double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.magnitude = Math.sqrt(x * x + y * y + z * z);
        this.unit = isUnit ? this : (this.magnitude == 0.0 ? new Vector3(true, 0.0, 0.0, 0.0) : new Vector3(true, x / this.magnitude, y / this.magnitude, z / this.magnitude));
    }

    public Vector3(double x, double y, double z) {
        this(false, x, y, z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public Vector3 getUnitVector3() {
        return this.unit;
    }

    public Vector3 scalarMult(double scalar) {
        return new Vector3(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Vector3 add(Vector3 vec) {
        return new Vector3(this.x + vec.getX(), this.y + vec.getY(), this.z + vec.getZ());
    }

    public Vector3 add(Vector3[] vec) {
        double z2 = 0.0;
        double y2 = 0.0;
        double x2 = 0.0;
        int i = 0;
        while (i < vec.length) {
            x2 += vec[i].getX();
            y2 += vec[i].getY();
            z2 += vec[i].getZ();
            ++i;
        }
        return new Vector3(this.x + x2, this.y + y2, this.z + z2);
    }

    public double dot(Vector3 vec) {
        return this.x * vec.getX() + this.y * vec.getY() + this.z * vec.getZ();
    }

    public Vector3 cross(Vector3 vec) {
        double xi = this.y * vec.getZ() - this.z * vec.getY();
        double yi = this.z * vec.getX() - this.x * vec.getZ();
        double zi = this.x * vec.getY() - this.y * vec.getX();
        return new Vector3(xi, yi, zi);
    }

    public Vector3 minus(Vector3 vec) {
        return new Vector3(this.x - vec.getX(), this.y - vec.getY(), this.z - vec.getZ());
    }

    public String toString() {
        return "<" + this.x + ", " + this.y + ", " + this.z + ">";
    }
}

