/*
 * Decompiled with CFR 0.152.
 */
package slicks.sound;

import de.jarnbjo.ogg.CachedUrlStream;
import de.jarnbjo.ogg.EndOfOggStreamException;
import de.jarnbjo.ogg.LogicalOggStream;
import de.jarnbjo.vorbis.IdentificationHeader;
import de.jarnbjo.vorbis.VorbisStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class OggDecoder {
    private static int BLOCK_SIZE = 262144;
    private VorbisStream vStream;
    private LogicalOggStream loStream;
    private AudioInputStream ais;
    private IdentificationHeader vStreamHdr;
    private AudioFormat audioFormat;
    private URL url;
    private boolean swap = false;
    private boolean endOfStream = false;

    public OggDecoder(URL url) {
        this.url = url;
    }

    public boolean initialize() {
        try {
            CachedUrlStream os = new CachedUrlStream(this.url);
            this.loStream = (LogicalOggStream)os.getLogicalStreams().iterator().next();
            this.vStream = new VorbisStream(this.loStream);
            this.vStreamHdr = this.vStream.getIdentificationHeader();
            this.audioFormat = new AudioFormat(this.vStreamHdr.getSampleRate(), 16, this.vStreamHdr.getChannels(), true, true);
            this.ais = new AudioInputStream(new VorbisInputStream(this.vStream), this.audioFormat, -1L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int numChannels() {
        return this.vStreamHdr.getChannels();
    }

    public void resetPosition() {
        try {
            this.loStream.reset();
            this.vStream = new VorbisStream(this.loStream);
            this.ais = new AudioInputStream(new VorbisInputStream(this.vStream), this.audioFormat, -1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.endOfStream = false;
    }

    public int sampleRate() {
        return this.vStreamHdr.getSampleRate();
    }

    public void setSwap(boolean swap) {
        this.swap = swap;
    }

    public static void swapBytes(byte[] b) {
        OggDecoder.swapBytes(b, 0, b.length);
    }

    public static void swapBytes(byte[] b, int off, int len) {
        int i = off;
        while (i < off + len) {
            byte tempByte = b[i];
            b[i] = b[i + 1];
            b[i + 1] = tempByte;
            i += 2;
        }
    }

    public void play() {
        if (!this.initialize()) {
            return;
        }
        this.dump();
        try {
            int bytesRead;
            DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
            sourceDataLine.open(this.audioFormat);
            sourceDataLine.start();
            byte[] buffer = new byte[BLOCK_SIZE];
            do {
                if ((bytesRead = this.read(buffer)) <= 0) continue;
                sourceDataLine.write(buffer, 0, bytesRead);
            } while (bytesRead >= buffer.length);
            sourceDataLine.drain();
            sourceDataLine.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toraw(String fileName) {
        if (!this.initialize()) {
            return;
        }
        this.setSwap(true);
        this.dump();
        try {
            int bytesRead;
            byte[] buffer = new byte[BLOCK_SIZE];
            FileOutputStream fos = new FileOutputStream(fileName);
            do {
                if ((bytesRead = this.read(buffer)) <= 0) continue;
                fos.write(buffer, 0, bytesRead);
            } while (bytesRead >= buffer.length);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int read(byte[] buffer) throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        int bytesRead = 0;
        int cnt = 0;
        while (bytesRead < buffer.length) {
            cnt = this.ais.read(buffer, bytesRead, buffer.length - bytesRead);
            if (cnt <= 0) {
                this.endOfStream = true;
                break;
            }
            bytesRead += cnt;
        }
        if (this.swap) {
            OggDecoder.swapBytes(buffer, 0, bytesRead);
        }
        return bytesRead;
    }

    public void dump() {
        System.err.println("#Channels: " + this.vStreamHdr.getChannels());
        System.err.println("Sample rate: " + this.vStreamHdr.getSampleRate());
        System.err.println("Bitrate: nominal=" + this.vStreamHdr.getNominalBitrate() + ", max=" + this.vStreamHdr.getMaximumBitrate() + ", min=" + this.vStreamHdr.getMinimumBitrate());
    }

    public static class VorbisInputStream
    extends InputStream {
        private VorbisStream source;

        public VorbisInputStream(VorbisStream source) {
            this.source = source;
        }

        @Override
        public int read() throws IOException {
            return 0;
        }

        @Override
        public int read(byte[] buffer) throws IOException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            try {
                return this.source.readPcm(buffer, offset, length);
            }
            catch (EndOfOggStreamException e) {
                return -1;
            }
        }
    }
}

