/*
 * Decompiled with CFR 0.152.
 */
package slicks.sound;

import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Vector;
import net.java.games.joal.AL;
import net.java.games.joal.ALException;
import slicks.sound.OggDecoder;

public class OggStreamer
extends Thread {
    public static final int PLAY = 1;
    public static final int PAUSE = 2;
    public static final int NEXT = 3;
    public static final int PREVIOUS = 4;
    public static final int STOP = 0;
    public static final int EXIT = 5;
    private static AL al = null;
    private static boolean debug = false;
    private static int totalBytes = 0;
    private int playListLength = 0;
    private static Vector<OggDecoder> loadedTracks = new Vector();
    private static int BUFFER_SIZE = 65536;
    private static int NUM_BUFFERS = 2;
    private int[] buffers = new int[NUM_BUFFERS];
    private int[] source = new int[1];
    private int format;
    private int rate;
    private int playerState = 1;
    private float[] sourcePos = new float[]{0.0f, 0.0f, 0.0f};
    private float[] sourceVel = new float[]{0.0f, 0.0f, 0.0f};
    private float[] sourceDir = new float[]{0.0f, 0.0f, 0.0f};
    private static final String[] TRACK_NAMES = new String[]{"audio/tracks/auto demo mixxx1.ogg", "audio/tracks/broken_glass.ogg"};
    private URL url;
    private long sleepTime = 0L;
    private int index;

    public OggStreamer(AL al2) {
        al = al2;
        al.alGenBuffers(NUM_BUFFERS, this.buffers, 0);
        this.check();
        al.alGenSources(1, this.source, 0);
        this.check();
        al.alSourcefv(this.source[0], 4100, this.sourcePos, 0);
        al.alSourcefv(this.source[0], 4102, this.sourceVel, 0);
        al.alSourcefv(this.source[0], 4101, this.sourceDir, 0);
        al.alSourcef(this.source[0], 4106, 1.0f);
        al.alSourcef(this.source[0], 4129, 0.0f);
        al.alSourcei(this.source[0], 514, 1);
        this.loadTrack("audio/tracks/broken_glass.ogg");
        this.loadTrack("audio/tracks/auto demo mixxx1.ogg");
    }

    public boolean openUrl(String path) {
        this.url = OggStreamer.class.getClassLoader().getResource(path);
        loadedTracks.add(this.index, new OggDecoder(this.url));
        if (!loadedTracks.get(this.index).initialize()) {
            System.err.println("Error initializing ogg stream...");
            return false;
        }
        ++this.playListLength;
        ++this.index;
        return true;
    }

    public boolean openForPlaying() {
        int numChannels = loadedTracks.get(this.index).numChannels();
        int numBytesPerSample = 2;
        this.format = numChannels == 1 ? 4353 : 4355;
        this.rate = loadedTracks.get(this.index).sampleRate();
        this.sleepTime = (long)(1000.0 * (double)BUFFER_SIZE / (double)numBytesPerSample / (double)numChannels / (double)this.rate / 10.0);
        this.sleepTime = (this.sleepTime + 10L) / 10L * 10L;
        System.err.println("#Track: " + this.index);
        System.err.println("#Buffers: " + NUM_BUFFERS);
        System.err.println("Buffer size: " + BUFFER_SIZE);
        System.err.println("Format: 0x" + Integer.toString(this.format, 16));
        System.err.println("Sleep time: " + this.sleepTime);
        loadedTracks.get(this.index).setSwap(true);
        return true;
    }

    public void release() {
        al.alSourceStop(this.source[0]);
        this.empty();
        int i = 0;
        while (i < NUM_BUFFERS) {
            al.alDeleteSources(i, this.source, 0);
            this.check();
            ++i;
        }
    }

    public boolean playback() {
        if (this.playing()) {
            return true;
        }
        OggStreamer.debugMsg("playback(): stream all buffers");
        int i = 0;
        while (i < NUM_BUFFERS) {
            if (!this.stream(this.buffers[i])) {
                System.out.println("stream fail");
                return false;
            }
            ++i;
        }
        OggStreamer.debugMsg("playback(): queue all buffers & play source");
        al.alSourceQueueBuffers(this.source[0], NUM_BUFFERS, this.buffers, 0);
        al.alSourcePlay(this.source[0]);
        return true;
    }

    public boolean playing() {
        int[] state = new int[1];
        al.alGetSourcei(this.source[0], 4112, state, 0);
        return state[0] == 4114;
    }

    public boolean update() {
        int[] processed = new int[1];
        boolean active = true;
        OggStreamer.debugMsg("update()");
        al.alGetSourcei(this.source[0], 4118, processed, 0);
        while (processed[0] > 0) {
            int[] buffer = new int[1];
            al.alSourceUnqueueBuffers(this.source[0], 1, buffer, 0);
            this.check();
            OggStreamer.debugMsg("update(): buffer unqueued => " + buffer[0]);
            active = this.stream(buffer[0]);
            OggStreamer.debugMsg("update(): buffer queued => " + buffer[0]);
            al.alSourceQueueBuffers(this.source[0], 1, buffer, 0);
            this.check();
            processed[0] = processed[0] - 1;
        }
        return active;
    }

    public boolean stream(int buffer) {
        byte[] pcm = new byte[BUFFER_SIZE];
        int size = 0;
        try {
            size = loadedTracks.get(this.index).read(pcm);
            if (size <= 0) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        OggStreamer.debugMsg("stream(): buffer data => " + buffer + " totalBytes:" + (totalBytes += size));
        ByteBuffer data = ByteBuffer.wrap(pcm, 0, size);
        al.alBufferData(buffer, this.format, data, size, this.rate);
        this.check();
        return true;
    }

    protected void empty() {
        int[] queued = new int[1];
        al.alGetSourcei(this.source[0], 4117, queued, 0);
        while (queued[0] > 0) {
            int[] buffer = new int[1];
            al.alSourceUnqueueBuffers(this.source[0], 1, buffer, 0);
            this.check();
            queued[0] = queued[0] - 1;
        }
    }

    protected void check() {
        int result = al.alGetError();
        if (result != 0) {
            throw new ALException("OpenAL error raised :" + OggStreamer.getALErrorString(result));
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean playstream() {
        if (!this.openForPlaying()) {
            return false;
        }
        OggStreamer.loadedTracks.get(this.index).dump();
        if (this.playback()) ** GOTO lbl24
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while (this.getPlayerState() == 2) {
                if (this.playing()) {
                    OggStreamer.al.alSourcePause(this.source[0]);
                }
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.playing()) {
                OggStreamer.al.alSourcePlay(this.source[0]);
            }
            if (this.playing() || this.playback()) continue;
            return false;
lbl24:
            // 2 sources

            ** while (this.update() && this.getPlayerState() == 1)
        }
lbl25:
        // 1 sources

        return true;
    }

    @Override
    public void run() {
        do {
            if (this.getPlayerState() == 1) {
                System.out.println("playstream");
                this.playstream();
                System.out.println("exitStream");
                loadedTracks.get(this.index).resetPosition();
                al.alSourceStop(this.source[0]);
                this.empty();
                this.setPlayerState(3);
            }
            if (this.getPlayerState() == 3) {
                this.index = this.index <= this.playListLength - 2 ? ++this.index : 0;
                this.setPlayerState(1);
            }
            if (this.getPlayerState() == 4) {
                this.index = this.index >= 1 ? --this.index : this.playListLength;
                this.setPlayerState(1);
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (this.getPlayerState() != 5);
        this.release();
    }

    public synchronized void setPlayerState(int state) {
        this.playerState = state;
        System.out.println("state setted to " + this.playerState);
    }

    public synchronized int getPlayerState() {
        return this.playerState;
    }

    private static void debugMsg(String str) {
        if (debug) {
            System.err.println(str);
        }
    }

    public void loadTrack(String trackName) {
        this.openUrl(trackName);
    }

    public void prevTrack() {
        this.setPlayerState(4);
    }

    public void nextTrack() {
        this.setPlayerState(3);
    }

    public void play() {
        this.setPlayerState(1);
    }

    public void pause() {
        this.setPlayerState(2);
    }

    public void stopPaying() {
        this.setPlayerState(0);
    }

    public void setTrack(int trackNumber) {
        this.index = trackNumber;
    }

    public void exit() {
        this.setPlayerState(5);
    }

    public synchronized void setGain(int vol, boolean muted) {
        float gain = 0.01f * (float)vol;
        if (muted) {
            gain = 0.0f;
        }
        al.alSourcef(this.source[0], 4106, gain);
    }

    public static String getALErrorString(int err) {
        switch (err) {
            case 0: {
                return "AL_NO_ERROR";
            }
            case 40961: {
                return "AL_INVALID_NAME";
            }
            case 40962: {
                return "AL_INVALID_ENUM";
            }
            case 40963: {
                return "AL_INVALID_VALUE";
            }
            case 40964: {
                return "AL_INVALID_OPERATION";
            }
            case 40965: {
                return "AL_OUT_OF_MEMORY";
            }
        }
        return null;
    }
}

