/*
 * Decompiled with CFR 0.152.
 */
package slicks.sound;

import net.java.games.joal.AL;
import slicks.sound.SoundManager;

public class SoundClip {
    private AL al;
    private int sourceID;
    private int volume = 10;
    private String fileName = null;
    private SoundManager sm;
    private static final float[] START_POS = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] START_VEL = new float[]{0.0f, 0.0f, 0.0f};

    public SoundClip(SoundManager sm, AL al, int sourceID, int buffer, float pitch, int soundVolume, boolean loop) {
        this.al = al;
        this.sourceID = sourceID;
        this.fileName = this.fileName;
        this.sm = sm;
        al.alSourcei(sourceID, 4105, buffer);
        this.volume = this.volume;
        this.setGain();
        this.setPitch(pitch);
        al.alSourcefv(this.sourceID, 4100, START_POS, 0);
        al.alSourcefv(this.sourceID, 4102, START_VEL, 0);
        this.setLooping(loop);
    }

    public SoundClip(int sourceID, String fileName) {
        this.sourceID = sourceID;
        this.fileName = fileName;
    }

    public void play() {
        this.al.alSourcePlay(this.sourceID);
    }

    public void pause() {
        this.al.alSourcePause(this.sourceID);
    }

    public void stop() {
        this.al.alSourceStop(this.sourceID);
    }

    public boolean isPlaying() {
        int[] temp = new int[1];
        this.al.alGetSourcei(this.sourceID, 4112, temp, 0);
        return 4114 == temp[0];
    }

    public float getGain() {
        float[] temp = new float[1];
        this.al.alGetSourcef(this.sourceID, 4106, temp, 0);
        return temp[0];
    }

    public void setGain() {
        float gain = 0.001f * (float)this.sm.getEffectsVolume() * (float)this.volume;
        this.al.alSourcef(this.sourceID, 4106, gain);
    }

    public float getPitch() {
        float[] temp = new float[1];
        this.al.alGetSourcef(this.sourceID, 4099, temp, 0);
        return temp[0];
    }

    public void setPitch(float pitch) {
        this.al.alSourcef(this.sourceID, 4099, pitch);
    }

    public float[] getPosition() {
        float[] result = new float[3];
        this.al.alGetSourcefv(this.sourceID, 4100, result, 0);
        return result;
    }

    public void setPosition(float x, float y, float z) {
        this.al.alSource3f(this.sourceID, 4100, x, y, z);
    }

    public void setSourceVel(float x, float y, float z) {
        this.al.alSource3f(this.sourceID, 4102, x, y, z);
    }

    public void getSourceVel() {
    }

    public void setLooping(boolean loop) {
        if (loop) {
            this.al.alSourcei(this.sourceID, 4103, 1);
        } else {
            this.al.alSourcei(this.sourceID, 4103, 0);
        }
    }

    public boolean getLooping() {
        return this.al.alGetBoolean(this.sourceID);
    }

    public void updatePosition() {
        float[] sourcePos = new float[3];
        this.al.alGetSourcefv(this.sourceID, 4100, sourcePos, 0);
        float[] sourceVel = new float[3];
        this.al.alGetSourcefv(this.sourceID, 4102, sourceVel, 0);
        sourcePos[0] = sourcePos[0] + sourceVel[0];
        sourcePos[1] = sourcePos[1] + sourceVel[1];
        sourcePos[2] = sourcePos[2] + sourceVel[2];
        this.al.alSourcefv(this.sourceID, 4100, sourcePos, 0);
    }

    public int getClipsVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }
}

