/*
 * Decompiled with CFR 0.152.
 */
package slicks.ui;

import java.awt.DisplayMode;
import javax.swing.table.DefaultTableModel;
import slicks.ui.DisplayModeTest;

class DisplayModeModel
extends DefaultTableModel {
    private DisplayMode[] modes;

    public DisplayModeModel(DisplayMode[] modes) {
        this.modes = modes;
    }

    public DisplayMode getDisplayMode(int r) {
        return this.modes[r];
    }

    @Override
    public String getColumnName(int c) {
        return DisplayModeTest.COLUMN_NAMES[c];
    }

    @Override
    public int getColumnCount() {
        return DisplayModeTest.COLUMN_WIDTHS.length;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        return false;
    }

    @Override
    public int getRowCount() {
        if (this.modes == null) {
            return 0;
        }
        return this.modes.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        DisplayMode dm = this.modes[rowIndex];
        switch (colIndex) {
            case 0: {
                return Integer.toString(dm.getWidth());
            }
            case 1: {
                return Integer.toString(dm.getHeight());
            }
            case 2: {
                int bitDepth = dm.getBitDepth();
                String ret = bitDepth == -1 ? "Multi" : Integer.toString(bitDepth);
                return ret;
            }
            case 3: {
                int refreshRate = dm.getRefreshRate();
                String ret = refreshRate == 0 ? "Unknown" : Integer.toString(refreshRate);
                return ret;
            }
        }
        throw new ArrayIndexOutOfBoundsException("Invalid column value");
    }
}

