/*
 * Decompiled with CFR 0.152.
 */
package slicks.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import other.ImageRotation;
import slicks.client.SlicksApplet;
import slicks.engine.ImageLoader;
import slicks.model.Vector2;
import slicks.ui.CarGraphics;
import slicks.ui.Renderer;

public class MenuMouse {
    public static final int MAX_DIRECTION = 256;
    public CarGraphics mouseCar;
    public static int MOUSE_TRAIL_LENGTH = 50;
    public Point mousePos = new Point();
    Point[] trail;
    public int listPos;
    public int direction;
    public Vector2 momentum = new Vector2(0.0, 0.0);
    public int mousewidth;
    public int mouseheight;
    public Image[] newMouse;
    public int halfwidth;
    public Image car1frame;
    public Image[] car360frame;
    public ImageRotation spinner;
    public int carcentering;

    public MenuMouse(ImageLoader il) {
        this.mouseCar = new CarGraphics(il);
        this.loadMouseCar(il, null);
        this.trail = new Point[MOUSE_TRAIL_LENGTH];
        this.listPos = 0;
        int i = 0;
        while (i < MOUSE_TRAIL_LENGTH) {
            this.trail[i] = new Point(0, 0);
            ++i;
        }
    }

    public void loadMouseCar(ImageLoader loader, Graphics g) {
        this.car1frame = loader.getImage("/" + Renderer.resStr[Renderer.resolution] + "/cars/car_29x29_red.png");
    }

    public void mouseMoved(MouseEvent evt) {
        int curX = evt.getX();
        int curY = evt.getY();
        this.setMouseTrailPoint(new Point(curX, curY));
        this.setMouseCarRotation();
    }

    public void setMouseTrailPoint(Point pt) {
        this.listPos = this.listPos == MOUSE_TRAIL_LENGTH - 1 ? 0 : ++this.listPos;
        this.trail[this.listPos] = pt;
        this.mousePos = pt;
    }

    public Vector2 getMouseVector2() {
        int oldpos = this.listPos - 1;
        if (oldpos < 0) {
            oldpos += MOUSE_TRAIL_LENGTH;
        }
        int newpos = this.listPos;
        Vector2 dv = new Vector2(0.0, 0.0);
        Vector2 iVec = dv.getVectorFromTwoPoints(this.trail[oldpos], this.trail[newpos]);
        return iVec;
    }

    public void setMouseCarRotation() {
        int oldpos = this.listPos - 3;
        if (oldpos < 0) {
            oldpos += MOUSE_TRAIL_LENGTH;
        }
        int newpos = this.listPos;
        Vector2 dv = new Vector2(0.0, 0.0);
        Vector2 vec = dv.getVectorFromTwoPoints(this.trail[oldpos], this.trail[newpos]);
        double rotD = Math.atan2(vec.getY(), vec.getX());
        this.direction = MenuMouse.getRotationValueForCar(rotD);
        this.momentum = new Vector2(vec.getX(), vec.getY());
    }

    public void drawMouseTrailPoints(Graphics2D g2d) {
        float fadeOut = 1.0f / (float)MOUSE_TRAIL_LENGTH;
        Color c = null;
        int i = 0;
        while (i < MOUSE_TRAIL_LENGTH) {
            if (i == this.listPos) {
                c = new Color(1.0f, 0.0f, 0.0f, 1.0f);
            } else if (i < this.listPos) {
                c = new Color(1.0f, 0.0f, 0.0f, 1.0f - fadeOut * (float)(this.listPos - i));
            } else if (i > this.listPos) {
                c = new Color(1.0f, 0.0f, 0.0f, 0.0f + (float)(i - this.listPos) * fadeOut);
            }
            g2d.setPaint(c);
            g2d.fillRect(this.trail[i].x, this.trail[i].y, 2, 2);
            ++i;
        }
    }

    public static int getRotationValueForCar(double rawrotation) {
        int direction = 0;
        double fullCircle = Math.PI * 2;
        double wedge = fullCircle / 360.0;
        direction = (int)(rawrotation / wedge);
        if (direction < 0) {
            direction += 360;
        }
        if (direction > 359) {
            direction = 360 - direction;
        }
        return direction;
    }

    public void createMouseImages(Graphics g) {
        this.spinner = new ImageRotation(this.car1frame);
        this.car360frame = CarGraphics.createRotatedCarImages(g, this.spinner);
        this.carcentering = this.car360frame[0].getWidth(null) / 2;
    }

    public void drawMouse(Graphics g, int x, int y) {
        g.setClip(0, 0, SlicksApplet.WIDTH, SlicksApplet.HEIGHT);
        if (this.car360frame == null) {
            this.createMouseImages(g);
        }
        g.drawImage(this.car360frame[this.direction], x - this.carcentering, y - this.carcentering, null);
    }
}

