/*
 * Decompiled with CFR 0.152.
 */
package slicks.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferStrategy;
import java.awt.image.ImageObserver;
import java.net.URL;
import other.AverageTimeForTask;
import other.Console;
import other.FPS;
import other.SimpleFont;
import slicks.engine.Engine;
import slicks.engine.ImageLoader;
import slicks.model.Model;
import slicks.model.Track;
import slicks.model.Vector2;
import slicks.sound.SoundMan;
import slicks.ui.Camera;
import slicks.ui.CarGraphics;
import slicks.ui.Menu;
import slicks.ui.MenuMouse;
import slicks.ui.RaceUI;
import slicks.ui.StartLamps;
import slicks.ui.TimeGraphics;
import slicks.ui.TrackGraphics;

public class Renderer
implements ImageObserver {
    public static int resolution = 1;
    public static boolean showDebug = true;
    public static int RES_800x600 = 0;
    public static int RES_1280x720 = 1;
    public static int RES_1920x1080 = 2;
    public static boolean trackResUp = false;
    public static boolean trackResDown = false;
    public boolean trackLargerThanScreen = false;
    public static String[] resStr = new String[]{"800x600", "1280x720", "1920x1080"};
    public static double[] screenRatio = new double[]{0.625, 1.0, 1.5};
    Graphics g;
    public ImageLoader myLoader;
    public MenuMouse myMouse;
    public CarGraphics cars;
    public Menu menu;
    public TrackGraphics trackG;
    public Model renderModel;
    public static Camera cam;
    Toolkit tk;
    SimpleFont bluefont;
    SimpleFont timefont;
    public TimeGraphics timeG;
    public RaceUI raceUI;
    Dimension dim;
    FPS framesPerSec;
    AverageTimeForTask avgRender;
    Graphics bufferGraphics;
    BufferStrategy strategy;
    DisplayMode displayMode;
    long measureThis;
    public static int keypointX;
    public static int keypointY;
    public Image offscreen;
    public boolean menuLoaded = false;
    public boolean modelLoaded = false;
    public boolean screenCanBeMadeBigger = true;
    public boolean screenCanBeMadeSmaller = false;
    public byte bkGrLoop = 0;
    private SoundMan sm;
    public StartLamps lamps;

    public Renderer(ImageLoader il, Image offscreen, Graphics g, Dimension dim, Toolkit tk, SoundMan sm) {
        this.offscreen = offscreen;
        this.g = g;
        this.dim = dim;
        this.tk = tk;
        this.myLoader = il;
        this.sm = sm;
        this.init(il);
    }

    public Renderer(ImageLoader il, Image offscreen, BufferStrategy strategy, DisplayMode displayMode, Dimension dim, Toolkit tk, SoundMan sm) {
        Console.print("attempting fullscreen renderer init");
        this.offscreen = offscreen;
        this.strategy = strategy;
        this.displayMode = displayMode;
        this.dim = dim;
        this.tk = tk;
        this.myLoader = il;
        this.sm = sm;
        this.init(il);
    }

    void init(ImageLoader il) {
        Console.print("Renderer init");
        this.framesPerSec = new FPS();
        this.avgRender = new AverageTimeForTask();
        this.bufferGraphics = this.offscreen.getGraphics();
        if (this.strategy != null) {
            Console.print("startegy");
            this.bufferGraphics = this.strategy.getDrawGraphics();
        }
        Console.print("Font and Menu init");
        Image img = null;
        try {
            URL url = this.getClass().getResource("/fonts/bluefont.png");
            Console.print("url: " + url);
            URL url2 = this.getClass().getResource("\\fonts\\bluefont.png");
            Console.print("url2: " + url2);
            URL url3 = this.getClass().getResource("fonts/bluefont.png");
            Console.print("url3: " + url3);
            img = il.getImage("/fonts/bluefont.png");
            if (img != null) {
                Console.print("success getting font");
            }
        }
        catch (Exception e) {
            Console.print("having trouble getting font:" + e);
        }
        Console.print("why then does the simplefont fail?");
        this.bluefont = new SimpleFont(il, "/fonts/bluefont.png", 13, 15);
        Console.print("ahaa, trace more");
        this.menu = new Menu(il, this.bluefont, this.sm);
        Console.print("why then does the timefont fail?");
        this.timefont = new SimpleFont(il, "/fonts/timefont.png", 49, 48);
        this.timeG = new TimeGraphics(this.timefont);
        this.raceUI = new RaceUI();
        this.raceUI.setFont(this.bluefont);
        Console.print("Mouse init");
        this.myMouse = new MenuMouse(il);
        Console.print("Lamps");
        this.lamps = new StartLamps(il);
        Console.print("Finished Renderer Init");
    }

    public void getFont() {
    }

    public void passModelToRenderer(Model model) {
        this.renderModel = model;
        this.renderModel.passMe(this.menu.model);
    }

    public void paint(Graphics g) {
        Console.print("paint");
        g.drawImage(this.offscreen, 0, 0, this);
    }

    public void repaint(Graphics g, Image offscreen, int newW, int newH) {
        Console.print("REPAINT");
        this.dim.setSize(newW, newH);
        this.offscreen = offscreen;
        this.bufferGraphics = offscreen.getGraphics();
        this.menu.resizeMenu();
        this.changeTrackSize(resolution);
        g.drawImage(offscreen, 0, 0, this);
    }

    public void changeTrackSize(int res) {
        Console.print("CHANGESIZE");
        resolution = res;
        if (this.trackG != null && this.dim != null) {
            if (this.renderModel.track.localW > this.dim.width) {
                Console.print("trackLargerThanScreen = true");
                this.trackLargerThanScreen = true;
                if (cam != null) {
                    this.setCameraFocus();
                }
            } else {
                this.trackLargerThanScreen = false;
            }
        }
        if (this.trackG != null) {
            Console.print("setting keypoints and clips, dim: " + this.dim.width + " , " + this.dim.height);
            keypointX = this.dim.width / 2 - this.renderModel.track.localW / 2;
            keypointY = this.dim.height / 2 - this.renderModel.track.localH / 2;
            this.bufferGraphics.setClip(0, 0, this.dim.width, this.dim.width);
            this.bufferGraphics.setColor(Color.black);
            this.bufferGraphics.fillRect(0, 0, this.dim.width, this.dim.width);
        }
    }

    public void reloadAllImages() {
        if (this.trackG != null) {
            this.renderModel.trackGraphicsLoaded = false;
            Console.print("RELOAD");
            this.trackG.loadTrackImages(this.myLoader, this.renderModel.track);
            this.cars.createCarImages(this.myLoader, this.bufferGraphics, this.renderModel.players);
        }
        if (this.trackG != null) {
            Console.print("setting keypoints and clips, dim: " + this.dim.width + " , " + this.dim.height);
            keypointX = this.dim.width / 2 - this.renderModel.track.localW / 2;
            keypointY = this.dim.height / 2 - this.renderModel.track.localH / 2;
            this.bufferGraphics.setClip(0, 0, this.dim.width, this.dim.width);
            this.bufferGraphics.setColor(Color.black);
            this.bufferGraphics.fillRect(0, 0, this.dim.width, this.dim.width);
        }
    }

    public void wipeblackareas() {
        int horizontalspace = 0;
        int verticalspace = 0;
        if (this.renderModel.track.localW < this.dim.width) {
            horizontalspace = this.dim.width - this.renderModel.track.localW;
        }
        if (this.renderModel.track.localH < this.dim.height) {
            verticalspace = this.dim.height - this.renderModel.track.localH;
        }
        this.bufferGraphics.setClip(0, 0, this.dim.width, this.dim.height);
        this.bufferGraphics.setColor(Color.black);
        if (horizontalspace > 0) {
            this.bufferGraphics.fillRect(0, 0, horizontalspace / 2, this.dim.height);
            this.bufferGraphics.fillRect(this.dim.width - horizontalspace / 2, 0, horizontalspace / 2, this.dim.height);
        }
        if (verticalspace > 0) {
            this.bufferGraphics.fillRect(0, 0, this.dim.width, verticalspace / 2);
            this.bufferGraphics.fillRect(0, this.dim.height - verticalspace / 2, this.dim.width, verticalspace / 2);
        }
    }

    public void clearscreen() {
        this.bufferGraphics.setClip(0, 0, this.dim.width, this.dim.width);
        this.bufferGraphics.setColor(Color.black);
        this.bufferGraphics.fillRect(0, 0, this.dim.width, this.dim.width);
    }

    public void update(int ticks) {
        this.avgRender.logStartSample();
        if (this.strategy != null) {
            Console.print("startegy");
            this.bufferGraphics = this.strategy.getDrawGraphics();
        }
        this.clearscreen();
        switch (Engine.state) {
            case 0: {
                this.clearscreen();
                break;
            }
            case 1: {
                this.clearscreen();
                if (this.menu != null) {
                    this.menu.drawMenu(this.bufferGraphics);
                    if (this.myMouse != null) {
                        this.myMouse.drawMouseTrailPoints((Graphics2D)this.bufferGraphics);
                        this.myMouse.drawMouse(this.bufferGraphics, this.myMouse.mousePos.x, this.myMouse.mousePos.y);
                        Vector2 vec = this.myMouse.getMouseVector2();
                        this.menu.scrollBackGround(vec);
                    }
                }
                this.myMouse.setMouseTrailPoint(this.myMouse.trail[this.myMouse.listPos]);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                this.clearscreen();
                if (this.menu != null) {
                    this.menu.drawMenu(this.bufferGraphics);
                    if (this.myMouse != null) {
                        this.myMouse.drawMouseTrailPoints((Graphics2D)this.bufferGraphics);
                        this.myMouse.drawMouse(this.bufferGraphics, this.myMouse.mousePos.x, this.myMouse.mousePos.y);
                        Vector2 vec = this.myMouse.getMouseVector2();
                        this.menu.scrollBackGround(vec);
                    }
                }
                this.myMouse.setMouseTrailPoint(this.myMouse.trail[this.myMouse.listPos]);
                break;
            }
            case 6: {
                Console.print("STATE_LOADING_TRACK");
                this.clearscreen();
                if (!this.modelLoaded) break;
                this.cars = new CarGraphics(this.renderModel.players);
                this.trackG = new TrackGraphics();
                cam = new Camera(this.renderModel.players.elementAt(0));
                Console.print("resizing renderer, update()->loading_track");
                this.reloadAllImages();
                this.changeTrackSize(resolution);
                break;
            }
            case 3: 
            case 7: {
                if (trackResUp) {
                    Console.print("resUp");
                    this.changeTrackSize(resolution + 1);
                    trackResUp = false;
                }
                if (trackResDown) {
                    Console.print("resDown");
                    this.changeTrackSize(resolution - 1);
                    trackResDown = false;
                }
                if (this.trackLargerThanScreen) {
                    this.updateCamera();
                }
                this.trackG.drawTrack(this.bufferGraphics, this.renderModel.track);
                this.cars.drawCars(this.bufferGraphics, this.renderModel.players);
                if (!(Engine.state != 7 && Engine.state != 3 || StartLamps.turnOffLamps)) {
                    this.lamps.drawLamps(this.bufferGraphics, Track.startgrid.x + keypointX, Track.startgrid.y + Track.startgrid.height + keypointY);
                }
                this.wipeblackareas();
                this.timeG.drawTime(this.bufferGraphics, this.dim.width / 2, 50);
                this.raceUI.drawLocalPlayerNamesAndLapsComplete(this.bufferGraphics, this.renderModel.players);
                break;
            }
            case 8: {
                if (this.menu == null) break;
                this.menu.drawMenu(this.bufferGraphics);
                if (this.myMouse == null) break;
                this.myMouse.drawMouseTrailPoints((Graphics2D)this.bufferGraphics);
                this.myMouse.drawMouse(this.bufferGraphics, this.myMouse.mousePos.x, this.myMouse.mousePos.y);
                Vector2 vec = this.myMouse.getMouseVector2();
                this.menu.scrollBackGround(vec);
            }
        }
        this.bufferGraphics.setClip(0, 0, this.dim.width, this.dim.width);
        this.bufferGraphics.setColor(Color.black);
        if (Engine.state == 3) {
            this.bufferGraphics.setColor(Color.white);
        }
        if (showDebug) {
            this.drawGameStateText(this.bufferGraphics);
            if (this.framesPerSec.fps > 0) {
                if (this.framesPerSec.slowFrameFlag) {
                    this.bufferGraphics.drawString("!" + this.framesPerSec.slowFrame / 1000000L + "ms " + this.framesPerSec.fps + " fps", 10, 130);
                } else {
                    this.bufferGraphics.drawString(String.valueOf(this.framesPerSec.fps) + " fps", 10, 130);
                }
            } else {
                this.bufferGraphics.drawString("--- fps", 10, 130);
            }
            this.bufferGraphics.drawString("avgR " + this.avgRender.time + "ms", 10, 150);
            this.bufferGraphics.drawString("avgE " + Engine.avgEngine.time + "ms", 10, 170);
            if (Engine.state == 6) {
                this.bufferGraphics.drawString("LOADING TRACK", 80, 160);
            }
        }
        if (this.strategy != null) {
            Console.print("dispose and show");
            this.bufferGraphics.dispose();
            this.strategy.show();
        } else {
            this.g.drawImage(this.offscreen, 0, 0, this);
        }
        this.framesPerSec.logFPS();
        this.avgRender.logEndSample();
    }

    public void setCameraFocus() {
        Point screendim = new Point(this.dim.width, this.dim.height);
        cam.setScreenSize(screendim);
        Point trackdim = new Point(this.renderModel.track.localW, this.renderModel.track.localH);
        cam.setTrackSize(trackdim);
        if (this.renderModel.track.localW > this.dim.width) {
            cam.adjustPosition();
        } else {
            Renderer.cam.cameraAdjustmentX = this.dim.width / 2 - this.renderModel.track.localW / 2;
            Renderer.cam.cameraAdjustmentY = this.dim.height / 2 - this.renderModel.track.localH / 2;
        }
        Console.print("set camerafocus : " + Renderer.cam.cameraAdjustmentX + "," + Renderer.cam.cameraAdjustmentY);
    }

    public void updateCamera() {
        cam.adjustPosition();
        keypointX = Renderer.cam.cameraAdjustmentX;
        keypointY = Renderer.cam.cameraAdjustmentY;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    public void mouseMoved(MouseEvent evt) {
        this.myMouse.mouseMoved(evt);
        this.menu.mouseMoved(evt);
    }

    public void mouseClicked(MouseEvent evt) {
        this.menu.mouseClicked(evt);
    }

    public void mousePressed(MouseEvent evt) {
        this.menu.menuMouseAndButtonGraphics(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.menu.mouseReleased(evt);
    }

    public void drawGameStateText(Graphics g) {
        switch (Engine.state) {
            case 0: {
                g.drawString("gameState: " + Engine.state + ", LOADING APP", 10, 12);
                break;
            }
            case 1: {
                g.drawString("gameState: " + Engine.state + ", MAIN MENU", 10, 12);
                break;
            }
            case 2: {
                g.drawString("gameState: " + Engine.state + ", LOCAL MENU", 10, 12);
                break;
            }
            case 3: {
                g.drawString("gameState: " + Engine.state + ", LOCAL RACE", 10, 12);
                break;
            }
            case 4: {
                g.drawString("gameState: " + Engine.state + ", LOCAL SETTINGS", 10, 12);
                break;
            }
            case 5: {
                g.drawString("gameState: " + Engine.state + ", LOCAL TRACK AND CAR", 10, 11);
                break;
            }
            case 11: {
                g.drawString("gameState: " + Engine.state + ", MULTIP. LOBBY", 10, 12);
                break;
            }
            case 12: {
                g.drawString("gameState: " + Engine.state + ", MULTIP. PRERACE", 10, 12);
                break;
            }
            case 13: {
                g.drawString("gameState: " + Engine.state + ", MULTIP. RACE", 10, 12);
            }
        }
    }
}

