/*
 * Decompiled with CFR 0.152.
 */
package slicks.ui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.Vector;
import other.Console;
import slicks.engine.ImageLoader;
import slicks.model.Track;
import slicks.model.TrackBlock;
import slicks.model.TrackMarker;
import slicks.ui.Renderer;

public class TrackGraphics {
    public boolean drawInvisibleBlocks = false;

    public void loadImagesIntoVector(ImageLoader loader, Vector objvec) {
        if (!objvec.isEmpty()) {
            int i = 0;
            while (i < objvec.size()) {
                TrackBlock block = (TrackBlock)objvec.elementAt(i);
                if (block.name.length() > 1) {
                    try {
                        Image tempImg = loader.getImage("/" + Renderer.resStr[Renderer.resolution] + block.filename);
                        block.blockImg = loader.toBufferedImage(tempImg);
                        if (block.rotationDegree != 0.0f) {
                            block.rotateOriginalImage(block.rotationDegree);
                        }
                        block.width = block.blockImg.getWidth(null);
                        block.height = block.blockImg.getHeight(null);
                        block.setXYScaled(new Point(block.x, block.y), Renderer.screenRatio[Renderer.resolution]);
                        Console.print("file: " + block.filename + ", .x " + block.x + ", .y " + block.y + ", locX " + block.localX + ", locY " + block.localY + " w " + block.width + " h " + block.height);
                    }
                    catch (NullPointerException e) {
                        Console.print("This exception Fails TO CATCH???" + e);
                    }
                } else {
                    Console.print("nogfx! " + block.filename);
                    if (block.type == TrackBlock.BLOCK_TYPE_MARKER && (((TrackMarker)block).markerType == 2 || ((TrackMarker)block).markerType == 3)) {
                        Line2D.Double line = ((TrackMarker)block).makeControlLineFromMarker();
                        Console.print("adding line for marker " + block.name + " line " + line.x1 + "," + line.y1 + ":" + line.x2 + "," + line.y2);
                        Track.controlPointLines.add(line);
                    }
                }
                ++i;
            }
        }
    }

    public void loadStartGridImage(ImageLoader loader, TrackMarker startmarker) {
        Console.print("startmarker.filename: " + startmarker.filename);
        Image tempImg = loader.getImage("/" + Renderer.resStr[Renderer.resolution] + startmarker.filename);
        startmarker.blockImg = loader.toBufferedImage(tempImg);
        if (startmarker.rotationDegree != 0.0f) {
            startmarker.rotateOriginalImage(startmarker.rotationDegree);
        }
        startmarker.width = startmarker.blockImg.getWidth(null);
        startmarker.height = startmarker.blockImg.getHeight(null);
        startmarker.setXYScaled(new Point(startmarker.x, startmarker.y), Renderer.screenRatio[Renderer.resolution]);
    }

    public void loadTrackImages(ImageLoader loader, Track trackObj) {
        Console.print("load TrackImages");
        trackObj.setScaledWH(Renderer.screenRatio[Renderer.resolution]);
        this.loadImagesIntoVector(loader, trackObj.backgroundpieces);
        this.loadImagesIntoVector(loader, trackObj.trackpieces);
        this.loadImagesIntoVector(loader, trackObj.solidpieces);
        Track.controlPointLines.removeAllElements();
        this.loadImagesIntoVector(loader, trackObj.invisiblepieces);
        Console.print("marker pieces next");
        this.loadImagesIntoVector(loader, trackObj.markerpieces);
        if (Track.controlPointLines == null || Track.controlPointLines.size() == 0) {
            Console.print("NO CONTROLPOINTS!!");
        }
    }

    public void drawTrack(Graphics g, Track track) {
        this.drawTrackBlocks(g, track.backgroundpieces);
        this.drawTrackBlocks(g, track.trackpieces);
        this.drawTrackBlocks(g, track.solidpieces);
        this.drawTrackBlocks(g, track.markerpieces);
        if (this.drawInvisibleBlocks) {
            this.drawTrackBlocks(g, track.invisiblepieces);
        }
    }

    public void drawTrackBlocks(Graphics g, Vector blockVec) {
        if (blockVec != null) {
            int i = 0;
            while (i < blockVec.size()) {
                TrackBlock block = (TrackBlock)blockVec.elementAt(i);
                g.drawImage(block.blockImg, Renderer.keypointX + block.localX, Renderer.keypointY + block.localY, null);
                if (block.type == TrackBlock.BLOCK_TYPE_MARKER && (((TrackMarker)block).markerType == 2 || ((TrackMarker)block).markerType == 3) && this.drawInvisibleBlocks) {
                    ((TrackMarker)block).drawControlPoints(g, Renderer.keypointX, Renderer.keypointY, false);
                }
                ++i;
            }
        }
    }
}

