/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis;

class drft_lookup {
    static final int L101 = 101;
    static final int L102 = 102;
    static final int L103 = 103;
    static final int L104 = 104;
    static final int L105 = 105;
    static final int L106 = 106;
    static final int L107 = 107;
    static final int L109 = 109;
    static final int L110 = 110;
    static final int L112 = 112;
    static final int L115 = 115;
    static final int L116 = 116;
    static final int L119 = 119;
    static final int L128 = 128;
    static final int L132 = 132;
    static final int L135 = 135;
    static final int L139 = 139;
    static final int L141 = 141;
    static final int LDONE = 9999;
    int n;
    float[] trigcache;
    int[] splitcache;

    public drft_lookup() {
    }

    public drft_lookup(int _n, float[] _trigcache, int[] _splitcache) {
        this.n = _n;
        this.trigcache = (float[])_trigcache.clone();
        this.splitcache = (int[])_splitcache.clone();
    }

    public drft_lookup(drft_lookup src) {
        this(src.n, src.trigcache, src.splitcache);
    }

    public void drft_forward(float[] data) {
        if (this.n == 1) {
            return;
        }
        drft_lookup.drftf1(this.n, data, this.trigcache, this.splitcache);
    }

    public void drft_backward(float[] data) {
        if (this.n == 1) {
            return;
        }
        drft_lookup.drftb1(this.n, data, this.trigcache, this.splitcache);
    }

    public void drft_init(int _n) {
        this.n = _n;
        this.trigcache = new float[3 * this.n];
        this.splitcache = new int[32];
        drft_lookup.fdrffti(this.n, this.trigcache, this.splitcache);
    }

    static void fdrffti(int _n, float[] wsave, int[] ifac) {
        if (_n == 1) {
            return;
        }
        drft_lookup.drfti1(_n, wsave, ifac);
    }

    static void drfti1(int _n, float[] wa, int[] ifac) {
        int[] ntryh = new int[]{4, 2, 3, 5};
        float tpi = (float)Math.PI * 2;
        int ntry = 0;
        int j = -1;
        int nl = _n;
        int nf = 0;
        int state = 101;
        while (state != 9999) {
            switch (state) {
                case 101: {
                    ntry = ++j < 4 ? ntryh[j] : (ntry += 2);
                    state = 104;
                    break;
                }
                case 104: {
                    int nq = nl / ntry;
                    int nr = nl - ntry * nq;
                    if (nr != 0) {
                        state = 101;
                        break;
                    }
                    ifac[++nf + 1] = ntry;
                    nl = nq;
                    if (ntry != 2) {
                        state = 107;
                        break;
                    }
                    if (nf == 1) {
                        state = 107;
                        break;
                    }
                    int i = 1;
                    while (i < nf) {
                        int ib = nf - i + 1;
                        ifac[ib + 1] = ifac[ib];
                        ++i;
                    }
                    ifac[2] = 2;
                    state = 107;
                    break;
                }
                case 107: {
                    int i;
                    if (nl != 1) {
                        state = 104;
                        break;
                    }
                    ifac[0] = _n;
                    ifac[1] = nf;
                    float argh = tpi / (float)_n;
                    int is = 0;
                    int nfm1 = nf - 1;
                    int l1 = 1;
                    if (nfm1 == 0) {
                        return;
                    }
                    int k1 = 0;
                    while (k1 < nfm1) {
                        int ip = ifac[k1 + 2];
                        int ld = 0;
                        int l2 = l1 * ip;
                        int ido = _n / l2;
                        int ipm = ip - 1;
                        j = 0;
                        while (j < ipm) {
                            i = is;
                            float argld = (float)(ld += l1) * argh;
                            float fi = 0.0f;
                            int ii = 2;
                            while (ii < ido) {
                                float arg = (fi += 1.0f) * argld;
                                wa[_n + i++] = new Double(Math.cos(arg)).floatValue();
                                wa[_n + i++] = new Double(Math.sin(arg)).floatValue();
                                ii += 2;
                            }
                            is += ido;
                            ++j;
                        }
                        l1 = l2;
                        ++k1;
                    }
                    state = 9999;
                }
            }
        }
    }

    static void drftf1(int _n, float[] c, float[] ch, int[] ifac) {
        float[] wa = ch;
        int waoff = _n;
        int l1 = 0;
        int l2 = 0;
        int nf = 0;
        int ip = 0;
        int ido = 0;
        int idl1 = 0;
        nf = ifac[1];
        int na = 1;
        l2 = _n;
        int iw = _n;
        int k1 = 0;
        while (k1 < nf) {
            int state = 101;
            while (state != 9999) {
                switch (state) {
                    case 101: {
                        int kh = nf - k1;
                        ip = ifac[kh + 1];
                        l1 = l2 / ip;
                        ido = _n / l2;
                        idl1 = ido * l1;
                        iw -= (ip - 1) * ido;
                        na = 1 - na;
                        if (ip != 4) {
                            state = 102;
                            break;
                        }
                        int ix2 = iw + ido;
                        int ix3 = ix2 + ido;
                        if (na != 0) {
                            drft_lookup.dradf4(ido, l1, ch, c, wa, waoff + iw - 1, waoff + ix2 - 1, waoff + ix3 - 1);
                        } else {
                            drft_lookup.dradf4(ido, l1, c, ch, wa, waoff + iw - 1, waoff + ix2 - 1, waoff + ix3 - 1);
                        }
                        state = 110;
                        break;
                    }
                    case 102: {
                        if (ip != 2) {
                            state = 104;
                            break;
                        }
                        if (na != 0) {
                            state = 103;
                            break;
                        }
                        drft_lookup.dradf2(ido, l1, c, ch, wa, waoff + iw - 1);
                        state = 110;
                        break;
                    }
                    case 103: {
                        drft_lookup.dradf2(ido, l1, ch, c, wa, waoff + iw - 1);
                        state = 110;
                        break;
                    }
                    case 104: {
                        if (ido == 1) {
                            na = 1 - na;
                        }
                        if (na != 0) {
                            state = 109;
                            break;
                        }
                        drft_lookup.dradfg(ido, ip, l1, idl1, c, c, c, ch, ch, wa, waoff + iw - 1);
                        na = 1;
                        state = 110;
                        break;
                    }
                    case 109: {
                        drft_lookup.dradfg(ido, ip, l1, idl1, ch, ch, ch, c, c, wa, waoff + iw - 1);
                        na = 0;
                        state = 110;
                        break;
                    }
                    case 110: {
                        l2 = l1;
                        state = 9999;
                    }
                }
            }
            ++k1;
        }
        if (na == 1) {
            return;
        }
        int i = 0;
        while (i < _n) {
            c[i] = ch[i];
            ++i;
        }
    }

    static void dradf2(int ido, int l1, float[] cc, float[] ch, float[] wa1, int waoff) {
        int t2;
        int t1 = 0;
        int t0 = t2 = l1 * ido;
        int t3 = ido << 1;
        int k = 0;
        while (k < l1) {
            ch[t1 << 1] = cc[t1] + cc[t2];
            ch[(t1 << 1) + t3 - 1] = cc[t1] - cc[t2];
            t1 += ido;
            t2 += ido;
            ++k;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            t1 = 0;
            t2 = t0;
            k = 0;
            while (k < l1) {
                t3 = t2;
                int t4 = (t1 << 1) + (ido << 1);
                int t5 = t1;
                int t6 = t1 + t1;
                int i = 2;
                while (i < ido) {
                    float tr2 = wa1[waoff + i - 2] * cc[(t3 += 2) - 1] + wa1[waoff + i - 1] * cc[t3];
                    float ti2 = wa1[waoff + i - 2] * cc[t3] - wa1[waoff + i - 1] * cc[t3 - 1];
                    ch[t6 += 2] = cc[t5 += 2] + ti2;
                    ch[t4 -= 2] = ti2 - cc[t5];
                    ch[t6 - 1] = cc[t5 - 1] + tr2;
                    ch[t4 - 1] = cc[t5 - 1] - tr2;
                    i += 2;
                }
                t1 += ido;
                t2 += ido;
                ++k;
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        t1 = ido;
        t3 = t2 = t1 - 1;
        t2 += t0;
        k = 0;
        while (k < l1) {
            ch[t1] = -cc[t2];
            ch[t1 - 1] = cc[t3];
            t1 += ido << 1;
            t2 += ido;
            t3 += ido;
            ++k;
        }
    }

    static void dradf4(int ido, int l1, float[] cc, float[] ch, float[] wa, int wa1, int wa2, int wa3) {
        float ti1;
        int t6;
        int t5;
        float tr2;
        float tr1;
        int t0;
        float hsqt2 = 0.70710677f;
        int t1 = t0 = l1 * ido;
        int t4 = t1 << 1;
        int t2 = t1 + (t1 << 1);
        int t3 = 0;
        int k = 0;
        while (k < l1) {
            tr1 = cc[t1] + cc[t2];
            tr2 = cc[t3] + cc[t4];
            t5 = t3 << 2;
            ch[t5] = tr1 + tr2;
            ch[(ido << 2) + t5 - 1] = tr2 - tr1;
            ch[(t5 += ido << 1) - 1] = cc[t3] - cc[t4];
            ch[t5] = cc[t2] - cc[t1];
            t1 += ido;
            t2 += ido;
            t3 += ido;
            t4 += ido;
            ++k;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            t1 = 0;
            k = 0;
            while (k < l1) {
                t2 = t1;
                t4 = t1 << 2;
                t6 = ido << 1;
                t5 = t6 + t4;
                int i = 2;
                while (i < ido) {
                    t3 = t2 += 2;
                    t4 += 2;
                    t5 -= 2;
                    float cr2 = wa[wa1 + i - 2] * cc[(t3 += t0) - 1] + wa[wa1 + i - 1] * cc[t3];
                    float ci2 = wa[wa1 + i - 2] * cc[t3] - wa[wa1 + i - 1] * cc[t3 - 1];
                    float cr3 = wa[wa2 + i - 2] * cc[(t3 += t0) - 1] + wa[wa2 + i - 1] * cc[t3];
                    float ci3 = wa[wa2 + i - 2] * cc[t3] - wa[wa2 + i - 1] * cc[t3 - 1];
                    float cr4 = wa[wa3 + i - 2] * cc[(t3 += t0) - 1] + wa[wa3 + i - 1] * cc[t3];
                    float ci4 = wa[wa3 + i - 2] * cc[t3] - wa[wa3 + i - 1] * cc[t3 - 1];
                    tr1 = cr2 + cr4;
                    float tr4 = cr4 - cr2;
                    ti1 = ci2 + ci4;
                    float ti4 = ci2 - ci4;
                    float ti2 = cc[t2] + ci3;
                    float ti3 = cc[t2] - ci3;
                    tr2 = cc[t2 - 1] + cr3;
                    float tr3 = cc[t2 - 1] - cr3;
                    ch[t4 - 1] = tr1 + tr2;
                    ch[t4] = ti1 + ti2;
                    ch[t5 - 1] = tr3 - ti4;
                    ch[t5] = tr4 - ti3;
                    ch[t4 + t6 - 1] = ti4 + tr3;
                    ch[t4 + t6] = tr4 + ti3;
                    ch[t5 + t6 - 1] = tr2 - tr1;
                    ch[t5 + t6] = ti1 - ti2;
                    i += 2;
                }
                t1 += ido;
                ++k;
            }
            if ((ido & 1) == 1) {
                return;
            }
        }
        t1 = t0 + ido - 1;
        t2 = t1 + (t0 << 1);
        t3 = ido << 2;
        t4 = ido;
        t5 = ido << 1;
        t6 = ido;
        k = 0;
        while (k < l1) {
            ti1 = -hsqt2 * (cc[t1] + cc[t2]);
            tr1 = hsqt2 * (cc[t1] - cc[t2]);
            ch[t4 - 1] = tr1 + cc[t6 - 1];
            ch[t4 + t5 - 1] = cc[t6 - 1] - tr1;
            ch[t4] = ti1 - cc[t1 + t0];
            ch[t4 + t5] = ti1 + cc[t1 + t0];
            t1 += ido;
            t2 += ido;
            t4 += t3;
            t6 += ido;
            ++k;
        }
    }

    static void dradfg(int ido, int ip, int l1, int idl1, float[] cc, float[] c1, float[] c2, float[] ch, float[] ch2, float[] wa, int waoff) {
        int t9;
        int t8;
        int t7;
        int t6;
        int t5;
        int t4;
        int i;
        int t3;
        int k;
        int t2;
        int j;
        int t1;
        int ik;
        float tpi = (float)Math.PI * 2;
        float arg = tpi / new Integer(ip).floatValue();
        float dcp = new Double(Math.cos(arg)).floatValue();
        float dsp = new Double(Math.sin(arg)).floatValue();
        int ipph = ip + 1 >> 1;
        int ipp2 = ip;
        int idp2 = ido;
        int nbd = ido - 1 >> 1;
        int t0 = l1 * ido;
        int t10 = ip * ido;
        if (ido != 1) {
            int idij;
            ik = 0;
            while (ik < idl1) {
                ch2[ik] = c2[ik];
                ++ik;
            }
            t1 = 0;
            j = 1;
            while (j < ip) {
                t2 = t1 += t0;
                k = 0;
                while (k < l1) {
                    ch[t2] = c1[t2];
                    t2 += ido;
                    ++k;
                }
                ++j;
            }
            int is = -ido;
            t1 = 0;
            if (nbd > l1) {
                j = 1;
                while (j < ip) {
                    is += ido;
                    t2 = -ido + (t1 += t0);
                    k = 0;
                    while (k < l1) {
                        idij = is - 1;
                        t3 = t2 += ido;
                        i = 2;
                        while (i < ido) {
                            ch[(t3 += 2) - 1] = wa[waoff + (idij += 2) - 1] * c1[t3 - 1] + wa[waoff + idij] * c1[t3];
                            ch[t3] = wa[waoff + idij - 1] * c1[t3] - wa[waoff + idij] * c1[t3 - 1];
                            i += 2;
                        }
                        ++k;
                    }
                    ++j;
                }
            } else {
                j = 1;
                while (j < ip) {
                    idij = (is += ido) - 1;
                    t2 = t1 += t0;
                    i = 2;
                    while (i < ido) {
                        idij += 2;
                        t3 = t2 += 2;
                        k = 0;
                        while (k < l1) {
                            ch[t3 - 1] = wa[waoff + idij - 1] * c1[t3 - 1] + wa[waoff + idij] * c1[t3];
                            ch[t3] = wa[waoff + idij - 1] * c1[t3] - wa[waoff + idij] * c1[t3 - 1];
                            t3 += ido;
                            ++k;
                        }
                        i += 2;
                    }
                    ++j;
                }
            }
            t1 = 0;
            t2 = ipp2 * t0;
            if (nbd < l1) {
                j = 1;
                while (j < ipph) {
                    t3 = t1 += t0;
                    t4 = t2 -= t0;
                    i = 2;
                    while (i < ido) {
                        t5 = (t3 += 2) - ido;
                        t6 = (t4 += 2) - ido;
                        k = 0;
                        while (k < l1) {
                            c1[(t5 += ido) - 1] = ch[t5 - 1] + ch[(t6 += ido) - 1];
                            c1[t6 - 1] = ch[t5] - ch[t6];
                            c1[t5] = ch[t5] + ch[t6];
                            c1[t6] = ch[t6 - 1] - ch[t5 - 1];
                            ++k;
                        }
                        i += 2;
                    }
                    ++j;
                }
            } else {
                j = 1;
                while (j < ipph) {
                    t3 = t1 += t0;
                    t4 = t2 -= t0;
                    k = 0;
                    while (k < l1) {
                        t5 = t3;
                        t6 = t4;
                        i = 2;
                        while (i < ido) {
                            c1[(t5 += 2) - 1] = ch[t5 - 1] + ch[(t6 += 2) - 1];
                            c1[t6 - 1] = ch[t5] - ch[t6];
                            c1[t5] = ch[t5] + ch[t6];
                            c1[t6] = ch[t6 - 1] - ch[t5 - 1];
                            i += 2;
                        }
                        t3 += ido;
                        t4 += ido;
                        ++k;
                    }
                    ++j;
                }
            }
        }
        ik = 0;
        while (ik < idl1) {
            c2[ik] = ch2[ik];
            ++ik;
        }
        t1 = 0;
        t2 = ipp2 * idl1;
        j = 1;
        while (j < ipph) {
            t3 = (t1 += t0) - ido;
            t4 = (t2 -= t0) - ido;
            k = 0;
            while (k < l1) {
                c1[t3 += ido] = ch[t3] + ch[t4 += ido];
                c1[t4] = ch[t4] - ch[t3];
                ++k;
            }
            ++j;
        }
        float ar1 = 1.0f;
        float ai1 = 0.0f;
        t1 = 0;
        t2 = ipp2 * idl1;
        t3 = (ip - 1) * idl1;
        int l = 1;
        while (l < ipph) {
            float ar1h = dcp * ar1 - dsp * ai1;
            ai1 = dcp * ai1 + dsp * ar1;
            ar1 = ar1h;
            t4 = t1 += idl1;
            t5 = t2 -= idl1;
            t6 = t3;
            t7 = idl1;
            ik = 0;
            while (ik < idl1) {
                ch2[t4++] = c2[ik] + ar1 * c2[t7++];
                ch2[t5++] = ai1 * c2[t6++];
                ++ik;
            }
            float dc2 = ar1;
            float ds2 = ai1;
            float ar2 = ar1;
            float ai2 = ai1;
            t4 = idl1;
            t5 = (ipp2 - 1) * idl1;
            j = 2;
            while (j < ipph) {
                t4 += idl1;
                t5 -= idl1;
                float ar2h = dc2 * ar2 - ds2 * ai2;
                ai2 = dc2 * ai2 + ds2 * ar2;
                ar2 = ar2h;
                t6 = t1;
                t7 = t2;
                t8 = t4;
                t9 = t5;
                ik = 0;
                while (ik < idl1) {
                    int n = t6++;
                    ch2[n] = ch2[n] + ar2 * c2[t8++];
                    int n2 = t7++;
                    ch2[n2] = ch2[n2] + ai2 * c2[t9++];
                    ++ik;
                }
                ++j;
            }
            ++l;
        }
        t1 = 0;
        j = 1;
        while (j < ipph) {
            t2 = t1 += idl1;
            ik = 0;
            while (ik < idl1) {
                int n = ik++;
                ch2[n] = ch2[n] + c2[t2++];
            }
            ++j;
        }
        if (ido < l1) {
            i = 0;
            while (i < ido) {
                t1 = i;
                t2 = i;
                k = 0;
                while (k < l1) {
                    cc[t2] = ch[t1];
                    t1 += ido;
                    t2 += t10;
                    ++k;
                }
                ++i;
            }
        } else {
            t1 = 0;
            t2 = 0;
            k = 0;
            while (k < l1) {
                t3 = t1;
                t4 = t2;
                i = 0;
                while (i < ido) {
                    cc[t4++] = ch[t3++];
                    ++i;
                }
                t1 += ido;
                t2 += t10;
                ++k;
            }
        }
        t1 = 0;
        t2 = ido << 1;
        t3 = 0;
        t4 = ipp2 * t0;
        j = 1;
        while (j < ipph) {
            t5 = t1 += t2;
            t6 = t3 += t0;
            t7 = t4 -= t0;
            k = 0;
            while (k < l1) {
                cc[t5 - 1] = ch[t6];
                cc[t5] = ch[t7];
                t5 += t10;
                t6 += ido;
                t7 += ido;
                ++k;
            }
            ++j;
        }
        if (ido == 1) {
            return;
        }
        if (nbd < l1) {
            t1 = -ido;
            t3 = 0;
            t4 = 0;
            t5 = ipp2 * t0;
            j = 1;
            while (j < ipph) {
                t1 += t2;
                t3 += t2;
                t4 += t0;
                t5 -= t0;
                i = 2;
                while (i < ido) {
                    t6 = idp2 + t1 - i;
                    t7 = i + t3;
                    t8 = i + t4;
                    t9 = i + t5;
                    k = 0;
                    while (k < l1) {
                        cc[t7 - 1] = ch[t8 - 1] + ch[t9 - 1];
                        cc[t6 - 1] = ch[t8 - 1] - ch[t9 - 1];
                        cc[t7] = ch[t8] + ch[t9];
                        cc[t6] = ch[t9] - ch[t8];
                        t6 += t10;
                        t7 += t10;
                        t8 += ido;
                        t9 += ido;
                        ++k;
                    }
                    i += 2;
                }
                ++j;
            }
        } else {
            t1 = -ido;
            t3 = 0;
            t4 = 0;
            t5 = ipp2 * t0;
            j = 1;
            while (j < ipph) {
                t6 = t1 += t2;
                t7 = t3 += t2;
                t8 = t4 += t0;
                t9 = t5 -= t0;
                k = 0;
                while (k < l1) {
                    i = 2;
                    while (i < ido) {
                        int ic = idp2 - i;
                        cc[i + t7 - 1] = ch[i + t8 - 1] + ch[i + t9 - 1];
                        cc[ic + t6 - 1] = ch[i + t8 - 1] - ch[i + t9 - 1];
                        cc[i + t7] = ch[i + t8] + ch[i + t9];
                        cc[ic + t6] = ch[i + t9] - ch[i + t8];
                        i += 2;
                    }
                    t6 += t10;
                    t7 += t10;
                    t8 += ido;
                    t9 += ido;
                    ++k;
                }
                ++j;
            }
        }
    }

    static void drftb1(int _n, float[] c, float[] ch, int[] ifac) {
        float[] wa = ch;
        int waoff = _n;
        int l2 = 0;
        int ip = 0;
        int ido = 0;
        int idl1 = 0;
        int nf = ifac[1];
        int na = 0;
        int l1 = 1;
        int iw = 1;
        int k1 = 0;
        while (k1 < nf) {
            int state = 101;
            while (state != 9999) {
                switch (state) {
                    case 101: {
                        ip = ifac[k1 + 2];
                        l2 = ip * l1;
                        ido = _n / l2;
                        idl1 = ido * l1;
                        if (ip != 4) {
                            state = 103;
                            break;
                        }
                        int ix2 = iw + ido;
                        int ix3 = ix2 + ido;
                        if (na != 0) {
                            drft_lookup.dradb4(ido, l1, ch, c, wa, waoff + iw - 1, waoff + ix2 - 1, waoff + ix3 - 1);
                        } else {
                            drft_lookup.dradb4(ido, l1, c, ch, wa, waoff + iw - 1, waoff + ix2 - 1, waoff + ix3 - 1);
                        }
                        na = 1 - na;
                        state = 115;
                        break;
                    }
                    case 103: {
                        if (ip != 2) {
                            state = 106;
                            break;
                        }
                        if (na != 0) {
                            drft_lookup.dradb2(ido, l1, ch, c, wa, waoff + iw - 1);
                        } else {
                            drft_lookup.dradb2(ido, l1, c, ch, wa, waoff + iw - 1);
                        }
                        na = 1 - na;
                        state = 115;
                        break;
                    }
                    case 106: {
                        if (ip != 3) {
                            state = 109;
                            break;
                        }
                        int ix2 = iw + ido;
                        if (na != 0) {
                            drft_lookup.dradb3(ido, l1, ch, c, wa, waoff + iw - 1, waoff + ix2 - 1);
                        } else {
                            drft_lookup.dradb3(ido, l1, c, ch, wa, waoff + iw - 1, waoff + ix2 - 1);
                        }
                        na = 1 - na;
                        state = 115;
                        break;
                    }
                    case 109: {
                        if (na != 0) {
                            drft_lookup.dradbg(ido, ip, l1, idl1, ch, ch, ch, c, c, wa, waoff + iw - 1);
                        } else {
                            drft_lookup.dradbg(ido, ip, l1, idl1, c, c, c, ch, ch, wa, waoff + iw - 1);
                        }
                        if (ido == 1) {
                            na = 1 - na;
                        }
                        state = 115;
                        break;
                    }
                    case 115: {
                        l1 = l2;
                        iw += (ip - 1) * ido;
                        state = 9999;
                    }
                }
            }
            ++k1;
        }
        if (na == 0) {
            return;
        }
        int i = 0;
        while (i < _n) {
            c[i] = ch[i];
            ++i;
        }
    }

    static void dradb2(int ido, int l1, float[] cc, float[] ch, float[] wa1, int waoff) {
        int t0 = l1 * ido;
        int t1 = 0;
        int t2 = 0;
        int t3 = (ido << 1) - 1;
        int k = 0;
        while (k < l1) {
            ch[t1] = cc[t2] + cc[t3 + t2];
            ch[t1 + t0] = cc[t2] - cc[t3 + t2];
            t2 = (t1 += ido) << 1;
            ++k;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            t1 = 0;
            t2 = 0;
            k = 0;
            while (k < l1) {
                t3 = t1;
                int t4 = t2;
                int t5 = t4 + (ido << 1);
                int t6 = t0 + t1;
                int i = 2;
                while (i < ido) {
                    ch[(t3 += 2) - 1] = cc[(t4 += 2) - 1] + cc[(t5 -= 2) - 1];
                    float tr2 = cc[t4 - 1] - cc[t5 - 1];
                    ch[t3] = cc[t4] - cc[t5];
                    float ti2 = cc[t4] + cc[t5];
                    ch[(t6 += 2) - 1] = wa1[waoff + i - 2] * tr2 - wa1[waoff + i - 1] * ti2;
                    ch[t6] = wa1[waoff + i - 2] * ti2 + wa1[waoff + i - 1] * tr2;
                    i += 2;
                }
                t2 = (t1 += ido) << 1;
                ++k;
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        t1 = ido - 1;
        t2 = ido - 1;
        k = 0;
        while (k < l1) {
            ch[t1] = cc[t2] + cc[t2];
            ch[t1 + t0] = -(cc[t2 + 1] + cc[t2 + 1]);
            t1 += ido;
            t2 += ido << 1;
            ++k;
        }
    }

    static void dradb3(int ido, int l1, float[] cc, float[] ch, float[] wa, int wa1, int wa2) {
        float ci3;
        float cr2;
        float tr2;
        float taur = -0.5f;
        float taui = 0.8660254f;
        int t0 = l1 * ido;
        int t1 = 0;
        int t2 = t0 << 1;
        int t3 = ido << 1;
        int t4 = ido + (ido << 1);
        int t5 = 0;
        int k = 0;
        while (k < l1) {
            tr2 = cc[t3 - 1] + cc[t3 - 1];
            cr2 = cc[t5] + taur * tr2;
            ch[t1] = cc[t5] + tr2;
            ci3 = taui * (cc[t3] + cc[t3]);
            ch[t1 + t0] = cr2 - ci3;
            ch[t1 + t2] = cr2 + ci3;
            t1 += ido;
            t3 += t4;
            t5 += t4;
            ++k;
        }
        if (ido == 1) {
            return;
        }
        t1 = 0;
        t3 = ido << 1;
        k = 0;
        while (k < l1) {
            int t7 = t1 + (t1 << 1);
            int t6 = t5 = t7 + t3;
            int t8 = t1;
            int t9 = t1 + t0;
            int t10 = t9 + t0;
            int i = 2;
            while (i < ido) {
                t9 += 2;
                t10 += 2;
                tr2 = cc[(t5 += 2) - 1] + cc[(t6 -= 2) - 1];
                cr2 = cc[(t7 += 2) - 1] + taur * tr2;
                ch[(t8 += 2) - 1] = cc[t7 - 1] + tr2;
                float ti2 = cc[t5] - cc[t6];
                float ci2 = cc[t7] + taur * ti2;
                ch[t8] = cc[t7] + ti2;
                float cr3 = taui * (cc[t5 - 1] - cc[t6 - 1]);
                ci3 = taui * (cc[t5] + cc[t6]);
                float dr2 = cr2 - ci3;
                float dr3 = cr2 + ci3;
                float di2 = ci2 + cr3;
                float di3 = ci2 - cr3;
                ch[t9 - 1] = wa[wa1 + i - 2] * dr2 - wa[wa1 + i - 1] * di2;
                ch[t9] = wa[wa1 + i - 2] * di2 + wa[wa1 + i - 1] * dr2;
                ch[t10 - 1] = wa[wa2 + i - 2] * dr3 - wa[wa2 + i - 1] * di3;
                ch[t10] = wa[wa2 + i - 2] * di3 + wa[wa2 + i - 1] * dr3;
                i += 2;
            }
            t1 += ido;
            ++k;
        }
    }

    static void dradb4(int ido, int l1, float[] cc, float[] ch, float[] wa, int wa1, int wa2, int wa3) {
        float ti2;
        float ti1;
        float tr2;
        float tr1;
        float tr4;
        float tr3;
        int t5;
        int t4;
        float sqrt2 = 1.4142135f;
        int t0 = l1 * ido;
        int t1 = 0;
        int t2 = ido << 2;
        int t3 = 0;
        int t6 = ido << 1;
        int k = 0;
        while (k < l1) {
            t4 = t3 + t6;
            t5 = t1;
            tr3 = cc[t4 - 1] + cc[t4 - 1];
            tr4 = cc[t4] + cc[t4];
            tr1 = cc[t3] - cc[(t4 += t6) - 1];
            tr2 = cc[t3] + cc[t4 - 1];
            ch[t5] = tr2 + tr3;
            ch[t5 += t0] = tr1 - tr4;
            ch[t5 += t0] = tr2 - tr3;
            ch[t5 += t0] = tr1 + tr4;
            t1 += ido;
            t3 += t2;
            ++k;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            t1 = 0;
            k = 0;
            while (k < l1) {
                t2 = t1 << 2;
                t4 = t3 = t2 + t6;
                t5 = t3 + t6;
                int t7 = t1;
                int i = 2;
                while (i < ido) {
                    t7 += 2;
                    ti1 = cc[t2 += 2] + cc[t5 -= 2];
                    ti2 = cc[t2] - cc[t5];
                    float ti3 = cc[t3 += 2] - cc[t4 -= 2];
                    tr4 = cc[t3] + cc[t4];
                    tr1 = cc[t2 - 1] - cc[t5 - 1];
                    tr2 = cc[t2 - 1] + cc[t5 - 1];
                    float ti4 = cc[t3 - 1] - cc[t4 - 1];
                    tr3 = cc[t3 - 1] + cc[t4 - 1];
                    ch[t7 - 1] = tr2 + tr3;
                    float cr3 = tr2 - tr3;
                    ch[t7] = ti2 + ti3;
                    float ci3 = ti2 - ti3;
                    float cr2 = tr1 - tr4;
                    float cr4 = tr1 + tr4;
                    float ci2 = ti1 + ti4;
                    float ci4 = ti1 - ti4;
                    int t8 = t7 + t0;
                    ch[t8 - 1] = wa[wa1 + i - 2] * cr2 - wa[wa1 + i - 1] * ci2;
                    ch[t8] = wa[wa1 + i - 2] * ci2 + wa[wa1 + i - 1] * cr2;
                    ch[(t8 += t0) - 1] = wa[wa2 + i - 2] * cr3 - wa[wa2 + i - 1] * ci3;
                    ch[t8] = wa[wa2 + i - 2] * ci3 + wa[wa2 + i - 1] * cr3;
                    ch[(t8 += t0) - 1] = wa[wa3 + i - 2] * cr4 - wa[wa3 + i - 1] * ci4;
                    ch[t8] = wa[wa3 + i - 2] * ci4 + wa[wa3 + i - 1] * cr4;
                    i += 2;
                }
                t1 += ido;
                ++k;
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        t1 = ido;
        t2 = ido << 2;
        t3 = ido - 1;
        t4 = ido + (ido << 1);
        k = 0;
        while (k < l1) {
            t5 = t3;
            ti1 = cc[t1] + cc[t4];
            ti2 = cc[t4] - cc[t1];
            tr1 = cc[t1 - 1] - cc[t4 - 1];
            tr2 = cc[t1 - 1] + cc[t4 - 1];
            ch[t5] = tr2 + tr2;
            ch[t5 += t0] = sqrt2 * (tr1 - ti1);
            ch[t5 += t0] = ti2 + ti2;
            ch[t5 += t0] = -sqrt2 * (tr1 + ti1);
            t3 += ido;
            t1 += t2;
            t4 += t2;
            ++k;
        }
    }

    static void dradbg(int ido, int ip, int l1, int idl1, float[] cc, float[] c1, float[] c2, float[] ch, float[] ch2, float[] wa, int waoff) {
        int ik;
        int t12;
        int t11;
        int t9;
        int t8;
        int t6;
        int t5;
        int t4;
        int k;
        int t3;
        int t2;
        int i;
        int t1;
        float tpi = (float)Math.PI * 2;
        int t10 = ip * ido;
        int t0 = l1 * ido;
        float arg = tpi / new Integer(ip).floatValue();
        float dcp = new Double(Math.cos(arg)).floatValue();
        float dsp = new Double(Math.sin(arg)).floatValue();
        int nbd = ido - 1 >> 1;
        int ipp2 = ip;
        int ipph = ip + 1 >> 1;
        if (ido < l1) {
            t1 = 0;
            i = 0;
            while (i < ido) {
                t2 = t1;
                t3 = t1;
                k = 0;
                while (k < l1) {
                    ch[t2] = cc[t3];
                    t2 += ido;
                    t3 += t10;
                    ++k;
                }
                ++t1;
                ++i;
            }
        } else {
            t1 = 0;
            t2 = 0;
            k = 0;
            while (k < l1) {
                t3 = t1;
                t4 = t2;
                i = 0;
                while (i < ido) {
                    ch[t3] = cc[t4];
                    ++t3;
                    ++t4;
                    ++i;
                }
                t1 += ido;
                t2 += t10;
                ++k;
            }
        }
        t1 = 0;
        t2 = ipp2 * t0;
        int t7 = t5 = ido << 1;
        int j = 1;
        while (j < ipph) {
            t3 = t1 += t0;
            t4 = t2 -= t0;
            t6 = t5;
            k = 0;
            while (k < l1) {
                ch[t3] = cc[t6 - 1] + cc[t6 - 1];
                ch[t4] = cc[t6] + cc[t6];
                t3 += ido;
                t4 += ido;
                t6 += t10;
                ++k;
            }
            t5 += t7;
            ++j;
        }
        if (ido != 1) {
            if (nbd < l1) {
                t1 = 0;
                t2 = ipp2 * t0;
                t7 = 0;
                j = 1;
                while (j < ipph) {
                    t3 = t1 += t0;
                    t4 = t2 -= t0;
                    t8 = t7 += ido << 1;
                    t9 = t7;
                    i = 2;
                    while (i < ido) {
                        t5 = t3 += 2;
                        t6 = t4 += 2;
                        t11 = t8 += 2;
                        t12 = t9 -= 2;
                        k = 0;
                        while (k < l1) {
                            ch[t5 - 1] = cc[t11 - 1] + cc[t12 - 1];
                            ch[t6 - 1] = cc[t11 - 1] - cc[t12 - 1];
                            ch[t5] = cc[t11] - cc[t12];
                            ch[t6] = cc[t11] + cc[t12];
                            t5 += ido;
                            t6 += ido;
                            t11 += t10;
                            t12 += t10;
                            ++k;
                        }
                        i += 2;
                    }
                    ++j;
                }
            } else {
                t1 = 0;
                t2 = ipp2 * t0;
                t7 = 0;
                j = 1;
                while (j < ipph) {
                    t3 = t1 += t0;
                    t4 = t2 -= t0;
                    t8 = t7 += ido << 1;
                    k = 0;
                    while (k < l1) {
                        t5 = t3;
                        t6 = t4;
                        t9 = t8;
                        t11 = t8;
                        i = 2;
                        while (i < ido) {
                            ch[(t5 += 2) - 1] = cc[(t9 += 2) - 1] + cc[(t11 -= 2) - 1];
                            ch[(t6 += 2) - 1] = cc[t9 - 1] - cc[t11 - 1];
                            ch[t5] = cc[t9] - cc[t11];
                            ch[t6] = cc[t9] + cc[t11];
                            i += 2;
                        }
                        t3 += ido;
                        t4 += ido;
                        t8 += t10;
                        ++k;
                    }
                    ++j;
                }
            }
        }
        float ar1 = 1.0f;
        float ai1 = 0.0f;
        t1 = 0;
        t9 = t2 = ipp2 * idl1;
        t3 = (ip - 1) * idl1;
        int l = 1;
        while (l < ipph) {
            float ar1h = dcp * ar1 - dsp * ai1;
            ai1 = dcp * ai1 + dsp * ar1;
            ar1 = ar1h;
            t4 = t1 += idl1;
            t5 = t2 -= idl1;
            t6 = 0;
            t7 = idl1;
            t8 = t3;
            ik = 0;
            while (ik < idl1) {
                c2[t4++] = ch2[t6++] + ar1 * ch2[t7++];
                c2[t5++] = ai1 * ch2[t8++];
                ++ik;
            }
            float dc2 = ar1;
            float ds2 = ai1;
            float ar2 = ar1;
            float ai2 = ai1;
            t6 = idl1;
            t7 = t9 - idl1;
            j = 2;
            while (j < ipph) {
                t6 += idl1;
                t7 -= idl1;
                float ar2h = dc2 * ar2 - ds2 * ai2;
                ai2 = dc2 * ai2 + ds2 * ar2;
                ar2 = ar2h;
                t4 = t1;
                t5 = t2;
                t11 = t6;
                t12 = t7;
                ik = 0;
                while (ik < idl1) {
                    int n = t4++;
                    c2[n] = c2[n] + ar2 * ch2[t11++];
                    int n2 = t5++;
                    c2[n2] = c2[n2] + ai2 * ch2[t12++];
                    ++ik;
                }
                ++j;
            }
            ++l;
        }
        t1 = 0;
        j = 1;
        while (j < ipph) {
            t2 = t1 += idl1;
            ik = 0;
            while (ik < idl1) {
                int n = ik++;
                ch2[n] = ch2[n] + ch2[t2++];
            }
            ++j;
        }
        t1 = 0;
        t2 = ipp2 * t0;
        j = 1;
        while (j < ipph) {
            t3 = t1 += t0;
            t4 = t2 -= t0;
            k = 0;
            while (k < l1) {
                ch[t3] = c1[t3] - c1[t4];
                ch[t4] = c1[t3] + c1[t4];
                t3 += ido;
                t4 += ido;
                ++k;
            }
            ++j;
        }
        if (ido != 1) {
            if (nbd < l1) {
                t1 = 0;
                t2 = ipp2 * t0;
                j = 1;
                while (j < ipph) {
                    t3 = t1 += t0;
                    t4 = t2 -= t0;
                    i = 2;
                    while (i < ido) {
                        t5 = t3 += 2;
                        t6 = t4 += 2;
                        k = 0;
                        while (k < l1) {
                            ch[t5 - 1] = c1[t5 - 1] - c1[t6];
                            ch[t6 - 1] = c1[t5 - 1] + c1[t6];
                            ch[t5] = c1[t5] + c1[t6 - 1];
                            ch[t6] = c1[t5] - c1[t6 - 1];
                            t5 += ido;
                            t6 += ido;
                            ++k;
                        }
                        i += 2;
                    }
                    ++j;
                }
            } else {
                t1 = 0;
                t2 = ipp2 * t0;
                j = 1;
                while (j < ipph) {
                    t3 = t1 += t0;
                    t4 = t2 -= t0;
                    k = 0;
                    while (k < l1) {
                        t5 = t3;
                        t6 = t4;
                        i = 2;
                        while (i < ido) {
                            ch[(t5 += 2) - 1] = c1[t5 - 1] - c1[t6 += 2];
                            ch[t6 - 1] = c1[t5 - 1] + c1[t6];
                            ch[t5] = c1[t5] + c1[t6 - 1];
                            ch[t6] = c1[t5] - c1[t6 - 1];
                            i += 2;
                        }
                        t3 += ido;
                        t4 += ido;
                        ++k;
                    }
                    ++j;
                }
            }
        }
        if (ido == 1) {
            return;
        }
        ik = 0;
        while (ik < idl1) {
            c2[ik] = ch2[ik];
            ++ik;
        }
        t1 = 0;
        j = 1;
        while (j < ip) {
            t2 = t1 += t0;
            k = 0;
            while (k < l1) {
                c1[t2] = ch[t2];
                t2 += ido;
                ++k;
            }
            ++j;
        }
        if (nbd > l1) {
            int is = -ido - 1;
            t1 = 0;
            j = 1;
            while (j < ip) {
                is += ido;
                t2 = t1 += t0;
                k = 0;
                while (k < l1) {
                    int idij = is;
                    t3 = t2;
                    i = 2;
                    while (i < ido) {
                        c1[(t3 += 2) - 1] = wa[waoff + (idij += 2) - 1] * ch[t3 - 1] - wa[waoff + idij] * ch[t3];
                        c1[t3] = wa[waoff + idij - 1] * ch[t3] + wa[waoff + idij] * ch[t3 - 1];
                        i += 2;
                    }
                    t2 += ido;
                    ++k;
                }
                ++j;
            }
        } else {
            int is = -ido - 1;
            t1 = 0;
            j = 1;
            while (j < ip) {
                int idij = is += ido;
                t2 = t1 += t0;
                i = 2;
                while (i < ido) {
                    idij += 2;
                    t3 = t2 += 2;
                    k = 0;
                    while (k < l1) {
                        c1[t3 - 1] = wa[waoff + idij - 1] * ch[t3 - 1] - wa[waoff + idij] * ch[t3];
                        c1[t3] = wa[waoff + idij - 1] * ch[t3] + wa[waoff + idij] * ch[t3 - 1];
                        t3 += ido;
                        ++k;
                    }
                    i += 2;
                }
                ++j;
            }
        }
    }
}

