/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis;

import java.util.Arrays;
import org.xiph.libvorbis.codebook;
import org.xiph.libvorbis.codec_setup_info;
import org.xiph.libvorbis.static_codebook;
import org.xiph.libvorbis.vorbis_block;
import org.xiph.libvorbis.vorbis_comment;
import org.xiph.libvorbis.vorbis_constants.integer_constants;
import org.xiph.libvorbis.vorbis_info;
import org.xiph.libvorbis.vorbis_info_floor1;
import org.xiph.libvorbis.vorbis_info_mapping0;
import org.xiph.libvorbis.vorbis_info_residue0;
import org.xiph.libvorbis.vorbis_look_floor1;

class oggpack_buffer {
    int endbyte;
    int endbit;
    byte[] buffer = new byte[256];
    int ptr = 0;
    int storage;
    static int[] mask;
    static int seq;

    static {
        int[] nArray = new int[33];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        nArray[17] = 131071;
        nArray[18] = 262143;
        nArray[19] = 524287;
        nArray[20] = 1048575;
        nArray[21] = 0x1FFFFF;
        nArray[22] = 0x3FFFFF;
        nArray[23] = 0x7FFFFF;
        nArray[24] = 0xFFFFFF;
        nArray[25] = 0x1FFFFFF;
        nArray[26] = 0x3FFFFFF;
        nArray[27] = 0x7FFFFFF;
        nArray[28] = 0xFFFFFFF;
        nArray[29] = 0x1FFFFFFF;
        nArray[30] = 0x3FFFFFFF;
        nArray[31] = Integer.MAX_VALUE;
        nArray[32] = -1;
        mask = nArray;
        seq = 0;
    }

    public oggpack_buffer() {
        this.buffer[0] = 0;
        this.storage = 256;
    }

    public void oggpack_reset() {
        this.ptr = 0;
        this.buffer[0] = 0;
        this.endbit = 0;
        this.endbyte = 0;
    }

    public int oggpack_bytes() {
        return this.endbyte + (this.endbit + 7) / 8;
    }

    public int oggpack_bits() {
        return this.endbyte * 8 + this.endbit;
    }

    public void oggpack_write(int value8, int bits) {
        if (this.endbyte + 4 >= this.storage) {
            this.storage += 256;
            byte[] temp = new byte[this.storage];
            System.arraycopy(this.buffer, 0, temp, 0, this.buffer.length);
            this.buffer = temp;
            this.ptr = this.endbyte;
        }
        value8 &= mask[bits];
        int n = this.ptr;
        this.buffer[n] = (byte)(this.buffer[n] | value8 << this.endbit);
        if ((bits += this.endbit) >= 8) {
            this.buffer[this.ptr + 1] = (byte)(value8 >>> 8 - this.endbit);
            if (bits >= 16) {
                this.buffer[this.ptr + 2] = (byte)(value8 >>> 16 - this.endbit);
                if (bits >= 24) {
                    this.buffer[this.ptr + 3] = (byte)(value8 >>> 24 - this.endbit);
                    if (bits >= 32) {
                        this.buffer[this.ptr + 4] = this.endbit != 0 ? (byte)(value8 >>> 32 - this.endbit) : (byte)0;
                    }
                }
            }
        }
        this.endbyte += bits / 8;
        this.ptr += bits / 8;
        this.endbit = bits & 7;
    }

    public void oggpack_writetrunc(int bits) {
        int bytes = bits >> 3;
        this.ptr = bytes;
        this.endbit = bits -= bytes * 8;
        this.endbyte = bytes;
        this.buffer[this.ptr] = (byte)mask[bits];
    }

    public void _v_writestring(String s, int bytes) {
        int i = 0;
        while (i < bytes) {
            this.oggpack_write(s.charAt(i), 8);
            ++i;
        }
    }

    public void _v_writestring(byte[] s, int bytes) {
        int i = 0;
        while (i < bytes) {
            this.oggpack_write(s[i], 8);
            ++i;
        }
    }

    public boolean _vorbis_pack_info(vorbis_info vi) {
        codec_setup_info ci = vi.codec_setup;
        if (ci == null) {
            return false;
        }
        this.oggpack_write(1, 8);
        this._v_writestring("vorbis", 6);
        this.oggpack_write(0, 32);
        this.oggpack_write(vi.channels, 8);
        this.oggpack_write(vi.rate, 32);
        this.oggpack_write(vi.bitrate_upper, 32);
        this.oggpack_write(vi.bitrate_nominal, 32);
        this.oggpack_write(vi.bitrate_lower, 32);
        this.oggpack_write(integer_constants.ilog2(ci.blocksizes[0]), 4);
        this.oggpack_write(integer_constants.ilog2(ci.blocksizes[1]), 4);
        this.oggpack_write(1, 1);
        return true;
    }

    public boolean _vorbis_pack_comment(vorbis_comment vc) {
        String temp = "Xiph.Org libVorbis I 20030909";
        int bytes = temp.length();
        this.oggpack_write(3, 8);
        this._v_writestring("vorbis", 6);
        this.oggpack_write(bytes, 32);
        this._v_writestring(temp, bytes);
        this.oggpack_write(vc.comments, 32);
        if (vc.comments > 0) {
            int i = 0;
            while (i < vc.comments) {
                if (vc.user_comments[i] != null) {
                    this.oggpack_write(vc.comment_lengths[i], 32);
                    this._v_writestring(vc.user_comments[i], vc.comment_lengths[i]);
                } else {
                    this.oggpack_write(0, 32);
                }
                ++i;
            }
        }
        this.oggpack_write(1, 1);
        return true;
    }

    public boolean _vorbis_pack_books(vorbis_info vi) {
        codec_setup_info ci = vi.codec_setup;
        if (ci == null) {
            return false;
        }
        this.oggpack_write(5, 8);
        this._v_writestring("vorbis", 6);
        this.oggpack_write(ci.books - 1, 8);
        int i = 0;
        while (i < ci.books) {
            if (!this.vorbis_staticbook_pack(ci.book_param[i])) {
                return false;
            }
            ++i;
        }
        this.oggpack_write(0, 6);
        this.oggpack_write(0, 16);
        this.oggpack_write(ci.floors - 1, 6);
        i = 0;
        while (i < ci.floors) {
            this.oggpack_write(ci.floor_type[i], 16);
            this.floor1_pack(ci.floor_param[i]);
            ++i;
        }
        this.oggpack_write(ci.residues - 1, 6);
        i = 0;
        while (i < ci.residues) {
            this.oggpack_write(ci.residue_type[i], 16);
            this.res0_pack(ci.residue_param[i]);
            ++i;
        }
        this.oggpack_write(ci.maps - 1, 6);
        i = 0;
        while (i < ci.maps) {
            this.oggpack_write(ci.map_type[i], 16);
            this.mapping0_pack(vi, ci.map_param[i]);
            ++i;
        }
        this.oggpack_write(ci.modes - 1, 6);
        i = 0;
        while (i < ci.modes) {
            this.oggpack_write(ci.mode_param[i].blockflag, 1);
            this.oggpack_write(ci.mode_param[i].windowtype, 16);
            this.oggpack_write(ci.mode_param[i].transformtype, 16);
            this.oggpack_write(ci.mode_param[i].mapping, 8);
            ++i;
        }
        this.oggpack_write(1, 1);
        return true;
    }

    public boolean vorbis_staticbook_pack(static_codebook c) {
        boolean ordered = false;
        this.oggpack_write(5653314, 24);
        this.oggpack_write(c.dim, 16);
        this.oggpack_write(c.entries, 24);
        int i = 1;
        while (i < c.entries) {
            if (c.lengthlist[i - 1] == 0 || c.lengthlist[i] < c.lengthlist[i - 1]) break;
            ++i;
        }
        if (i == c.entries) {
            ordered = true;
        }
        if (ordered) {
            int count = 0;
            this.oggpack_write(1, 1);
            this.oggpack_write(c.lengthlist[0] - 1, 5);
            i = 1;
            while (i < c.entries) {
                int current = c.lengthlist[i];
                int last = c.lengthlist[i - 1];
                if (current > last) {
                    int j = last;
                    while (j < current) {
                        this.oggpack_write(i - count, integer_constants.ilog(c.entries - count));
                        count = i;
                        ++j;
                    }
                }
                ++i;
            }
            this.oggpack_write(i - count, integer_constants.ilog(c.entries - count));
        } else {
            this.oggpack_write(0, 1);
            i = 0;
            while (i < c.entries) {
                if (c.lengthlist[i] == 0) break;
                ++i;
            }
            if (i == c.entries) {
                this.oggpack_write(0, 1);
                i = 0;
                while (i < c.entries) {
                    this.oggpack_write(c.lengthlist[i] - 1, 5);
                    ++i;
                }
            } else {
                this.oggpack_write(1, 1);
                i = 0;
                while (i < c.entries) {
                    if (c.lengthlist[i] == 0) {
                        this.oggpack_write(0, 1);
                    } else {
                        this.oggpack_write(1, 1);
                        this.oggpack_write(c.lengthlist[i] - 1, 5);
                    }
                    ++i;
                }
            }
        }
        this.oggpack_write(c.maptype, 4);
        switch (c.maptype) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                int quantvals;
                if (c.quantlist == null) {
                    System.out.println("no quantlist exists");
                    return false;
                }
                this.oggpack_write(c.q_min, 32);
                this.oggpack_write(c.q_delta, 32);
                this.oggpack_write(c.q_quant - 1, 4);
                this.oggpack_write(c.q_sequencep, 1);
                switch (c.maptype) {
                    case 1: {
                        quantvals = c._book_maptype1_quantvals();
                        break;
                    }
                    case 2: {
                        quantvals = c.entries * c.dim;
                        break;
                    }
                    default: {
                        quantvals = -1;
                    }
                }
                i = 0;
                while (i < quantvals) {
                    this.oggpack_write(Math.abs(c.quantlist[i]), c.q_quant);
                    ++i;
                }
                break;
            }
            default: {
                System.out.println("error case; we don't have any other map types now");
                return false;
            }
        }
        return true;
    }

    public int vorbis_book_encode(codebook book, int a) {
        this.oggpack_write(book.codelist[a], book.c.lengthlist[a]);
        return book.c.lengthlist[a];
    }

    public void floor1_pack(vorbis_info_floor1 info) {
        int k;
        int count = 0;
        int maxposit = info.postlist[1];
        int maxclass = -1;
        this.oggpack_write(info.partitions, 5);
        int j = 0;
        while (j < info.partitions) {
            this.oggpack_write(info.partitionclass[j], 4);
            if (maxclass < info.partitionclass[j]) {
                maxclass = info.partitionclass[j];
            }
            ++j;
        }
        j = 0;
        while (j < maxclass + 1) {
            this.oggpack_write(info.class_dim[j] - 1, 3);
            this.oggpack_write(info.class_subs[j], 2);
            if (info.class_subs[j] > 0) {
                this.oggpack_write(info.class_book[j], 8);
            }
            k = 0;
            while (k < 1 << info.class_subs[j]) {
                this.oggpack_write(info.class_subbook[j][k] + 1, 8);
                ++k;
            }
            ++j;
        }
        this.oggpack_write(info.mult - 1, 2);
        this.oggpack_write(integer_constants.ilog2(maxposit), 4);
        int rangebits = integer_constants.ilog2(maxposit);
        j = 0;
        k = 0;
        while (j < info.partitions) {
            count += info.class_dim[info.partitionclass[j]];
            while (k < count) {
                this.oggpack_write(info.postlist[k + 2], rangebits);
                ++k;
            }
            ++j;
        }
    }

    public int floor1_encode(vorbis_block vb, vorbis_look_floor1 look, int[] post, int[] ilogmask) {
        vorbis_info_floor1 info = look.vi;
        int posts = look.posts;
        codec_setup_info ci = vb.vd.vi.codec_setup;
        int[] out = new int[65];
        static_codebook[] sbooks = ci.book_param;
        codebook[] books = ci.fullbooks;
        if (post != null) {
            int i = 0;
            while (i < posts) {
                int val = post[i] & Short.MAX_VALUE;
                switch (info.mult) {
                    case 1: {
                        val >>= 2;
                        break;
                    }
                    case 2: {
                        val >>= 3;
                        break;
                    }
                    case 3: {
                        val /= 12;
                        break;
                    }
                    case 4: {
                        val >>= 4;
                    }
                }
                post[i] = val | post[i] & 0x8000;
                ++i;
            }
            out[0] = post[0];
            out[1] = post[1];
            i = 2;
            while (i < posts) {
                int ln = look.loneighbor[i - 2];
                int hn = look.hineighbor[i - 2];
                int x0 = info.postlist[ln];
                int x1 = info.postlist[hn];
                int y0 = post[ln];
                int y1 = post[hn];
                int predicted = integer_constants.render_point(x0, x1, y0, y1, info.postlist[i]);
                if ((post[i] & 0x8000) > 0 || predicted == post[i]) {
                    post[i] = predicted | 0x8000;
                    out[i] = 0;
                } else {
                    int headroom = look.quant_q - predicted < predicted ? look.quant_q - predicted : predicted;
                    int val = post[i] - predicted;
                    val = val < 0 ? (val < -headroom ? headroom - val - 1 : -1 - (val << 1)) : (val >= headroom ? (val += headroom) : (val <<= 1));
                    out[i] = val;
                    int n = ln;
                    post[n] = post[n] & Short.MAX_VALUE;
                    int n2 = hn;
                    post[n2] = post[n2] & Short.MAX_VALUE;
                }
                ++i;
            }
            this.oggpack_write(1, 1);
            ++look.frames;
            look.postbits += integer_constants.ilog(look.quant_q - 1) * 2;
            this.oggpack_write(out[0], integer_constants.ilog(look.quant_q - 1));
            this.oggpack_write(out[1], integer_constants.ilog(look.quant_q - 1));
            i = 0;
            int j = 2;
            while (i < info.partitions) {
                int k;
                int class_local = info.partitionclass[i];
                int cdim = info.class_dim[class_local];
                int csubbits = info.class_subs[class_local];
                int csub = 1 << csubbits;
                int[] bookas = new int[8];
                int cval = 0;
                int cshift = 0;
                if (csubbits > 0) {
                    int[] maxval = new int[8];
                    k = 0;
                    while (k < csub) {
                        int booknum = info.class_subbook[class_local][k];
                        maxval[k] = booknum < 0 ? 1 : sbooks[info.class_subbook[class_local][k]].entries;
                        ++k;
                    }
                    k = 0;
                    while (k < cdim) {
                        int l = 0;
                        while (l < csub) {
                            int val = out[j + k];
                            if (val < maxval[l]) {
                                bookas[k] = l;
                                break;
                            }
                            ++l;
                        }
                        cval |= bookas[k] << cshift;
                        cshift += csubbits;
                        ++k;
                    }
                    look.phrasebits += this.vorbis_book_encode(books[info.class_book[class_local]], cval);
                }
                k = 0;
                while (k < cdim) {
                    int book = info.class_subbook[class_local][bookas[k]];
                    if (book >= 0 && out[j + k] < books[book].entries) {
                        look.postbits += this.vorbis_book_encode(books[book], out[j + k]);
                    }
                    ++k;
                }
                j += cdim;
                ++i;
            }
            int hx = 0;
            int lx = 0;
            int ly = post[0] * info.mult;
            j = 1;
            while (j < look.posts) {
                int current = look.forward_index[j];
                int hy = post[current] & Short.MAX_VALUE;
                if (hy == post[current]) {
                    hx = info.postlist[current];
                    integer_constants.render_line0(lx, hx, ly, hy *= info.mult, ilogmask);
                    lx = hx;
                    ly = hy;
                }
                ++j;
            }
            j = hx;
            while (j < vb.pcmend / 2) {
                ilogmask[j] = ly;
                ++j;
            }
            ++seq;
            return 1;
        }
        this.oggpack_write(0, 1);
        Arrays.fill(ilogmask, 0, vb.pcmend / 2, 0);
        ++seq;
        return 0;
    }

    public void res0_pack(vorbis_info_residue0 info) {
        int acc = 0;
        this.oggpack_write(info.begin, 24);
        this.oggpack_write(info.end, 24);
        this.oggpack_write(info.grouping - 1, 24);
        this.oggpack_write(info.partitions - 1, 6);
        this.oggpack_write(info.groupbook, 8);
        int j = 0;
        while (j < info.partitions) {
            if (integer_constants.ilog(info.secondstages[j]) > 3) {
                this.oggpack_write(info.secondstages[j], 3);
                this.oggpack_write(1, 1);
                this.oggpack_write(info.secondstages[j] >> 3, 5);
            } else {
                this.oggpack_write(info.secondstages[j], 4);
            }
            acc += integer_constants.icount(info.secondstages[j]);
            ++j;
        }
        j = 0;
        while (j < acc) {
            this.oggpack_write(info.booklist[j], 8);
            ++j;
        }
    }

    public void mapping0_pack(vorbis_info vi, vorbis_info_mapping0 info) {
        int i;
        if (info.submaps > 1) {
            this.oggpack_write(1, 1);
            this.oggpack_write(info.submaps - 1, 4);
        } else {
            this.oggpack_write(0, 1);
        }
        if (info.coupling_steps > 0) {
            this.oggpack_write(1, 1);
            this.oggpack_write(info.coupling_steps - 1, 8);
            i = 0;
            while (i < info.coupling_steps) {
                this.oggpack_write(info.coupling_mag[i], integer_constants.ilog2(vi.channels));
                this.oggpack_write(info.coupling_ang[i], integer_constants.ilog2(vi.channels));
                ++i;
            }
        } else {
            this.oggpack_write(0, 1);
        }
        this.oggpack_write(0, 2);
        if (info.submaps > 1) {
            i = 0;
            while (i < vi.channels) {
                this.oggpack_write(info.chmuxlist[i], 4);
                ++i;
            }
        }
        i = 0;
        while (i < info.submaps) {
            this.oggpack_write(0, 8);
            this.oggpack_write(info.floorsubmap[i], 8);
            this.oggpack_write(info.residuesubmap[i], 8);
            ++i;
        }
    }
}

