/* normal image */
uniform sampler2D texunit0;
/* blurred image*/
uniform sampler2D texunit1;
/*depth values*/
uniform sampler2D texunit2;
uniform float near;
uniform float focus;
uniform float far;
varying vec2 texcoord;

void main()
{
	float f;
	float depth = texture2D(texunit2, texcoord).r;
	if(depth < focus)
	{
		f = 1.0 - clamp((depth - near) / (focus - near), 0.0, 1.0);
	} 
	else 
	{
		f = clamp((depth - focus) / (far - focus), 0.0, 1.0); 
	}
	vec4 norm = texture2D(texunit0, texcoord) * (1.0 - f);
	vec4 blurred = texture2D(texunit1, texcoord) * f;
	gl_FragColor = blurred+norm;
}