#define vec vec3
#define tovec(v) (v).rgb

#define m2(a, b) t = a; a = min(t, b); b = max(t, b);
#define m3(a, b, c) m2(b, c); m2(a, c); m2(a, b);
#define m4(a, b, c, d) m2(a, b); m2(c, d); m2(a, c); m2(b, d);
#define m5(a, b, c, d, e, f) m2(a, b); m2(c, d); m2(a, c); m2(a, e); m2(d, e); m2(b, e);
#define m6(a, b, c, d, e, f, g) m2(a, d); m2(b, e); m2(c, f); m2(a, b); m2(a, c); m2(e, f); m2(d, f);

uniform sampler2D src;

void main() {
  vec v[9], t, d;
  
  for(int dx = -1; dx <= 1; ++dx)
    for(int dy = -1; dy <= 1; ++dy)
      v[dx * 3 + dy * 4] = tovec(texture2D(src, gl_TexCoord[0].xy + vec2(float(dx)/width, float(dy)/height)));
     
  m6(v[0], v[1], v[2], v[3], v[4], v[5]);
  m5(v[1], v[2], v[3], v[4], v[6]);
  m4(v[2], v[3], v[4], v[7]);
  m3(v[3], v[4], v[8]);
  tovec(gl_FragColor) = v[4];
}