texture g_txScene;
sampler2D g_samScene = sampler_state {
    Texture = <g_txScene>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

void PassThrough( float4 Pos : POSITION,
                  float2 Tex : TEXCOORD0,
                  out float4 oPos : POSITION,
                  out float2 oTex : TEXCOORD0 ) {    
    // Pass through
    oPos = Pos;
    oTex = Tex;
}

//-----------------------------------------------------------------------------
// Outputs texture value witthout lighting calculation.  Used for fullscreen
// quad copy.
float4 PixNoLight( float2 Tex : TEXCOORD0 ) : COLOR {
    return tex2D( g_samScene, Tex );
}

technique RenderNoLight {
	pass p0 {
		AlphaBlendEnable = true;
    SrcBlend = SrcAlpha;
    DestBlend = InvSrcAlpha;
    CullMode = CCW;
    FillMode = Solid;
    FogEnable = False;
		VertexShader = compile vs_2_0 PassThrough();
		//VertexShader = null;
		PixelShader = compile ps_2_0 PixNoLight();
		ZEnable = false;
	}
}