uniform float dist_lev;
uniform float ptimer;

uniform sampler2D tex;
varying vec3 coord;

void main()
{
	vec2 test = gl_TexCoord[0].st;
	float t = ptimer / 256.0;

	float x = coord.x;
	float y = coord.y;

	test.s = test.s + dist_lev * sin((x+y+t) * 6.0) * 0.05;
	test.t = test.t + dist_lev * sin((x+2.0*y+1.5*t) * 4.0) * 0.05;

	vec4 color = texture2D(tex,test);
	color.a = 1.0 - dist_lev;

	gl_FragColor = color;
}
