varying vec3 coord;
uniform float ptimer;

void main()
{
	float x = coord.x;
	float y = coord.y;

	const float rad = 64.0;
	float z = sqrt(rad*rad + x*x + y*y);

	float u = (x / z) * rad;
	float v = (y / z) * rad;

	float sn = 0.0;
	const float n = 4.0;

	float t = ptimer / 256.0;

	for (float i=1.0; i<=n; i++)
		sn = sn + (sin((u + t) / (4.0 / i)) * (1.0 / i) + sin((v + 2.0 * t) / (6.0 / i)) * (1.25 / i) + sin((u + v + 2.5 * t) / (12.0 / i)) * (1.5 / i)) * 0.5;

	float c = mod(sn, 1.0);

	if (c<0.125) c = c * 8.0;
		else if (c<0.25) c = (0.25 - c) * 8.0;
			else c = 0.0;

	float r = c / 2.0;
	float g = c / 1.5;
	float b = 0.05 + c * 0.95;

	float a = 1.0 - z / 128.0;

	vec4 color = vec4(r, g, b, a);
	gl_FragColor = color;
}
