uniform float lx, ly, lz;
uniform float blurx, blury;
uniform float rmul, gmul, bmul;
uniform float amul;

uniform sampler2D tex;

void main()
{
	vec2 tc = gl_TexCoord[0].st;
	vec2 ftc;

	const float n = 2.0;

	float vx, vy, vz, va;
	float lc, phong, fl;

	const float phmul = 0.25;
	const float nphmul = 0.75;
	const float phlim = 64.0 * phmul;

	vec4 color = vec4(0.0, 0.0, 0.0, 0.0);

	for (float y=-n; y<=n; y++)
	{
		ftc.t = tc.t + y * blury;
		for (float x=-n; x<=n; x++)
		{
			ftc.s = tc.s + x * blurx;
			vec4 tp = texture2D(tex,ftc);

			vx = (tp.r - 0.5) * 2.0;
			vy = (tp.g - 0.5) * 2.0;
			vz = tp.b * 2.0;
			va = tp.a;

			lc = (vx*lx + vy*ly + vz*lz);

			phong = 0.25 / ((vx - lx) * (vx - lx) + (vy - ly) * (vy - ly) + (vz - lz) * (vz - lz));
			if (phong > phlim) phong = phlim;
			fl = (nphmul * lc + phmul * phong) * va;

			color.r = color.r + rmul * fl;
			color.g = color.g + gmul * fl;
			color.b = color.b + bmul * fl;
			color.a = color.a + va;
		}
	}

	float nn = 4.0 * n * n + 1.0;
	color.r = color.r / nn;
	color.g = color.g / nn;
	color.b = color.b / nn;
	color.a = (color.a / nn) * amul;

	gl_FragColor = color;
}
