
varying vec3 normal;
varying float fogFactor;

uniform sampler2D tex;
uniform float bri;

void main() {
	vec2 tc = 0.5+0.5*normal.xy;
	vec4 texCol = texture2D(tex, tc);

	vec4 col = gl_Color*texCol*bri;
	col.a *= 0.25;

	float  fogFactor = clamp((gl_Fog.end-gl_FogFragCoord)*gl_Fog.scale, 0.0, 1.0);
	col = mix(gl_Fog.color, col, fogFactor);

	gl_FragColor = col;
}
