
uniform vec3 lightpos;

varying float fogFactor;
varying vec3 opos;
varying vec3 eye;
varying vec3 lightDir;
varying vec3 lightDirOrig;
varying vec3 normal;

void main() {
	gl_TexCoord[0] = gl_TextureMatrix[0]*gl_MultiTexCoord0;


	vec4 tangent = vec4(gl_MultiTexCoord7);

	vec3 n = normalize(gl_NormalMatrix*gl_Normal);
	vec3 t = normalize(gl_NormalMatrix*tangent.xyz);
	vec3 b = cross(n, t)*tangent.a;

	vec4 pos = gl_ModelViewMatrix*gl_Vertex;

//	camdot = 1.0-dot(n, normalize(-pos.xyz));

	//vec3 tmpVec = gl_LightSource[0].position.xyz-pos.xyz;
	vec3 tmpVec = lightpos-pos.xyz;
	lightDirOrig = tmpVec;
	lightDir.x = dot(tmpVec, t);
	lightDir.y = dot(tmpVec, b);
	lightDir.z = dot(tmpVec, n);

	tmpVec = -pos.xyz;
	eye.x = dot(tmpVec, t);
	eye.y = dot(tmpVec, b);
	eye.z = dot(tmpVec, n);

	normal = n;

	gl_Position = ftransform();

	opos = gl_Vertex.xyz;

	gl_FogFragCoord = length(pos.xyz);
	fogFactor = clamp((gl_Fog.end-gl_FogFragCoord)*gl_Fog.scale, 0.0, 1.0);
}