

uniform sampler2D colortex;
uniform float radiusx;
uniform float radiusy;
uniform float scale;
uniform float bias;
uniform float cthru;
uniform vec3 color; 

void main(void) {
  vec3 a, b, c, d;
  float dif, bw;
  vec3 final;

  a = texture2D(colortex, vec2(clamp(gl_TexCoord[0].x-radiusx, radiusx, 1.0), gl_TexCoord[0].y)).rgb;
  b = texture2D(colortex, vec2(gl_TexCoord[0].x, clamp(gl_TexCoord[0].y-radiusy, radiusy, 1.0))).rgb;
  c = texture2D(colortex, vec2(clamp(gl_TexCoord[0].x-radiusx, radiusx, 1.0), clamp(gl_TexCoord[0].y-radiusy, radiusy, 1.0))).rgb;
  d = texture2D(colortex, gl_TexCoord[0].xy).rgb;

  dif = abs(d.r - a.r) + abs(d.g - a.g) + abs(d.b - a.b) +
        abs(d.r - b.r) + abs(d.g - b.g) + abs(d.b - b.b) +
        (abs(d.r - c.r) + abs(d.g - c.g) + abs(d.b - c.b)) * 0.5;
  bw = (d.r+d.b+d.g)*0.33334;

  dif = (dif + bias) * scale;
  final = mix(dif*color, d, cthru);

  gl_FragColor = vec4(final, 1.0);
}


