package mathematics.multidimensional.shape;

import javafx.scene.CustomNode;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.scene.transform.*;

import mathematics.multidimensional.*;

import javafx.scene.shape.Rectangle;

import javafx.util.Sequences;

import javafx.scene.shape.Circle;



public class MDUniverse extends CustomNode { //, MDGroup{

    public var dimension: Integer;
    
    public var projection: IMDTransform = MDProjection{ axes: [0..dimension-1]};
    
    var totalTransform: MDCustomSquareTransform =  MDCustomSquareTransform{ dim: dimension };


    public var shapes: MDShape[] ;
    
    public var mdtransforms: IMDSquareTransform[] =  MDIdentity{ dim: dimension }  on replace{
        mdtransform = MDTransform.mul(mdtransforms);
    };

    public var timeTransforms: IMDSquareTransform[] = MDIdentity{ dim: dimension }  on replace{
        timeTransform = MDTransform.mul(timeTransforms);
    };
    
    var timeTransform: IMDSquareTransform;
    var mdtransform: IMDSquareTransform;


    var points:MDPoint[];
    var segments:MDSegment[];

    var cashedPoints: MDPoint[];


    public function reset() {
        for(point in points){
            point.reset();
        }

        for(point in cashedPoints){
               point.reset();
        }
    }

    public function evolve() {
        //println("");
        //println("Evolve");
        //println("timeTransform: {timeTransform}");
        
        for(point in points){
               point.evolve(timeTransform, projection);
        }

        for(point in cashedPoints){
               point.evolve(timeTransform, projection);
        }
    }

    function getTotalTransform(transforms: IMDSquareTransform[]):IMDSquareTransform{
        totalTransform.transforms = mdtransforms;
        return totalTransform;
    }


    function getPoints():MDPoint[] {
        for(shape in shapes) [ shape.getPoints() ] ;
    }

    function getSegments():MDSegment[] {
        for(shape in shapes) [ shape.getSegments() ] ;
    }




    function cashPoints () {

        for(segment in segments){
            var point1 = getCashedPoint(segment.point1);
            var point2 = getCashedPoint(segment.point2);

            // var a = b; does not work for the equal objects
            segment.point1 = null;
            segment.point2 = null;

            segment.point1 = point1;
            segment.point2 = point2;


//            segment.point1 = getCashedPoint(segment.point1);
//            segment.point2 = getCashedPoint(segment.point2);
        }

        println("[universe] cashed points: {sizeof cashedPoints}");
    }

    protected function getCashedPoint(point:MDPoint):MDPoint{
        var index =  Sequences.indexOf(cashedPoints, point);
        if(-1 < index){
            return cashedPoints[index];
        }else{
            insert point into cashedPoints;
            //point.cashed = true;
            return point;
        }

    }


    

      function showSegments(){
              println("Segments");
              for(segment in segments){
                println("segment: {segment.point1}, {segment.point2}");
                println("segment: {segment.point1.evolved}, {segment.point2.evolved}");
                println("");   
              }

      }


    override function create ():Node {
        println("[universe] create");

        points =  getPoints();
        segments = getSegments();

        requestFocus();

        // evolve

        println("[universe] mdtransform: {mdtransform}");


        cashPoints();
        reset();
        //showSegments();
        //showSegments();


        //for(point in getPoints()){
//        for(point in points){
//            println("[universe] point: {point}");
//        }
//        System.out.println("[universe] getSegments()");
//        for(segment in  getSegments()) {
//            System.out.println("segment: {segment}");
//        }

        //var totalTransform = bind MDTransform.composite(mdtransforms, dimension);
        //update();

//        var totalTransform = bind MDCustomSquareTransform{
//            transforms: mdtransforms
//        }
        //var totalTransform = bind getTotalTransform(mdtransforms);

        Group{
            //focusTraversable: true
            transforms: [Scale{ x: 1 y: -1}]
            content: [
                Rectangle{
                    fill: Color.WHITE
                    width: 400
                    height: 400
                }

//                //for(point in getPoints()) Circle{
//                for(point in points) Circle{
//                    //var point2D = projection.transform(point);
//                    var point2D = bind projection.transform(totalTransform.transform(point));
//                    centerX: bind point2D.getElem(0)
//                    centerY: bind point2D.getElem(1)
//                    radius: 1
//                    fill: Color.BLACK
//                },
            //for(segment in  getSegments())
                for(point in points) Circle{
                    //var point2D = projection.transform(point);
                    //var point2D = bind projection.transform(totalTransform.transform(point));
                    centerX: bind point.x
                    centerY: bind point.y
                    radius: 1
                    fill: Color.BLACK
                },
            
            for(segment in segments)
                Line{
//                    var point1 = bind projection.transform(totalTransform.transform(segment.point1));
//                    var point2 = bind projection.transform(totalTransform.transform(segment.point2));
//                    startX: bind point1.getElem(0)
//                    startY: bind point1.getElem(1)
//                    endX: bind point2.getElem(0)
//                    endY: bind point2.getElem(1)

                    startX: bind segment.point1.x
                    startY: bind segment.point1.y
                    endX: bind segment.point2.x
                    endY: bind segment.point2.y

                    stroke: Color.BLACK
                }
            ]
        }
    } 

}
