/*
 * ElectronicComponent.fx
 *
 * Created on Aug 6, 2009, 5:46:59 PM
 */

package physics.electronic;

import javafx.scene.CustomNode;

//  ============  ElectronicComponent  ====================//

public abstract class ElectronicComponent extends CustomNode{

    public var name: String;

    public var pos: XY;
    public var compWidth:  Number = 20.0;
    public var compHeight: Number = 15.0;

    public var pin1: Pin;
    public var pin2: Pin;

    public abstract function simulate():Void;

    public  function switchLevels(){
      var level = pin1.level;
      pin1.level = pin2.level;
      pin2.level = level;
    }

}
