/*
 * FunctionSample.fx
 *
 * Created on 08.08.2009, 11:03:37
 */

package samples.mathematics;

/**
 * @author raindrop
 */

import javafx.stage.*;
import javafx.scene.*;
import javafx.scene.transform.*;

import java.lang.Math;

import mathematics.function.*;

function f(x:Number):Number{  10 * Math.sin( 2.5 * x) / (1 + x * x) }


var xMin = -10;
var xMax =  10;

var scale = 15;


Stage {
    title: "Function Graphic"
    scene: Scene {
        width: 400
        height: 400
        content: Group {
            transforms: [ Translate{ x: 200 y: 200}, Scale{ x: 1 y: -1 } ]
            content: [
                CoordinatsView{
                    xMin: xMin
                    xMax:  xMax
                    scale: 15
                    interval: 4
                }
                FunctionView{
                    xMin: xMin
                    xMax: xMax
                    scale: scale
                    func: f
                }
            ]
        }
    }
}
