texture diffuse : DiffuseMap;

sampler2D diffuseTexture = sampler_state {
    Texture = <diffuse>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

float alpha = 1.0f;

float4 PixNoLight( float2 Tex : TEXCOORD0 ) : COLOR {
	float4 diffuse = tex2D( diffuseTexture, Tex );		
  return float4( diffuse.rgb, alpha * diffuse.a );
}

technique Main {
	pass p0 {
		AlphaBlendEnable 	= True;
    SrcBlend 					= SrcAlpha;
    DestBlend 				= InvSrcAlpha;
    CullMode 					= CCW;
    FillMode 					= Solid;
    FogEnable 				= False;
		VertexShader 			= null;
		PixelShader 			= compile ps_2_0 PixNoLight();
		ZEnable 					= False;
		ZWriteEnable 			= False;
	}
}