texture g_txSrcColor;
texture g_txSrcNormal;
texture g_txSrcPosition;
texture g_txSrcVelocity;

texture g_txSceneColor;
texture g_txSceneNormal;
texture g_txScenePosition;
texture g_txSceneVelocity;

texture noiseTexture;

sampler2D g_samSrcColor = sampler_state {
	Texture 	= <g_txSrcColor>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcNormal = sampler_state {
	Texture 	= <g_txSrcNormal>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcPosition = sampler_state {
	Texture 	= <g_txSrcPosition>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSrcVelocity = sampler_state {
	Texture 	= <g_txSrcVelocity>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};

sampler2D g_samSceneColor = sampler_state {
	Texture 	= <g_txSceneColor>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSceneNormal = sampler_state {
	Texture 	= <g_txSceneNormal>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samScenePosition = sampler_state {
	Texture 	= <g_txScenePosition>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D g_samSceneVelocity = sampler_state {
	Texture 	= <g_txSceneVelocity>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};
sampler2D noiseSampler = sampler_state {
	Texture 	= <noiseTexture>;
	AddressU 	= Wrap;
	AddressV 	= Wrap;
	MinFilter = Point;
	MagFilter = Linear;
	MipFilter = Linear;
};

float Amount 	= 0.05f;
float Time 		= 0.0f;

float4 PostProcessPS( float2 Tex : TEXCOORD0 ) : COLOR0 {
	float3 color 	= (float3)tex2D( g_samSrcColor, Tex );
	float4 offset = tex2D( noiseSampler, Tex );
	float amount	= 0.01f;
	
	Tex.x += sin( offset.x * 10 ) * amount;
	Tex.y += sin( offset.y * 10 ) * amount;
	float3 bluephase = (float3)tex2D( g_samSrcColor, Tex );
	
	Tex.x -= sin( offset.x * 10 ) * amount * 2;
	Tex.y -= sin( offset.y * 10 ) * amount * 2;
	float3 greenphase = (float3)tex2D( g_samSrcColor, Tex );
	
	return float4( color.r, greenphase.g, bluephase.b, 1 );
}

float4 Linear( float2 Tex : TEXCOORD0 ) : COLOR0 {
	float2	index		= float2( Tex.y, Time );
	float4 	offset 	= tex2D( noiseSampler, index );
	
	Tex.x += offset.x * Amount;
	
	float2	redUV		= float2( Tex.x + offset.x * Amount * 0.75f, Tex.y );
	float2	greenUV = float2( Tex.x + offset.x * Amount * 0.5f, Tex.y );
	float2	blueUV 	= float2( Tex.x + offset.x * Amount * 1.0f, Tex.y );
	
	//float3 	color 	= (float3)tex2D( g_samSrcColor, Tex );
	
	float		red		= tex2D( g_samSrcColor, redUV 	).r;
	float 	green = tex2D( g_samSrcColor, greenUV ).g;
	float		blue 	= tex2D( g_samSrcColor, blueUV 	).b;
	
	//return float4( color, 1 );
	return float4( red, green, blue, 1 );
}

technique PostProcess<
	string Parameter0 = "Amount";
	float4 Parameter0Def = float4( 0.05, 0, 0, 0 );
	int 	 Parameter0Size = 1;
	string Parameter0Desc = " (float)";
	
	string Parameter1 = "Time";
	float4 Parameter1Def = float4( 0, 0, 0, 0 );
	int 	 Parameter1Size = 1;
	string Parameter1Desc = " (float)";
> {
	pass p0 {
	  VertexShader 	= null;
	  PixelShader 	= compile ps_2_0 Linear();
	  ZEnable 			= false;
	}
}