## torque.vert

uniform float pulsePos;
uniform float pulseAmount;

varying float LightInt;
varying float textureInt;

void main()
	{
	vec4 v = gl_Vertex;
	float pulse = 1.0 + ( pulseAmount / sqrt( abs( gl_Vertex.x - pulsePos ) + 1.0 ) );
	v.y *= pulse;
	v.z *= pulse;
	gl_Position = gl_ModelViewProjectionMatrix * v;

	float d1 = dot( gl_Normal, vec3( 0.0, 1.0, 0.0 ) );
	float d2 = dot( gl_Normal, vec3( 0.0, -1.0, 0.0 ) );
	float d3 = dot( gl_Normal, vec3( 0.0, 0.0, 1.0 ) );
	float d4 = dot( gl_Normal, vec3( 0.0, 0.0, -1.0 ) );
	float k = ( max( max( d1, d2 ), max( d3, d4 ) ) - 0.75 ) * 5.0;
	
	vec3 lightPos = vec3( gl_Vertex.x, 0, sin( gl_Vertex.x ) * 10.0 );
	vec3 ecPos = vec3( gl_ModelViewMatrix * gl_Vertex );
	vec3 tnorm = normalize( gl_NormalMatrix * gl_Normal );
	vec3 lightVec = normalize( lightPos - ecPos );
	vec3 reflectVec = reflect( -lightVec, tnorm );
	vec3 viewVec = normalize( -ecPos );
	
	float diffuse = max( dot( lightVec, tnorm ), 0.0 );
	float spec = 0.0;
	if ( diffuse > 0.0 )
		{
		spec = max( dot( reflectVec, viewVec ), 0.0 );
		spec = pow( spec, 16.0 );
		}
		
	LightInt = min( ( 0.5 * diffuse + 0.5 * spec ) * k, 1.0 );
	textureInt = pow( clamp( gl_Vertex.x * 0.125, 0.0, 1.0 ), 5.0 );
	}

## torque.frag

varying float LightInt;
varying float textureInt;

void main()
	{
	vec4 color = vec4( LightInt + textureInt, 0.0, 0.0, 1.0 );
	color = clamp( color, 0.0, 1.0 );
	gl_FragColor = color;
	}
	