import java.io.*;
import javax.sound.sampled.*;

public class PlaySound implements Runnable{
	String datei = "Donau.wav";

	Float a, b;
	
	boolean an;
	
	PlaySound(float a, float b, boolean an) {
		this.a = 0f;
		this.b = 0f;
		this.an = an;
	}
	public void machsound(String datei) {
		this.datei = datei;
		this.a = 0f;
		this.b = 0f;
		Thread t = new Thread(this);
		t.start();
	}
	public void run(){
		play();
	}
	void play() {
		try {
			playSampleFile(datei, a, b);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	void play(String sound) {
		try {
			playSampleFile(sound, a, b);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	private void playSampleFile(String name, float pan, float gain)
			throws Exception {
		// AudioInputStream ffnen
		AudioInputStream ais = AudioSystem.getAudioInputStream(new File(name));
		AudioFormat format = ais.getFormat();
		// ALAW/ULAW samples in PCM konvertieren
		if ((format.getEncoding() == AudioFormat.Encoding.ULAW)
				|| (format.getEncoding() == AudioFormat.Encoding.ALAW)) {
			AudioFormat tmp = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED,
					format.getSampleRate(), format.getSampleSizeInBits() * 2,
					format.getChannels(), format.getFrameSize() * 2, format
							.getFrameRate(), true);
			ais = AudioSystem.getAudioInputStream(tmp, ais);
			format = tmp;
		}
		// Clip erzeugen und ffnen
		DataLine.Info info = new DataLine.Info(Clip.class, format, ((int) ais
				.getFrameLength() * format.getFrameSize()));
		Clip clip = (Clip) AudioSystem.getLine(info);
		clip.open(ais);
		// PAN einstellen
		FloatControl panControl = (FloatControl) clip
				.getControl(FloatControl.Type.PAN);
		panControl.setValue(pan);
		// MASTER_GAIN einstellen
		FloatControl gainControl = (FloatControl) clip
				.getControl(FloatControl.Type.MASTER_GAIN);
		gainControl.setValue(gain);
		// Clip abspielen
		clip.start();
		while (true) {
			try {
				Thread.sleep(100);
			} catch (Exception e) {
				// nothing
			}
			if (!clip.isRunning()) {
				break;
				
			}
		}
		clip.stop();
		clip.close();
		an = false;
		//System.exit(1);
	}
}
