#include <math.h>

// interfacing
#define esqrt xsqrtf
#define epow xpowf
#define efabs xabsf
#define eabs xabs
#define efloor xfloorf
#define efrand frand_4k
#define erand rand_4k
#define esin sin
#define ecos cos

// squareroot
float  xsqrtf(float i)
{
	__asm fld	i
	__asm fsqrt
}

// pow
float xpowf(float a, float b)
{
	float res;
	_asm fld			dword ptr [b]
	_asm fld			dword ptr [a]
	_asm fyl2x
	_asm fld			st
	_asm frndint
	_asm fsub		st(1),st
	_asm fxch		st(1)
	_asm f2xm1
	_asm fld1
	_asm fadd
	_asm fscale
	_asm fstp		st(1)
	_asm fstp dword ptr [res]
	return res;
}

float xabsf(float i)
{
	__asm fld	i
	__asm fabs
}

int xabs(int i)
{
  return i < 0 ? -i : i;
}

int xfloorf(float x)
{
	x -= 0.5;
  int t;
  _asm fld x
  _asm fistp t
  return t;
}

// random functions
int seed;
int __fastcall rand_4k(void) 
{
	__asm 
	{
		mov		eax, dword ptr [seed]
		imul	eax, 0x000343FD
		add		eax, 0x00269EC3
		mov		dword ptr [seed], eax
		sar		eax, 10
		and		eax, 0x00007FFF
	};
}

float frand_4k(void)
{
  return (float)rand_4k()/16384.f-1.f;
}

float esmoothstep(float t)
{
	return t*t*(3.f-2.f*t);
}
float elerp(float a, float b,float t)
{
  return a+t*(b-a);
}

float eclamp(float v, float min, float max)
{
  return v < min ? min : v > max ? max : v;
}

struct VEC4
{
  float x,y,z,w;
  VEC4(float xp=0,float yp=0,float zp=0,float wp=0) {Init(xp,yp,zp,wp);} // get rid of constructors later
  void Init(float xp=0,float yp=0,float zp=0,float wp=0) {x=xp;y=yp;z=zp;w=wp;}
  void Unit3()
  {
    float l=Length3();
    x/=l;
    y/=l;
    z/=l;
  }
  float Length3()
  {
    return esqrt(x*x+y*y+z*z);
  }
  void AddScale(const VEC4 &a,float s) {x+=a.x*s;y+=a.y*s;z+=a.z*s;w+=a.w*s;}
  VEC4 GetScaled(float s) {VEC4 r;r.Init();r.AddScale(*this,s);return r;}
  void lerp3(const VEC4 &a, const VEC4 &b, float t) {x=elerp(a.x,b.x,t);y=elerp(a.y,b.y,t);z=elerp(a.z,b.z,t);}
  void lerp4(const VEC4 &a, const VEC4 &b, float t) {lerp3(a,b,t);w=elerp(a.w,b.w,t);}
  void scale3(float s){x*=s;y*=s;z*=s;}
  unsigned int GetColor() 
  {
    int r=(int)(x*255.f);
    int g=(int)(y*255.f);
    int b=(int)(z*255.f);
    //int a=(int)(w*255.f);   
    if (r<0) r=0;if (r>255) r=255;
    if (g<0) g=0;if (g>255) g=255;
    if (b<0) b=0;if (b>255) b=255;
    //if (a<0) a=0;if (a>255) a=255;
    return (b)|(g<<8)|(r<<16);
  }
  void InitColor(unsigned int c)
  {
    x = (float)((c>>16) & 255)/255.f;
    y = (float)((c>>8) & 255)/255.f;
    z = (float)(c & 255)/255.f;
    //w = (float)((c>>24) & 255)/255.f;
  }
  void Colorize(const VEC4 &PA, const VEC4 &PB, const float alpha)
  {
    const float mpdsplce = (PA.x+PA.y+PA.z-PB.x-PB.y-PB.z)/3.f;
    x = mpdsplce + PB.x;
    y = mpdsplce + PB.y;
    z = mpdsplce + PB.z;
    lerp3(PA,*this,alpha);
  }
};

float edot3(const VEC4 &v1, const VEC4 &v2)
{
  return v1.x*v2.x+v1.y*v2.y+v1.z*v2.z;
}