/**
 * The Mandelbrot Set
 * by Daniel Shiffman.  
 * 
 * Simple rendering of the Mandelbrot set.
 */
 
// Establish a range of values on the complex plane
// A different range will allow us to "zoom" in or out on the fractal
// float xmin = -1.5; float ymin = -.1; float wh = 0.15;
float xmin = -2.5; 
float ymin = -2; 
float wh = 4;
char vari1=0;
float counter = 0;

float diameter = 184.0; 
float angle_rot=128;

void setup() {
  size(1024, 768);
  background(0);
  smooth();
  frameRate(15);
//  noStroke();
}

void draw() {

  loadPixels();
  
  // Maximum number of iterations for each point on the complex plane
  int maxiterations = 200;

  // x goes from xmin to xmax
  float xmax = xmin + wh;
  // y goes from ymin to ymax
  float ymax = ymin + wh;
  
  // Calculate amount we increment x,y for each pixel
  float lev = (width*(counter*2));
  float kork = (height*(counter*2));
  float dx = (xmax - xmin) / lev;
  float dy = (ymax - ymin) / kork;

  // Start y
  float y = ymin+(counter*(1*counter));
  for(int j = 0; j < height; j++) {
    // Start x
    float x = xmin+(counter*(1*counter));
    for(int i = 0;  i < width; i++) {
      
      // Now we test, as we iterate z = z^2 + cm does z tend towards infinity?
      float a = x;
      float b = y;
      int n = 0;
      while (n < maxiterations) {
        float aa = a * a;
        float bb = b * b;
        float twoab = 2.0 * a * b;
        a = aa - bb + x;
        b = twoab + y;
        // Infinty in our finite world is simple, let's just consider it 16
        if(aa + bb > 16.0+counter) {
          break;  // Bail
        }
        n++;
      }
      
      // We color each pixel based on how long it takes to get to infinity
      // If we never got there, let's pick the color black
     
        // Gosh, we could make fancy colors here if we wanted
          if (n<6)
            pixels[i+j*(int)lev] = color(n*16,n*16,n*16);
          else
            pixels[i+j*(int)lev] = color(n*16,0,0);
      
      x += dx;
    }
    y += dy;
  }
  //updatePixels();
  
  vari1+=20;
  
  //for(int i=0; i<5; i++) {
    pushMatrix();
    rotate(angle_rot + -45);
    ellipse(-116, 0, diameter, diameter);
    popMatrix();
    angle_rot += PI*2/5;
    updatePixels();
  //}
  counter+=0.001;
}

