/**
 * Create Image. 
 * 
 * The createImage() function provides a fresh buffer of pixels to play with.
 * This example creates an image gradient.
 */

PImage img;
PGraphics pg;

int screen_w = 640;
int screen_h = 360;

int iter;
float x, y, z, offset_x, offset_y, persp_z;
float avg_x, avg_y, avg_z;
int col_r, col_g, col_b;

float[] m =
{
  1, 0, 0,
  0, 1, 0,
  0, 0, 1,
};  

float[] p =
{
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

int preset, num_presets = 5;
float[] p2 =
{
  -0.653165, -0.972152, -0.713924, -0.481000,  0.516458, -0.592405,
  -0.268000,  0.827000,  0.379747, -0.943000, -0.072000,  1.200000,
  -0.470000,  0.041000,  0.000000,  0.914000, -0.531646,  0.364557,

  -0.333,  0.290, -0.815, -1.127, -0.479,  1.049, 
   0.857,  0.252, -0.772,  1.066, -0.384,  0.260,
   0.296, -0.655, -0.832,  0.118, -1.098,  0.059,

  -0.325, -1.158, -0.448,  0.229,  0.042, -0.850, 
  -0.349,  1.048,  1.063,  0.319,  0.865,  0.507,
   0.168,  0.353,  0.584, -0.043,  0.903, -0.876,

-0.076, 0.251, -0.294, -0.83,
	            -0.951, 0.755, -0.782, 0.645,
	            0.828, -0.932, -0.504, 0.794,
	            1.034, 0.078, -0.344, -0.39,
	            -0.078, 0.511,

1.099, 0.07, -0.53, -0.657,
	            -0.646, -0.414, -1.062, 0.494,
	            0.016, -0.863, 1.008, -0.057,
	            0.331, 1.046, -0.587, 0.07,
	            0.176, 0.511,
};

void gen_params()
{
  iter = 0;
  x = y = z = 0;
  offset_x = random(screen_w/2) - screen_w/4;
  offset_y = random(screen_h/5) - screen_h/10;
  persp_z = random(1)+0.5;
  avg_x = avg_y = avg_z = 0;
  col_r = round(63 + random(192));
  col_g = round(63 + random(192));
  col_b = round(63 + random(192));

  float a1 = random(2*3.1415926);
  float a2 = random(2*3.1415926);
  m[0] = cos(a1);
  m[1] = 0;
  m[2] = sin(a1);
  m[3] = sin(a1)*sin(a2);
  m[4] = cos(a2);
  m[5] = -cos(a1)*sin(a2);
  m[6] = -sin(a1)*cos(a2);
  m[7] = sin(a2);
  m[8] = cos(a1)*cos(a2);

  preset = round(random(num_presets-1));
  for (int i=0; i<18; i++)
    p[i] = p2[preset*12 + i];
}

void setup() 
{
  size(screen_w, screen_h);  
  background(0);
  pg = createGraphics(screen_w, screen_h, P2D);
  pg.background(0);

  gen_params();
}

color clerp(color c1, int w1, color c2, int w2)
{
  return color(
    min(255, (((c1 >> 16) & 0xFF) * w1 + ((c2 >> 16) & 0xFF) * w2) >> 8),
    min(255, (((c1 >>  8) & 0xFF) * w1 + ((c2 >>  8) & 0xFF) * w2) >> 8),
    min(255, (((c1      ) & 0xFF) * w1 + ((c2      ) & 0xFF) * w2) >> 8));
}

color darken(color c1, int amount)
{
  int r = (c1 >> 16) & 0xFF;
  int g = (c1 >>  8) & 0xFF;
  int b = (c1      ) & 0xFF;
  r = r - (amount*r*r*r >> 24) - 1;
  g = g - (amount*g*g*g >> 24) - 1;
  b = b - (amount*b*b*b >> 24) - 1;
  return color(r, g, b);
}

void draw() 
{
  pg.beginDraw();
  pg.noFill();

  for (int i = 0; i < screen_w*screen_h; i++)
    pg.pixels[i] = darken(pg.pixels[i], 7);

  // p[8] += 0.001;

  iter++;
  if (keyPressed || iter > 40)
    gen_params();
    
  int rp = round(random(17));
  p[rp] += random(0.01)-0.005;
  p[12] += 0.0001;
  
  // iterate
  int pix = 0, max_it = 10000;
  for (int it=0; it<max_it; it++)
  {
    float x0=x, y0=y, z0=z;
    x = p[0]  + x0 * (p[1]  + p[2]*x0  + p[3]*y0)  + y0 * (p[4] + p[5]*y0);
    y = p[6]  + y0 * (p[7]  + p[8]*y0  + p[9]*z0)  + z0 * (p[10] + p[11]*z0);
    z = p[12] + z0 * (p[13] + p[14]*z0 + p[15]*x0) + x0 * (p[16] + p[17]*x0);

    float x2 = x * m[0] + y * m[1] + z * m[2];
    float y2 = x * m[3] + y * m[4] + z * m[5];
    float z2 = x * m[6] + y * m[7] + z * m[8];
        
    avg_x = lerp(avg_x, x2, 0.999);
    avg_y = lerp(avg_y, y2, 0.999);
    avg_z = lerp(avg_z, z2, 0.999);

    // re-gen params, if unstable
    float lsqr = x*x + y*y + z*z;
    if (lsqr < 0.0001 || lsqr > 100)
      gen_params();

    int sz = round(128 + 128 * z);
    int sx = round(screen_w/2 + offset_x + 500000 * (x2-avg_x) / (z2-avg_z+persp_z));
    int sy = round(screen_h/2 + offset_y + 500000 * (y2-avg_y) / (z2-avg_z+persp_z));
    if (sx >= 0 && sx < screen_w && sy >= 0 && sy < screen_h)
    {
      int i = sy * screen_w + sx;
      color c0 = color(col_r, col_g, col_b);
      pg.pixels[i] = clerp(pg.pixels[i], 255, c0, 15);
      pix++;
    }
  }
  pg.endDraw();
  
  if (pix < max_it/3)
    gen_params();
  
  // draw
//  background(0);
//  image(img, 0, 0);
 // image(img, mouseX-60, mouseY-60);
  image(pg, 0, 0);
}
